/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesClusterExtensionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#cluster_id KubernetesClusterExtension#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#configuration_protected_settings KubernetesClusterExtension#configuration_protected_settings}
    */
    readonly configurationProtectedSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#configuration_settings KubernetesClusterExtension#configuration_settings}
    */
    readonly configurationSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#extension_type KubernetesClusterExtension#extension_type}
    */
    readonly extensionType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#id KubernetesClusterExtension#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#name KubernetesClusterExtension#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#release_namespace KubernetesClusterExtension#release_namespace}
    */
    readonly releaseNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#release_train KubernetesClusterExtension#release_train}
    */
    readonly releaseTrain?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#target_namespace KubernetesClusterExtension#target_namespace}
    */
    readonly targetNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#version KubernetesClusterExtension#version}
    */
    readonly version?: string;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#plan KubernetesClusterExtension#plan}
    */
    readonly plan?: KubernetesClusterExtensionPlan;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#timeouts KubernetesClusterExtension#timeouts}
    */
    readonly timeouts?: KubernetesClusterExtensionTimeouts;
}
export interface KubernetesClusterExtensionAksAssignedIdentity {
}
export declare function kubernetesClusterExtensionAksAssignedIdentityToTerraform(struct?: KubernetesClusterExtensionAksAssignedIdentity): any;
export declare function kubernetesClusterExtensionAksAssignedIdentityToHclTerraform(struct?: KubernetesClusterExtensionAksAssignedIdentity): any;
export declare class KubernetesClusterExtensionAksAssignedIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterExtensionAksAssignedIdentity | undefined;
    set internalValue(value: KubernetesClusterExtensionAksAssignedIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class KubernetesClusterExtensionAksAssignedIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterExtensionAksAssignedIdentityOutputReference;
}
export interface KubernetesClusterExtensionPlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#name KubernetesClusterExtension#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#product KubernetesClusterExtension#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#promotion_code KubernetesClusterExtension#promotion_code}
    */
    readonly promotionCode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#publisher KubernetesClusterExtension#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#version KubernetesClusterExtension#version}
    */
    readonly version?: string;
}
export declare function kubernetesClusterExtensionPlanToTerraform(struct?: KubernetesClusterExtensionPlanOutputReference | KubernetesClusterExtensionPlan): any;
export declare function kubernetesClusterExtensionPlanToHclTerraform(struct?: KubernetesClusterExtensionPlanOutputReference | KubernetesClusterExtensionPlan): any;
export declare class KubernetesClusterExtensionPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterExtensionPlan | undefined;
    set internalValue(value: KubernetesClusterExtensionPlan | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _promotionCode?;
    get promotionCode(): string;
    set promotionCode(value: string);
    resetPromotionCode(): void;
    get promotionCodeInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface KubernetesClusterExtensionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#create KubernetesClusterExtension#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#delete KubernetesClusterExtension#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#read KubernetesClusterExtension#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#update KubernetesClusterExtension#update}
    */
    readonly update?: string;
}
export declare function kubernetesClusterExtensionTimeoutsToTerraform(struct?: KubernetesClusterExtensionTimeouts | cdktf.IResolvable): any;
export declare function kubernetesClusterExtensionTimeoutsToHclTerraform(struct?: KubernetesClusterExtensionTimeouts | cdktf.IResolvable): any;
export declare class KubernetesClusterExtensionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterExtensionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterExtensionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension azurerm_kubernetes_cluster_extension}
*/
export declare class KubernetesClusterExtension extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kubernetes_cluster_extension";
    /**
    * Generates CDKTF code for importing a KubernetesClusterExtension resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KubernetesClusterExtension to import
    * @param importFromId The id of the existing KubernetesClusterExtension that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KubernetesClusterExtension to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/kubernetes_cluster_extension azurerm_kubernetes_cluster_extension} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesClusterExtensionConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesClusterExtensionConfig);
    private _aksAssignedIdentity;
    get aksAssignedIdentity(): KubernetesClusterExtensionAksAssignedIdentityList;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _configurationProtectedSettings?;
    get configurationProtectedSettings(): {
        [key: string]: string;
    };
    set configurationProtectedSettings(value: {
        [key: string]: string;
    });
    resetConfigurationProtectedSettings(): void;
    get configurationProtectedSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _configurationSettings?;
    get configurationSettings(): {
        [key: string]: string;
    };
    set configurationSettings(value: {
        [key: string]: string;
    });
    resetConfigurationSettings(): void;
    get configurationSettingsInput(): {
        [key: string]: string;
    } | undefined;
    get currentVersion(): string;
    private _extensionType?;
    get extensionType(): string;
    set extensionType(value: string);
    get extensionTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _releaseNamespace?;
    get releaseNamespace(): string;
    set releaseNamespace(value: string);
    resetReleaseNamespace(): void;
    get releaseNamespaceInput(): string | undefined;
    private _releaseTrain?;
    get releaseTrain(): string;
    set releaseTrain(value: string);
    resetReleaseTrain(): void;
    get releaseTrainInput(): string | undefined;
    private _targetNamespace?;
    get targetNamespace(): string;
    set targetNamespace(value: string);
    resetTargetNamespace(): void;
    get targetNamespaceInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _plan;
    get plan(): KubernetesClusterExtensionPlanOutputReference;
    putPlan(value: KubernetesClusterExtensionPlan): void;
    resetPlan(): void;
    get planInput(): KubernetesClusterExtensionPlan | undefined;
    private _timeouts;
    get timeouts(): KubernetesClusterExtensionTimeoutsOutputReference;
    putTimeouts(value: KubernetesClusterExtensionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KubernetesClusterExtensionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
