/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#backend_address_pool_ids LbRule#backend_address_pool_ids}
    */
    readonly backendAddressPoolIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#backend_port LbRule#backend_port}
    */
    readonly backendPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#disable_outbound_snat LbRule#disable_outbound_snat}
    */
    readonly disableOutboundSnat?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#enable_floating_ip LbRule#enable_floating_ip}
    */
    readonly enableFloatingIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#enable_tcp_reset LbRule#enable_tcp_reset}
    */
    readonly enableTcpReset?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#frontend_ip_configuration_name LbRule#frontend_ip_configuration_name}
    */
    readonly frontendIpConfigurationName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#frontend_port LbRule#frontend_port}
    */
    readonly frontendPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#id LbRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#idle_timeout_in_minutes LbRule#idle_timeout_in_minutes}
    */
    readonly idleTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#load_distribution LbRule#load_distribution}
    */
    readonly loadDistribution?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#loadbalancer_id LbRule#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#name LbRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#probe_id LbRule#probe_id}
    */
    readonly probeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#protocol LbRule#protocol}
    */
    readonly protocol: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#timeouts LbRule#timeouts}
    */
    readonly timeouts?: LbRuleTimeouts;
}
export interface LbRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#create LbRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#delete LbRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#read LbRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#update LbRule#update}
    */
    readonly update?: string;
}
export declare function lbRuleTimeoutsToTerraform(struct?: LbRuleTimeouts | cdktf.IResolvable): any;
export declare function lbRuleTimeoutsToHclTerraform(struct?: LbRuleTimeouts | cdktf.IResolvable): any;
export declare class LbRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LbRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule azurerm_lb_rule}
*/
export declare class LbRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_lb_rule";
    /**
    * Generates CDKTF code for importing a LbRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LbRule to import
    * @param importFromId The id of the existing LbRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LbRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/lb_rule azurerm_lb_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbRuleConfig
    */
    constructor(scope: Construct, id: string, config: LbRuleConfig);
    private _backendAddressPoolIds?;
    get backendAddressPoolIds(): string[];
    set backendAddressPoolIds(value: string[]);
    resetBackendAddressPoolIds(): void;
    get backendAddressPoolIdsInput(): string[] | undefined;
    private _backendPort?;
    get backendPort(): number;
    set backendPort(value: number);
    get backendPortInput(): number | undefined;
    private _disableOutboundSnat?;
    get disableOutboundSnat(): boolean | cdktf.IResolvable;
    set disableOutboundSnat(value: boolean | cdktf.IResolvable);
    resetDisableOutboundSnat(): void;
    get disableOutboundSnatInput(): boolean | cdktf.IResolvable | undefined;
    private _enableFloatingIp?;
    get enableFloatingIp(): boolean | cdktf.IResolvable;
    set enableFloatingIp(value: boolean | cdktf.IResolvable);
    resetEnableFloatingIp(): void;
    get enableFloatingIpInput(): boolean | cdktf.IResolvable | undefined;
    private _enableTcpReset?;
    get enableTcpReset(): boolean | cdktf.IResolvable;
    set enableTcpReset(value: boolean | cdktf.IResolvable);
    resetEnableTcpReset(): void;
    get enableTcpResetInput(): boolean | cdktf.IResolvable | undefined;
    get frontendIpConfigurationId(): string;
    private _frontendIpConfigurationName?;
    get frontendIpConfigurationName(): string;
    set frontendIpConfigurationName(value: string);
    get frontendIpConfigurationNameInput(): string | undefined;
    private _frontendPort?;
    get frontendPort(): number;
    set frontendPort(value: number);
    get frontendPortInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idleTimeoutInMinutes?;
    get idleTimeoutInMinutes(): number;
    set idleTimeoutInMinutes(value: number);
    resetIdleTimeoutInMinutes(): void;
    get idleTimeoutInMinutesInput(): number | undefined;
    private _loadDistribution?;
    get loadDistribution(): string;
    set loadDistribution(value: string);
    resetLoadDistribution(): void;
    get loadDistributionInput(): string | undefined;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _probeId?;
    get probeId(): string;
    set probeId(value: string);
    resetProbeId(): void;
    get probeIdInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _timeouts;
    get timeouts(): LbRuleTimeoutsOutputReference;
    putTimeouts(value: LbRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LbRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
