/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorScheduledQueryRulesAlertV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#auto_mitigation_enabled MonitorScheduledQueryRulesAlertV2#auto_mitigation_enabled}
    */
    readonly autoMitigationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#description MonitorScheduledQueryRulesAlertV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#display_name MonitorScheduledQueryRulesAlertV2#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#enabled MonitorScheduledQueryRulesAlertV2#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#evaluation_frequency MonitorScheduledQueryRulesAlertV2#evaluation_frequency}
    */
    readonly evaluationFrequency: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#id MonitorScheduledQueryRulesAlertV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#location MonitorScheduledQueryRulesAlertV2#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#mute_actions_after_alert_duration MonitorScheduledQueryRulesAlertV2#mute_actions_after_alert_duration}
    */
    readonly muteActionsAfterAlertDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#name MonitorScheduledQueryRulesAlertV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#query_time_range_override MonitorScheduledQueryRulesAlertV2#query_time_range_override}
    */
    readonly queryTimeRangeOverride?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#resource_group_name MonitorScheduledQueryRulesAlertV2#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#scopes MonitorScheduledQueryRulesAlertV2#scopes}
    */
    readonly scopes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#severity MonitorScheduledQueryRulesAlertV2#severity}
    */
    readonly severity: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#skip_query_validation MonitorScheduledQueryRulesAlertV2#skip_query_validation}
    */
    readonly skipQueryValidation?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#tags MonitorScheduledQueryRulesAlertV2#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#target_resource_types MonitorScheduledQueryRulesAlertV2#target_resource_types}
    */
    readonly targetResourceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#window_duration MonitorScheduledQueryRulesAlertV2#window_duration}
    */
    readonly windowDuration: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#workspace_alerts_storage_enabled MonitorScheduledQueryRulesAlertV2#workspace_alerts_storage_enabled}
    */
    readonly workspaceAlertsStorageEnabled?: boolean | cdktf.IResolvable;
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#action MonitorScheduledQueryRulesAlertV2#action}
    */
    readonly action?: MonitorScheduledQueryRulesAlertV2Action;
    /**
    * criteria block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#criteria MonitorScheduledQueryRulesAlertV2#criteria}
    */
    readonly criteria: MonitorScheduledQueryRulesAlertV2Criteria[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#identity MonitorScheduledQueryRulesAlertV2#identity}
    */
    readonly identity?: MonitorScheduledQueryRulesAlertV2Identity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#timeouts MonitorScheduledQueryRulesAlertV2#timeouts}
    */
    readonly timeouts?: MonitorScheduledQueryRulesAlertV2Timeouts;
}
export interface MonitorScheduledQueryRulesAlertV2Action {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#action_groups MonitorScheduledQueryRulesAlertV2#action_groups}
    */
    readonly actionGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#custom_properties MonitorScheduledQueryRulesAlertV2#custom_properties}
    */
    readonly customProperties?: {
        [key: string]: string;
    };
}
export declare function monitorScheduledQueryRulesAlertV2ActionToTerraform(struct?: MonitorScheduledQueryRulesAlertV2ActionOutputReference | MonitorScheduledQueryRulesAlertV2Action): any;
export declare function monitorScheduledQueryRulesAlertV2ActionToHclTerraform(struct?: MonitorScheduledQueryRulesAlertV2ActionOutputReference | MonitorScheduledQueryRulesAlertV2Action): any;
export declare class MonitorScheduledQueryRulesAlertV2ActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorScheduledQueryRulesAlertV2Action | undefined;
    set internalValue(value: MonitorScheduledQueryRulesAlertV2Action | undefined);
    private _actionGroups?;
    get actionGroups(): string[];
    set actionGroups(value: string[]);
    resetActionGroups(): void;
    get actionGroupsInput(): string[] | undefined;
    private _customProperties?;
    get customProperties(): {
        [key: string]: string;
    };
    set customProperties(value: {
        [key: string]: string;
    });
    resetCustomProperties(): void;
    get customPropertiesInput(): {
        [key: string]: string;
    } | undefined;
}
export interface MonitorScheduledQueryRulesAlertV2CriteriaDimension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#name MonitorScheduledQueryRulesAlertV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#operator MonitorScheduledQueryRulesAlertV2#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#values MonitorScheduledQueryRulesAlertV2#values}
    */
    readonly values: string[];
}
export declare function monitorScheduledQueryRulesAlertV2CriteriaDimensionToTerraform(struct?: MonitorScheduledQueryRulesAlertV2CriteriaDimension | cdktf.IResolvable): any;
export declare function monitorScheduledQueryRulesAlertV2CriteriaDimensionToHclTerraform(struct?: MonitorScheduledQueryRulesAlertV2CriteriaDimension | cdktf.IResolvable): any;
export declare class MonitorScheduledQueryRulesAlertV2CriteriaDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorScheduledQueryRulesAlertV2CriteriaDimension | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorScheduledQueryRulesAlertV2CriteriaDimension | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class MonitorScheduledQueryRulesAlertV2CriteriaDimensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorScheduledQueryRulesAlertV2CriteriaDimension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorScheduledQueryRulesAlertV2CriteriaDimensionOutputReference;
}
export interface MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriods {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#minimum_failing_periods_to_trigger_alert MonitorScheduledQueryRulesAlertV2#minimum_failing_periods_to_trigger_alert}
    */
    readonly minimumFailingPeriodsToTriggerAlert: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#number_of_evaluation_periods MonitorScheduledQueryRulesAlertV2#number_of_evaluation_periods}
    */
    readonly numberOfEvaluationPeriods: number;
}
export declare function monitorScheduledQueryRulesAlertV2CriteriaFailingPeriodsToTerraform(struct?: MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriodsOutputReference | MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriods): any;
export declare function monitorScheduledQueryRulesAlertV2CriteriaFailingPeriodsToHclTerraform(struct?: MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriodsOutputReference | MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriods): any;
export declare class MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriodsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriods | undefined;
    set internalValue(value: MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriods | undefined);
    private _minimumFailingPeriodsToTriggerAlert?;
    get minimumFailingPeriodsToTriggerAlert(): number;
    set minimumFailingPeriodsToTriggerAlert(value: number);
    get minimumFailingPeriodsToTriggerAlertInput(): number | undefined;
    private _numberOfEvaluationPeriods?;
    get numberOfEvaluationPeriods(): number;
    set numberOfEvaluationPeriods(value: number);
    get numberOfEvaluationPeriodsInput(): number | undefined;
}
export interface MonitorScheduledQueryRulesAlertV2Criteria {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#metric_measure_column MonitorScheduledQueryRulesAlertV2#metric_measure_column}
    */
    readonly metricMeasureColumn?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#operator MonitorScheduledQueryRulesAlertV2#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#query MonitorScheduledQueryRulesAlertV2#query}
    */
    readonly query: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#resource_id_column MonitorScheduledQueryRulesAlertV2#resource_id_column}
    */
    readonly resourceIdColumn?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#threshold MonitorScheduledQueryRulesAlertV2#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#time_aggregation_method MonitorScheduledQueryRulesAlertV2#time_aggregation_method}
    */
    readonly timeAggregationMethod: string;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#dimension MonitorScheduledQueryRulesAlertV2#dimension}
    */
    readonly dimension?: MonitorScheduledQueryRulesAlertV2CriteriaDimension[] | cdktf.IResolvable;
    /**
    * failing_periods block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#failing_periods MonitorScheduledQueryRulesAlertV2#failing_periods}
    */
    readonly failingPeriods?: MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriods;
}
export declare function monitorScheduledQueryRulesAlertV2CriteriaToTerraform(struct?: MonitorScheduledQueryRulesAlertV2Criteria | cdktf.IResolvable): any;
export declare function monitorScheduledQueryRulesAlertV2CriteriaToHclTerraform(struct?: MonitorScheduledQueryRulesAlertV2Criteria | cdktf.IResolvable): any;
export declare class MonitorScheduledQueryRulesAlertV2CriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorScheduledQueryRulesAlertV2Criteria | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorScheduledQueryRulesAlertV2Criteria | cdktf.IResolvable | undefined);
    private _metricMeasureColumn?;
    get metricMeasureColumn(): string;
    set metricMeasureColumn(value: string);
    resetMetricMeasureColumn(): void;
    get metricMeasureColumnInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _resourceIdColumn?;
    get resourceIdColumn(): string;
    set resourceIdColumn(value: string);
    resetResourceIdColumn(): void;
    get resourceIdColumnInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _timeAggregationMethod?;
    get timeAggregationMethod(): string;
    set timeAggregationMethod(value: string);
    get timeAggregationMethodInput(): string | undefined;
    private _dimension;
    get dimension(): MonitorScheduledQueryRulesAlertV2CriteriaDimensionList;
    putDimension(value: MonitorScheduledQueryRulesAlertV2CriteriaDimension[] | cdktf.IResolvable): void;
    resetDimension(): void;
    get dimensionInput(): cdktf.IResolvable | MonitorScheduledQueryRulesAlertV2CriteriaDimension[] | undefined;
    private _failingPeriods;
    get failingPeriods(): MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriodsOutputReference;
    putFailingPeriods(value: MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriods): void;
    resetFailingPeriods(): void;
    get failingPeriodsInput(): MonitorScheduledQueryRulesAlertV2CriteriaFailingPeriods | undefined;
}
export declare class MonitorScheduledQueryRulesAlertV2CriteriaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorScheduledQueryRulesAlertV2Criteria[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorScheduledQueryRulesAlertV2CriteriaOutputReference;
}
export interface MonitorScheduledQueryRulesAlertV2Identity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#identity_ids MonitorScheduledQueryRulesAlertV2#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#type MonitorScheduledQueryRulesAlertV2#type}
    */
    readonly type: string;
}
export declare function monitorScheduledQueryRulesAlertV2IdentityToTerraform(struct?: MonitorScheduledQueryRulesAlertV2IdentityOutputReference | MonitorScheduledQueryRulesAlertV2Identity): any;
export declare function monitorScheduledQueryRulesAlertV2IdentityToHclTerraform(struct?: MonitorScheduledQueryRulesAlertV2IdentityOutputReference | MonitorScheduledQueryRulesAlertV2Identity): any;
export declare class MonitorScheduledQueryRulesAlertV2IdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorScheduledQueryRulesAlertV2Identity | undefined;
    set internalValue(value: MonitorScheduledQueryRulesAlertV2Identity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MonitorScheduledQueryRulesAlertV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#create MonitorScheduledQueryRulesAlertV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#delete MonitorScheduledQueryRulesAlertV2#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#read MonitorScheduledQueryRulesAlertV2#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#update MonitorScheduledQueryRulesAlertV2#update}
    */
    readonly update?: string;
}
export declare function monitorScheduledQueryRulesAlertV2TimeoutsToTerraform(struct?: MonitorScheduledQueryRulesAlertV2Timeouts | cdktf.IResolvable): any;
export declare function monitorScheduledQueryRulesAlertV2TimeoutsToHclTerraform(struct?: MonitorScheduledQueryRulesAlertV2Timeouts | cdktf.IResolvable): any;
export declare class MonitorScheduledQueryRulesAlertV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorScheduledQueryRulesAlertV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorScheduledQueryRulesAlertV2Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2 azurerm_monitor_scheduled_query_rules_alert_v2}
*/
export declare class MonitorScheduledQueryRulesAlertV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_scheduled_query_rules_alert_v2";
    /**
    * Generates CDKTF code for importing a MonitorScheduledQueryRulesAlertV2 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MonitorScheduledQueryRulesAlertV2 to import
    * @param importFromId The id of the existing MonitorScheduledQueryRulesAlertV2 that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MonitorScheduledQueryRulesAlertV2 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/monitor_scheduled_query_rules_alert_v2 azurerm_monitor_scheduled_query_rules_alert_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorScheduledQueryRulesAlertV2Config
    */
    constructor(scope: Construct, id: string, config: MonitorScheduledQueryRulesAlertV2Config);
    private _autoMitigationEnabled?;
    get autoMitigationEnabled(): boolean | cdktf.IResolvable;
    set autoMitigationEnabled(value: boolean | cdktf.IResolvable);
    resetAutoMitigationEnabled(): void;
    get autoMitigationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get createdWithApiVersion(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evaluationFrequency?;
    get evaluationFrequency(): string;
    set evaluationFrequency(value: string);
    get evaluationFrequencyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get isALegacyLogAnalyticsRule(): cdktf.IResolvable;
    get isWorkspaceAlertsStorageConfigured(): cdktf.IResolvable;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _muteActionsAfterAlertDuration?;
    get muteActionsAfterAlertDuration(): string;
    set muteActionsAfterAlertDuration(value: string);
    resetMuteActionsAfterAlertDuration(): void;
    get muteActionsAfterAlertDurationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _queryTimeRangeOverride?;
    get queryTimeRangeOverride(): string;
    set queryTimeRangeOverride(value: string);
    resetQueryTimeRangeOverride(): void;
    get queryTimeRangeOverrideInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    private _severity?;
    get severity(): number;
    set severity(value: number);
    get severityInput(): number | undefined;
    private _skipQueryValidation?;
    get skipQueryValidation(): boolean | cdktf.IResolvable;
    set skipQueryValidation(value: boolean | cdktf.IResolvable);
    resetSkipQueryValidation(): void;
    get skipQueryValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _targetResourceTypes?;
    get targetResourceTypes(): string[];
    set targetResourceTypes(value: string[]);
    resetTargetResourceTypes(): void;
    get targetResourceTypesInput(): string[] | undefined;
    private _windowDuration?;
    get windowDuration(): string;
    set windowDuration(value: string);
    get windowDurationInput(): string | undefined;
    private _workspaceAlertsStorageEnabled?;
    get workspaceAlertsStorageEnabled(): boolean | cdktf.IResolvable;
    set workspaceAlertsStorageEnabled(value: boolean | cdktf.IResolvable);
    resetWorkspaceAlertsStorageEnabled(): void;
    get workspaceAlertsStorageEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _action;
    get action(): MonitorScheduledQueryRulesAlertV2ActionOutputReference;
    putAction(value: MonitorScheduledQueryRulesAlertV2Action): void;
    resetAction(): void;
    get actionInput(): MonitorScheduledQueryRulesAlertV2Action | undefined;
    private _criteria;
    get criteria(): MonitorScheduledQueryRulesAlertV2CriteriaList;
    putCriteria(value: MonitorScheduledQueryRulesAlertV2Criteria[] | cdktf.IResolvable): void;
    get criteriaInput(): cdktf.IResolvable | MonitorScheduledQueryRulesAlertV2Criteria[] | undefined;
    private _identity;
    get identity(): MonitorScheduledQueryRulesAlertV2IdentityOutputReference;
    putIdentity(value: MonitorScheduledQueryRulesAlertV2Identity): void;
    resetIdentity(): void;
    get identityInput(): MonitorScheduledQueryRulesAlertV2Identity | undefined;
    private _timeouts;
    get timeouts(): MonitorScheduledQueryRulesAlertV2TimeoutsOutputReference;
    putTimeouts(value: MonitorScheduledQueryRulesAlertV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorScheduledQueryRulesAlertV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
