/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlJobTargetGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#id MssqlJobTargetGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#job_agent_id MssqlJobTargetGroup#job_agent_id}
    */
    readonly jobAgentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#name MssqlJobTargetGroup#name}
    */
    readonly name: string;
    /**
    * job_target block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#job_target MssqlJobTargetGroup#job_target}
    */
    readonly jobTarget?: MssqlJobTargetGroupJobTarget[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#timeouts MssqlJobTargetGroup#timeouts}
    */
    readonly timeouts?: MssqlJobTargetGroupTimeouts;
}
export interface MssqlJobTargetGroupJobTarget {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#database_name MssqlJobTargetGroup#database_name}
    */
    readonly databaseName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#elastic_pool_name MssqlJobTargetGroup#elastic_pool_name}
    */
    readonly elasticPoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#job_credential_id MssqlJobTargetGroup#job_credential_id}
    */
    readonly jobCredentialId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#membership_type MssqlJobTargetGroup#membership_type}
    */
    readonly membershipType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#server_name MssqlJobTargetGroup#server_name}
    */
    readonly serverName: string;
}
export declare function mssqlJobTargetGroupJobTargetToTerraform(struct?: MssqlJobTargetGroupJobTarget | cdktf.IResolvable): any;
export declare function mssqlJobTargetGroupJobTargetToHclTerraform(struct?: MssqlJobTargetGroupJobTarget | cdktf.IResolvable): any;
export declare class MssqlJobTargetGroupJobTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MssqlJobTargetGroupJobTarget | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlJobTargetGroupJobTarget | cdktf.IResolvable | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    resetDatabaseName(): void;
    get databaseNameInput(): string | undefined;
    private _elasticPoolName?;
    get elasticPoolName(): string;
    set elasticPoolName(value: string);
    resetElasticPoolName(): void;
    get elasticPoolNameInput(): string | undefined;
    private _jobCredentialId?;
    get jobCredentialId(): string;
    set jobCredentialId(value: string);
    resetJobCredentialId(): void;
    get jobCredentialIdInput(): string | undefined;
    private _membershipType?;
    get membershipType(): string;
    set membershipType(value: string);
    resetMembershipType(): void;
    get membershipTypeInput(): string | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    get type(): string;
}
export declare class MssqlJobTargetGroupJobTargetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MssqlJobTargetGroupJobTarget[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MssqlJobTargetGroupJobTargetOutputReference;
}
export interface MssqlJobTargetGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#create MssqlJobTargetGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#delete MssqlJobTargetGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#read MssqlJobTargetGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#update MssqlJobTargetGroup#update}
    */
    readonly update?: string;
}
export declare function mssqlJobTargetGroupTimeoutsToTerraform(struct?: MssqlJobTargetGroupTimeouts | cdktf.IResolvable): any;
export declare function mssqlJobTargetGroupTimeoutsToHclTerraform(struct?: MssqlJobTargetGroupTimeouts | cdktf.IResolvable): any;
export declare class MssqlJobTargetGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlJobTargetGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlJobTargetGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group azurerm_mssql_job_target_group}
*/
export declare class MssqlJobTargetGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_job_target_group";
    /**
    * Generates CDKTF code for importing a MssqlJobTargetGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MssqlJobTargetGroup to import
    * @param importFromId The id of the existing MssqlJobTargetGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MssqlJobTargetGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_job_target_group azurerm_mssql_job_target_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlJobTargetGroupConfig
    */
    constructor(scope: Construct, id: string, config: MssqlJobTargetGroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jobAgentId?;
    get jobAgentId(): string;
    set jobAgentId(value: string);
    get jobAgentIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _jobTarget;
    get jobTarget(): MssqlJobTargetGroupJobTargetList;
    putJobTarget(value: MssqlJobTargetGroupJobTarget[] | cdktf.IResolvable): void;
    resetJobTarget(): void;
    get jobTargetInput(): cdktf.IResolvable | MssqlJobTargetGroupJobTarget[] | undefined;
    private _timeouts;
    get timeouts(): MssqlJobTargetGroupTimeoutsOutputReference;
    putTimeouts(value: MssqlJobTargetGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlJobTargetGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
