/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlVirtualMachineAvailabilityGroupListenerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#availability_group_name MssqlVirtualMachineAvailabilityGroupListener#availability_group_name}
    */
    readonly availabilityGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#id MssqlVirtualMachineAvailabilityGroupListener#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#name MssqlVirtualMachineAvailabilityGroupListener#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#port MssqlVirtualMachineAvailabilityGroupListener#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#sql_virtual_machine_group_id MssqlVirtualMachineAvailabilityGroupListener#sql_virtual_machine_group_id}
    */
    readonly sqlVirtualMachineGroupId: string;
    /**
    * load_balancer_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#load_balancer_configuration MssqlVirtualMachineAvailabilityGroupListener#load_balancer_configuration}
    */
    readonly loadBalancerConfiguration?: MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration;
    /**
    * multi_subnet_ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#multi_subnet_ip_configuration MssqlVirtualMachineAvailabilityGroupListener#multi_subnet_ip_configuration}
    */
    readonly multiSubnetIpConfiguration?: MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration[] | cdktf.IResolvable;
    /**
    * replica block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#replica MssqlVirtualMachineAvailabilityGroupListener#replica}
    */
    readonly replica: MssqlVirtualMachineAvailabilityGroupListenerReplica[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#timeouts MssqlVirtualMachineAvailabilityGroupListener#timeouts}
    */
    readonly timeouts?: MssqlVirtualMachineAvailabilityGroupListenerTimeouts;
}
export interface MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#load_balancer_id MssqlVirtualMachineAvailabilityGroupListener#load_balancer_id}
    */
    readonly loadBalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#private_ip_address MssqlVirtualMachineAvailabilityGroupListener#private_ip_address}
    */
    readonly privateIpAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#probe_port MssqlVirtualMachineAvailabilityGroupListener#probe_port}
    */
    readonly probePort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#sql_virtual_machine_ids MssqlVirtualMachineAvailabilityGroupListener#sql_virtual_machine_ids}
    */
    readonly sqlVirtualMachineIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#subnet_id MssqlVirtualMachineAvailabilityGroupListener#subnet_id}
    */
    readonly subnetId: string;
}
export declare function mssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationToTerraform(struct?: MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationOutputReference | MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration): any;
export declare function mssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationToHclTerraform(struct?: MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationOutputReference | MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration): any;
export declare class MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration | undefined;
    set internalValue(value: MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration | undefined);
    private _loadBalancerId?;
    get loadBalancerId(): string;
    set loadBalancerId(value: string);
    get loadBalancerIdInput(): string | undefined;
    private _privateIpAddress?;
    get privateIpAddress(): string;
    set privateIpAddress(value: string);
    get privateIpAddressInput(): string | undefined;
    private _probePort?;
    get probePort(): number;
    set probePort(value: number);
    get probePortInput(): number | undefined;
    private _sqlVirtualMachineIds?;
    get sqlVirtualMachineIds(): string[];
    set sqlVirtualMachineIds(value: string[]);
    get sqlVirtualMachineIdsInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export interface MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#private_ip_address MssqlVirtualMachineAvailabilityGroupListener#private_ip_address}
    */
    readonly privateIpAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#sql_virtual_machine_id MssqlVirtualMachineAvailabilityGroupListener#sql_virtual_machine_id}
    */
    readonly sqlVirtualMachineId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#subnet_id MssqlVirtualMachineAvailabilityGroupListener#subnet_id}
    */
    readonly subnetId: string;
}
export declare function mssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationToTerraform(struct?: MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration | cdktf.IResolvable): any;
export declare function mssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationToHclTerraform(struct?: MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration | cdktf.IResolvable): any;
export declare class MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration | cdktf.IResolvable | undefined);
    private _privateIpAddress?;
    get privateIpAddress(): string;
    set privateIpAddress(value: string);
    get privateIpAddressInput(): string | undefined;
    private _sqlVirtualMachineId?;
    get sqlVirtualMachineId(): string;
    set sqlVirtualMachineId(value: string);
    get sqlVirtualMachineIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationOutputReference;
}
export interface MssqlVirtualMachineAvailabilityGroupListenerReplica {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#commit MssqlVirtualMachineAvailabilityGroupListener#commit}
    */
    readonly commit: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#failover_mode MssqlVirtualMachineAvailabilityGroupListener#failover_mode}
    */
    readonly failoverMode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#readable_secondary MssqlVirtualMachineAvailabilityGroupListener#readable_secondary}
    */
    readonly readableSecondary: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#role MssqlVirtualMachineAvailabilityGroupListener#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#sql_virtual_machine_id MssqlVirtualMachineAvailabilityGroupListener#sql_virtual_machine_id}
    */
    readonly sqlVirtualMachineId: string;
}
export declare function mssqlVirtualMachineAvailabilityGroupListenerReplicaToTerraform(struct?: MssqlVirtualMachineAvailabilityGroupListenerReplica | cdktf.IResolvable): any;
export declare function mssqlVirtualMachineAvailabilityGroupListenerReplicaToHclTerraform(struct?: MssqlVirtualMachineAvailabilityGroupListenerReplica | cdktf.IResolvable): any;
export declare class MssqlVirtualMachineAvailabilityGroupListenerReplicaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MssqlVirtualMachineAvailabilityGroupListenerReplica | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlVirtualMachineAvailabilityGroupListenerReplica | cdktf.IResolvable | undefined);
    private _commit?;
    get commit(): string;
    set commit(value: string);
    get commitInput(): string | undefined;
    private _failoverMode?;
    get failoverMode(): string;
    set failoverMode(value: string);
    get failoverModeInput(): string | undefined;
    private _readableSecondary?;
    get readableSecondary(): string;
    set readableSecondary(value: string);
    get readableSecondaryInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _sqlVirtualMachineId?;
    get sqlVirtualMachineId(): string;
    set sqlVirtualMachineId(value: string);
    get sqlVirtualMachineIdInput(): string | undefined;
}
export declare class MssqlVirtualMachineAvailabilityGroupListenerReplicaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MssqlVirtualMachineAvailabilityGroupListenerReplica[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MssqlVirtualMachineAvailabilityGroupListenerReplicaOutputReference;
}
export interface MssqlVirtualMachineAvailabilityGroupListenerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#create MssqlVirtualMachineAvailabilityGroupListener#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#delete MssqlVirtualMachineAvailabilityGroupListener#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#read MssqlVirtualMachineAvailabilityGroupListener#read}
    */
    readonly read?: string;
}
export declare function mssqlVirtualMachineAvailabilityGroupListenerTimeoutsToTerraform(struct?: MssqlVirtualMachineAvailabilityGroupListenerTimeouts | cdktf.IResolvable): any;
export declare function mssqlVirtualMachineAvailabilityGroupListenerTimeoutsToHclTerraform(struct?: MssqlVirtualMachineAvailabilityGroupListenerTimeouts | cdktf.IResolvable): any;
export declare class MssqlVirtualMachineAvailabilityGroupListenerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineAvailabilityGroupListenerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlVirtualMachineAvailabilityGroupListenerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener azurerm_mssql_virtual_machine_availability_group_listener}
*/
export declare class MssqlVirtualMachineAvailabilityGroupListener extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_virtual_machine_availability_group_listener";
    /**
    * Generates CDKTF code for importing a MssqlVirtualMachineAvailabilityGroupListener resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MssqlVirtualMachineAvailabilityGroupListener to import
    * @param importFromId The id of the existing MssqlVirtualMachineAvailabilityGroupListener that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MssqlVirtualMachineAvailabilityGroupListener to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/mssql_virtual_machine_availability_group_listener azurerm_mssql_virtual_machine_availability_group_listener} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlVirtualMachineAvailabilityGroupListenerConfig
    */
    constructor(scope: Construct, id: string, config: MssqlVirtualMachineAvailabilityGroupListenerConfig);
    private _availabilityGroupName?;
    get availabilityGroupName(): string;
    set availabilityGroupName(value: string);
    resetAvailabilityGroupName(): void;
    get availabilityGroupNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _sqlVirtualMachineGroupId?;
    get sqlVirtualMachineGroupId(): string;
    set sqlVirtualMachineGroupId(value: string);
    get sqlVirtualMachineGroupIdInput(): string | undefined;
    private _loadBalancerConfiguration;
    get loadBalancerConfiguration(): MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationOutputReference;
    putLoadBalancerConfiguration(value: MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration): void;
    resetLoadBalancerConfiguration(): void;
    get loadBalancerConfigurationInput(): MssqlVirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration | undefined;
    private _multiSubnetIpConfiguration;
    get multiSubnetIpConfiguration(): MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationList;
    putMultiSubnetIpConfiguration(value: MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration[] | cdktf.IResolvable): void;
    resetMultiSubnetIpConfiguration(): void;
    get multiSubnetIpConfigurationInput(): cdktf.IResolvable | MssqlVirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration[] | undefined;
    private _replica;
    get replica(): MssqlVirtualMachineAvailabilityGroupListenerReplicaList;
    putReplica(value: MssqlVirtualMachineAvailabilityGroupListenerReplica[] | cdktf.IResolvable): void;
    get replicaInput(): cdktf.IResolvable | MssqlVirtualMachineAvailabilityGroupListenerReplica[] | undefined;
    private _timeouts;
    get timeouts(): MssqlVirtualMachineAvailabilityGroupListenerTimeoutsOutputReference;
    putTimeouts(value: MssqlVirtualMachineAvailabilityGroupListenerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlVirtualMachineAvailabilityGroupListenerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
