/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkFunctionCollectorPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#id NetworkFunctionCollectorPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#location NetworkFunctionCollectorPolicy#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#name NetworkFunctionCollectorPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#tags NetworkFunctionCollectorPolicy#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#traffic_collector_id NetworkFunctionCollectorPolicy#traffic_collector_id}
    */
    readonly trafficCollectorId: string;
    /**
    * ipfx_emission block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#ipfx_emission NetworkFunctionCollectorPolicy#ipfx_emission}
    */
    readonly ipfxEmission: NetworkFunctionCollectorPolicyIpfxEmission;
    /**
    * ipfx_ingestion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#ipfx_ingestion NetworkFunctionCollectorPolicy#ipfx_ingestion}
    */
    readonly ipfxIngestion: NetworkFunctionCollectorPolicyIpfxIngestion;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#timeouts NetworkFunctionCollectorPolicy#timeouts}
    */
    readonly timeouts?: NetworkFunctionCollectorPolicyTimeouts;
}
export interface NetworkFunctionCollectorPolicyIpfxEmission {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#destination_types NetworkFunctionCollectorPolicy#destination_types}
    */
    readonly destinationTypes: string[];
}
export declare function networkFunctionCollectorPolicyIpfxEmissionToTerraform(struct?: NetworkFunctionCollectorPolicyIpfxEmissionOutputReference | NetworkFunctionCollectorPolicyIpfxEmission): any;
export declare function networkFunctionCollectorPolicyIpfxEmissionToHclTerraform(struct?: NetworkFunctionCollectorPolicyIpfxEmissionOutputReference | NetworkFunctionCollectorPolicyIpfxEmission): any;
export declare class NetworkFunctionCollectorPolicyIpfxEmissionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkFunctionCollectorPolicyIpfxEmission | undefined;
    set internalValue(value: NetworkFunctionCollectorPolicyIpfxEmission | undefined);
    private _destinationTypes?;
    get destinationTypes(): string[];
    set destinationTypes(value: string[]);
    get destinationTypesInput(): string[] | undefined;
}
export interface NetworkFunctionCollectorPolicyIpfxIngestion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#source_resource_ids NetworkFunctionCollectorPolicy#source_resource_ids}
    */
    readonly sourceResourceIds: string[];
}
export declare function networkFunctionCollectorPolicyIpfxIngestionToTerraform(struct?: NetworkFunctionCollectorPolicyIpfxIngestionOutputReference | NetworkFunctionCollectorPolicyIpfxIngestion): any;
export declare function networkFunctionCollectorPolicyIpfxIngestionToHclTerraform(struct?: NetworkFunctionCollectorPolicyIpfxIngestionOutputReference | NetworkFunctionCollectorPolicyIpfxIngestion): any;
export declare class NetworkFunctionCollectorPolicyIpfxIngestionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkFunctionCollectorPolicyIpfxIngestion | undefined;
    set internalValue(value: NetworkFunctionCollectorPolicyIpfxIngestion | undefined);
    private _sourceResourceIds?;
    get sourceResourceIds(): string[];
    set sourceResourceIds(value: string[]);
    get sourceResourceIdsInput(): string[] | undefined;
}
export interface NetworkFunctionCollectorPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#create NetworkFunctionCollectorPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#delete NetworkFunctionCollectorPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#read NetworkFunctionCollectorPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#update NetworkFunctionCollectorPolicy#update}
    */
    readonly update?: string;
}
export declare function networkFunctionCollectorPolicyTimeoutsToTerraform(struct?: NetworkFunctionCollectorPolicyTimeouts | cdktf.IResolvable): any;
export declare function networkFunctionCollectorPolicyTimeoutsToHclTerraform(struct?: NetworkFunctionCollectorPolicyTimeouts | cdktf.IResolvable): any;
export declare class NetworkFunctionCollectorPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkFunctionCollectorPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkFunctionCollectorPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy azurerm_network_function_collector_policy}
*/
export declare class NetworkFunctionCollectorPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_function_collector_policy";
    /**
    * Generates CDKTF code for importing a NetworkFunctionCollectorPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetworkFunctionCollectorPolicy to import
    * @param importFromId The id of the existing NetworkFunctionCollectorPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetworkFunctionCollectorPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/network_function_collector_policy azurerm_network_function_collector_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkFunctionCollectorPolicyConfig
    */
    constructor(scope: Construct, id: string, config: NetworkFunctionCollectorPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _trafficCollectorId?;
    get trafficCollectorId(): string;
    set trafficCollectorId(value: string);
    get trafficCollectorIdInput(): string | undefined;
    private _ipfxEmission;
    get ipfxEmission(): NetworkFunctionCollectorPolicyIpfxEmissionOutputReference;
    putIpfxEmission(value: NetworkFunctionCollectorPolicyIpfxEmission): void;
    get ipfxEmissionInput(): NetworkFunctionCollectorPolicyIpfxEmission | undefined;
    private _ipfxIngestion;
    get ipfxIngestion(): NetworkFunctionCollectorPolicyIpfxIngestionOutputReference;
    putIpfxIngestion(value: NetworkFunctionCollectorPolicyIpfxIngestion): void;
    get ipfxIngestionInput(): NetworkFunctionCollectorPolicyIpfxIngestion | undefined;
    private _timeouts;
    get timeouts(): NetworkFunctionCollectorPolicyTimeoutsOutputReference;
    putTimeouts(value: NetworkFunctionCollectorPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkFunctionCollectorPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
