/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PaloAltoNextGenerationFirewallVirtualHubLocalRulestackConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#id PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#marketplace_offer_id PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#marketplace_offer_id}
    */
    readonly marketplaceOfferId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#name PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#plan_id PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#plan_id}
    */
    readonly planId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#resource_group_name PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#rulestack_id PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#rulestack_id}
    */
    readonly rulestackId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#tags PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * destination_nat block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#destination_nat PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#destination_nat}
    */
    readonly destinationNat?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNat[] | cdktf.IResolvable;
    /**
    * dns_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#dns_settings PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#dns_settings}
    */
    readonly dnsSettings?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettings;
    /**
    * network_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#network_profile PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#network_profile}
    */
    readonly networkProfile: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfile;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#timeouts PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#timeouts}
    */
    readonly timeouts?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeouts;
}
export interface PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#port PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#public_ip_address PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#public_ip_address}
    */
    readonly publicIpAddress: string;
}
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfigToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfig): any;
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfigToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfig): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfig | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfig | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _publicIpAddress?;
    get publicIpAddress(): string;
    set publicIpAddress(value: string);
    get publicIpAddressInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#port PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#public_ip_address_id PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#public_ip_address_id}
    */
    readonly publicIpAddressId: string;
}
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfigToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfig): any;
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfigToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfig): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfig | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfig | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    get publicIpAddressIdInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNat {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#name PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#protocol PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#protocol}
    */
    readonly protocol: string;
    /**
    * backend_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#backend_config PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#backend_config}
    */
    readonly backendConfig?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfig;
    /**
    * frontend_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#frontend_config PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#frontend_config}
    */
    readonly frontendConfig?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfig;
}
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNat | cdktf.IResolvable): any;
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNat | cdktf.IResolvable): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNat | cdktf.IResolvable | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNat | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _backendConfig;
    get backendConfig(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfigOutputReference;
    putBackendConfig(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfig): void;
    resetBackendConfig(): void;
    get backendConfigInput(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatBackendConfig | undefined;
    private _frontendConfig;
    get frontendConfig(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfigOutputReference;
    putFrontendConfig(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfig): void;
    resetFrontendConfig(): void;
    get frontendConfigInput(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatFrontendConfig | undefined;
}
export declare class PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNat[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatOutputReference;
}
export interface PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#dns_servers PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#use_azure_dns PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#use_azure_dns}
    */
    readonly useAzureDns?: boolean | cdktf.IResolvable;
}
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettingsToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettingsOutputReference | PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettings): any;
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettingsToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettingsOutputReference | PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettings): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettings | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettings | undefined);
    get azureDnsServers(): string[];
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _useAzureDns?;
    get useAzureDns(): boolean | cdktf.IResolvable;
    set useAzureDns(value: boolean | cdktf.IResolvable);
    resetUseAzureDns(): void;
    get useAzureDnsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#egress_nat_ip_address_ids PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#egress_nat_ip_address_ids}
    */
    readonly egressNatIpAddressIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#network_virtual_appliance_id PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#network_virtual_appliance_id}
    */
    readonly networkVirtualApplianceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#public_ip_address_ids PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#public_ip_address_ids}
    */
    readonly publicIpAddressIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#trusted_address_ranges PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#trusted_address_ranges}
    */
    readonly trustedAddressRanges?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#virtual_hub_id PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#virtual_hub_id}
    */
    readonly virtualHubId: string;
}
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfileToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfileOutputReference | PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfile): any;
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfileToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfileOutputReference | PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfile): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfile | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfile | undefined);
    private _egressNatIpAddressIds?;
    get egressNatIpAddressIds(): string[];
    set egressNatIpAddressIds(value: string[]);
    resetEgressNatIpAddressIds(): void;
    get egressNatIpAddressIdsInput(): string[] | undefined;
    get egressNatIpAddresses(): string[];
    get ipOfTrustForUserDefinedRoutes(): string;
    private _networkVirtualApplianceId?;
    get networkVirtualApplianceId(): string;
    set networkVirtualApplianceId(value: string);
    get networkVirtualApplianceIdInput(): string | undefined;
    private _publicIpAddressIds?;
    get publicIpAddressIds(): string[];
    set publicIpAddressIds(value: string[]);
    get publicIpAddressIdsInput(): string[] | undefined;
    get publicIpAddresses(): string[];
    private _trustedAddressRanges?;
    get trustedAddressRanges(): string[];
    set trustedAddressRanges(value: string[]);
    resetTrustedAddressRanges(): void;
    get trustedAddressRangesInput(): string[] | undefined;
    get trustedSubnetId(): string;
    get untrustedSubnetId(): string;
    private _virtualHubId?;
    get virtualHubId(): string;
    set virtualHubId(value: string);
    get virtualHubIdInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#create PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#delete PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#read PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#update PaloAltoNextGenerationFirewallVirtualHubLocalRulestack#update}
    */
    readonly update?: string;
}
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeoutsToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeouts | cdktf.IResolvable): any;
export declare function paloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeoutsToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeouts | cdktf.IResolvable): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack azurerm_palo_alto_next_generation_firewall_virtual_hub_local_rulestack}
*/
export declare class PaloAltoNextGenerationFirewallVirtualHubLocalRulestack extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_palo_alto_next_generation_firewall_virtual_hub_local_rulestack";
    /**
    * Generates CDKTF code for importing a PaloAltoNextGenerationFirewallVirtualHubLocalRulestack resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PaloAltoNextGenerationFirewallVirtualHubLocalRulestack to import
    * @param importFromId The id of the existing PaloAltoNextGenerationFirewallVirtualHubLocalRulestack that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PaloAltoNextGenerationFirewallVirtualHubLocalRulestack to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_local_rulestack azurerm_palo_alto_next_generation_firewall_virtual_hub_local_rulestack} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PaloAltoNextGenerationFirewallVirtualHubLocalRulestackConfig
    */
    constructor(scope: Construct, id: string, config: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _marketplaceOfferId?;
    get marketplaceOfferId(): string;
    set marketplaceOfferId(value: string);
    resetMarketplaceOfferId(): void;
    get marketplaceOfferIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _planId?;
    get planId(): string;
    set planId(value: string);
    resetPlanId(): void;
    get planIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _rulestackId?;
    get rulestackId(): string;
    set rulestackId(value: string);
    get rulestackIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _destinationNat;
    get destinationNat(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNatList;
    putDestinationNat(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNat[] | cdktf.IResolvable): void;
    resetDestinationNat(): void;
    get destinationNatInput(): cdktf.IResolvable | PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDestinationNat[] | undefined;
    private _dnsSettings;
    get dnsSettings(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettingsOutputReference;
    putDnsSettings(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettings): void;
    resetDnsSettings(): void;
    get dnsSettingsInput(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackDnsSettings | undefined;
    private _networkProfile;
    get networkProfile(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfileOutputReference;
    putNetworkProfile(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfile): void;
    get networkProfileInput(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackNetworkProfile | undefined;
    private _timeouts;
    get timeouts(): PaloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeoutsOutputReference;
    putTimeouts(value: PaloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PaloAltoNextGenerationFirewallVirtualHubLocalRulestackTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
