/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicySetDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#description PolicySetDefinition#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#display_name PolicySetDefinition#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#id PolicySetDefinition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#management_group_id PolicySetDefinition#management_group_id}
    */
    readonly managementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#metadata PolicySetDefinition#metadata}
    */
    readonly metadata?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#name PolicySetDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#parameters PolicySetDefinition#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#policy_type PolicySetDefinition#policy_type}
    */
    readonly policyType: string;
    /**
    * policy_definition_group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#policy_definition_group PolicySetDefinition#policy_definition_group}
    */
    readonly policyDefinitionGroup?: PolicySetDefinitionPolicyDefinitionGroup[] | cdktf.IResolvable;
    /**
    * policy_definition_reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#policy_definition_reference PolicySetDefinition#policy_definition_reference}
    */
    readonly policyDefinitionReference: PolicySetDefinitionPolicyDefinitionReference[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#timeouts PolicySetDefinition#timeouts}
    */
    readonly timeouts?: PolicySetDefinitionTimeouts;
}
export interface PolicySetDefinitionPolicyDefinitionGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#additional_metadata_resource_id PolicySetDefinition#additional_metadata_resource_id}
    */
    readonly additionalMetadataResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#category PolicySetDefinition#category}
    */
    readonly category?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#description PolicySetDefinition#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#display_name PolicySetDefinition#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#name PolicySetDefinition#name}
    */
    readonly name: string;
}
export declare function policySetDefinitionPolicyDefinitionGroupToTerraform(struct?: PolicySetDefinitionPolicyDefinitionGroup | cdktf.IResolvable): any;
export declare function policySetDefinitionPolicyDefinitionGroupToHclTerraform(struct?: PolicySetDefinitionPolicyDefinitionGroup | cdktf.IResolvable): any;
export declare class PolicySetDefinitionPolicyDefinitionGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PolicySetDefinitionPolicyDefinitionGroup | cdktf.IResolvable | undefined;
    set internalValue(value: PolicySetDefinitionPolicyDefinitionGroup | cdktf.IResolvable | undefined);
    private _additionalMetadataResourceId?;
    get additionalMetadataResourceId(): string;
    set additionalMetadataResourceId(value: string);
    resetAdditionalMetadataResourceId(): void;
    get additionalMetadataResourceIdInput(): string | undefined;
    private _category?;
    get category(): string;
    set category(value: string);
    resetCategory(): void;
    get categoryInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class PolicySetDefinitionPolicyDefinitionGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PolicySetDefinitionPolicyDefinitionGroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PolicySetDefinitionPolicyDefinitionGroupOutputReference;
}
export interface PolicySetDefinitionPolicyDefinitionReference {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#parameter_values PolicySetDefinition#parameter_values}
    */
    readonly parameterValues?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#policy_definition_id PolicySetDefinition#policy_definition_id}
    */
    readonly policyDefinitionId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#policy_group_names PolicySetDefinition#policy_group_names}
    */
    readonly policyGroupNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#reference_id PolicySetDefinition#reference_id}
    */
    readonly referenceId?: string;
}
export declare function policySetDefinitionPolicyDefinitionReferenceToTerraform(struct?: PolicySetDefinitionPolicyDefinitionReference | cdktf.IResolvable): any;
export declare function policySetDefinitionPolicyDefinitionReferenceToHclTerraform(struct?: PolicySetDefinitionPolicyDefinitionReference | cdktf.IResolvable): any;
export declare class PolicySetDefinitionPolicyDefinitionReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PolicySetDefinitionPolicyDefinitionReference | cdktf.IResolvable | undefined;
    set internalValue(value: PolicySetDefinitionPolicyDefinitionReference | cdktf.IResolvable | undefined);
    private _parameterValues?;
    get parameterValues(): string;
    set parameterValues(value: string);
    resetParameterValues(): void;
    get parameterValuesInput(): string | undefined;
    private _policyDefinitionId?;
    get policyDefinitionId(): string;
    set policyDefinitionId(value: string);
    get policyDefinitionIdInput(): string | undefined;
    private _policyGroupNames?;
    get policyGroupNames(): string[];
    set policyGroupNames(value: string[]);
    resetPolicyGroupNames(): void;
    get policyGroupNamesInput(): string[] | undefined;
    private _referenceId?;
    get referenceId(): string;
    set referenceId(value: string);
    resetReferenceId(): void;
    get referenceIdInput(): string | undefined;
}
export declare class PolicySetDefinitionPolicyDefinitionReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PolicySetDefinitionPolicyDefinitionReference[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PolicySetDefinitionPolicyDefinitionReferenceOutputReference;
}
export interface PolicySetDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#create PolicySetDefinition#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#delete PolicySetDefinition#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#read PolicySetDefinition#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#update PolicySetDefinition#update}
    */
    readonly update?: string;
}
export declare function policySetDefinitionTimeoutsToTerraform(struct?: PolicySetDefinitionTimeouts | cdktf.IResolvable): any;
export declare function policySetDefinitionTimeoutsToHclTerraform(struct?: PolicySetDefinitionTimeouts | cdktf.IResolvable): any;
export declare class PolicySetDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PolicySetDefinitionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PolicySetDefinitionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition azurerm_policy_set_definition}
*/
export declare class PolicySetDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_policy_set_definition";
    /**
    * Generates CDKTF code for importing a PolicySetDefinition resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PolicySetDefinition to import
    * @param importFromId The id of the existing PolicySetDefinition that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PolicySetDefinition to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/policy_set_definition azurerm_policy_set_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicySetDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: PolicySetDefinitionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managementGroupId?;
    get managementGroupId(): string;
    set managementGroupId(value: string);
    resetManagementGroupId(): void;
    get managementGroupIdInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _policyType?;
    get policyType(): string;
    set policyType(value: string);
    get policyTypeInput(): string | undefined;
    private _policyDefinitionGroup;
    get policyDefinitionGroup(): PolicySetDefinitionPolicyDefinitionGroupList;
    putPolicyDefinitionGroup(value: PolicySetDefinitionPolicyDefinitionGroup[] | cdktf.IResolvable): void;
    resetPolicyDefinitionGroup(): void;
    get policyDefinitionGroupInput(): cdktf.IResolvable | PolicySetDefinitionPolicyDefinitionGroup[] | undefined;
    private _policyDefinitionReference;
    get policyDefinitionReference(): PolicySetDefinitionPolicyDefinitionReferenceList;
    putPolicyDefinitionReference(value: PolicySetDefinitionPolicyDefinitionReference[] | cdktf.IResolvable): void;
    get policyDefinitionReferenceInput(): cdktf.IResolvable | PolicySetDefinitionPolicyDefinitionReference[] | undefined;
    private _timeouts;
    get timeouts(): PolicySetDefinitionTimeoutsOutputReference;
    putTimeouts(value: PolicySetDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PolicySetDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
