/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelAlertRuleAnomalyDuplicateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#built_in_rule_id SentinelAlertRuleAnomalyDuplicate#built_in_rule_id}
    */
    readonly builtInRuleId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#display_name SentinelAlertRuleAnomalyDuplicate#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#enabled SentinelAlertRuleAnomalyDuplicate#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#id SentinelAlertRuleAnomalyDuplicate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#log_analytics_workspace_id SentinelAlertRuleAnomalyDuplicate#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#mode SentinelAlertRuleAnomalyDuplicate#mode}
    */
    readonly mode: string;
    /**
    * multi_select_observation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#multi_select_observation SentinelAlertRuleAnomalyDuplicate#multi_select_observation}
    */
    readonly multiSelectObservation?: SentinelAlertRuleAnomalyDuplicateMultiSelectObservation[] | cdktf.IResolvable;
    /**
    * prioritized_exclude_observation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#prioritized_exclude_observation SentinelAlertRuleAnomalyDuplicate#prioritized_exclude_observation}
    */
    readonly prioritizedExcludeObservation?: SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservation[] | cdktf.IResolvable;
    /**
    * single_select_observation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#single_select_observation SentinelAlertRuleAnomalyDuplicate#single_select_observation}
    */
    readonly singleSelectObservation?: SentinelAlertRuleAnomalyDuplicateSingleSelectObservation[] | cdktf.IResolvable;
    /**
    * threshold_observation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#threshold_observation SentinelAlertRuleAnomalyDuplicate#threshold_observation}
    */
    readonly thresholdObservation?: SentinelAlertRuleAnomalyDuplicateThresholdObservation[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#timeouts SentinelAlertRuleAnomalyDuplicate#timeouts}
    */
    readonly timeouts?: SentinelAlertRuleAnomalyDuplicateTimeouts;
}
export interface SentinelAlertRuleAnomalyDuplicateRequiredDataConnector {
}
export declare function sentinelAlertRuleAnomalyDuplicateRequiredDataConnectorToTerraform(struct?: SentinelAlertRuleAnomalyDuplicateRequiredDataConnector): any;
export declare function sentinelAlertRuleAnomalyDuplicateRequiredDataConnectorToHclTerraform(struct?: SentinelAlertRuleAnomalyDuplicateRequiredDataConnector): any;
export declare class SentinelAlertRuleAnomalyDuplicateRequiredDataConnectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleAnomalyDuplicateRequiredDataConnector | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyDuplicateRequiredDataConnector | undefined);
    get connectorId(): string;
    get dataTypes(): string[];
}
export declare class SentinelAlertRuleAnomalyDuplicateRequiredDataConnectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleAnomalyDuplicateRequiredDataConnectorOutputReference;
}
export interface SentinelAlertRuleAnomalyDuplicateMultiSelectObservation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#name SentinelAlertRuleAnomalyDuplicate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#values SentinelAlertRuleAnomalyDuplicate#values}
    */
    readonly values: string[];
}
export declare function sentinelAlertRuleAnomalyDuplicateMultiSelectObservationToTerraform(struct?: SentinelAlertRuleAnomalyDuplicateMultiSelectObservation | cdktf.IResolvable): any;
export declare function sentinelAlertRuleAnomalyDuplicateMultiSelectObservationToHclTerraform(struct?: SentinelAlertRuleAnomalyDuplicateMultiSelectObservation | cdktf.IResolvable): any;
export declare class SentinelAlertRuleAnomalyDuplicateMultiSelectObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleAnomalyDuplicateMultiSelectObservation | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyDuplicateMultiSelectObservation | cdktf.IResolvable | undefined);
    get description(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get supportedValues(): string[];
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class SentinelAlertRuleAnomalyDuplicateMultiSelectObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleAnomalyDuplicateMultiSelectObservation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleAnomalyDuplicateMultiSelectObservationOutputReference;
}
export interface SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#exclude SentinelAlertRuleAnomalyDuplicate#exclude}
    */
    readonly exclude?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#name SentinelAlertRuleAnomalyDuplicate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#prioritize SentinelAlertRuleAnomalyDuplicate#prioritize}
    */
    readonly prioritize?: string;
}
export declare function sentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservationToTerraform(struct?: SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservation | cdktf.IResolvable): any;
export declare function sentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservationToHclTerraform(struct?: SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservation | cdktf.IResolvable): any;
export declare class SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservation | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservation | cdktf.IResolvable | undefined);
    get description(): string;
    private _exclude?;
    get exclude(): string;
    set exclude(value: string);
    resetExclude(): void;
    get excludeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _prioritize?;
    get prioritize(): string;
    set prioritize(value: string);
    resetPrioritize(): void;
    get prioritizeInput(): string | undefined;
}
export declare class SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservationOutputReference;
}
export interface SentinelAlertRuleAnomalyDuplicateSingleSelectObservation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#name SentinelAlertRuleAnomalyDuplicate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#value SentinelAlertRuleAnomalyDuplicate#value}
    */
    readonly value: string;
}
export declare function sentinelAlertRuleAnomalyDuplicateSingleSelectObservationToTerraform(struct?: SentinelAlertRuleAnomalyDuplicateSingleSelectObservation | cdktf.IResolvable): any;
export declare function sentinelAlertRuleAnomalyDuplicateSingleSelectObservationToHclTerraform(struct?: SentinelAlertRuleAnomalyDuplicateSingleSelectObservation | cdktf.IResolvable): any;
export declare class SentinelAlertRuleAnomalyDuplicateSingleSelectObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleAnomalyDuplicateSingleSelectObservation | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyDuplicateSingleSelectObservation | cdktf.IResolvable | undefined);
    get description(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get supportedValues(): string[];
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class SentinelAlertRuleAnomalyDuplicateSingleSelectObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleAnomalyDuplicateSingleSelectObservation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleAnomalyDuplicateSingleSelectObservationOutputReference;
}
export interface SentinelAlertRuleAnomalyDuplicateThresholdObservation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#name SentinelAlertRuleAnomalyDuplicate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#value SentinelAlertRuleAnomalyDuplicate#value}
    */
    readonly value: string;
}
export declare function sentinelAlertRuleAnomalyDuplicateThresholdObservationToTerraform(struct?: SentinelAlertRuleAnomalyDuplicateThresholdObservation | cdktf.IResolvable): any;
export declare function sentinelAlertRuleAnomalyDuplicateThresholdObservationToHclTerraform(struct?: SentinelAlertRuleAnomalyDuplicateThresholdObservation | cdktf.IResolvable): any;
export declare class SentinelAlertRuleAnomalyDuplicateThresholdObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleAnomalyDuplicateThresholdObservation | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyDuplicateThresholdObservation | cdktf.IResolvable | undefined);
    get description(): string;
    get max(): string;
    get min(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class SentinelAlertRuleAnomalyDuplicateThresholdObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleAnomalyDuplicateThresholdObservation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleAnomalyDuplicateThresholdObservationOutputReference;
}
export interface SentinelAlertRuleAnomalyDuplicateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#create SentinelAlertRuleAnomalyDuplicate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#delete SentinelAlertRuleAnomalyDuplicate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#read SentinelAlertRuleAnomalyDuplicate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#update SentinelAlertRuleAnomalyDuplicate#update}
    */
    readonly update?: string;
}
export declare function sentinelAlertRuleAnomalyDuplicateTimeoutsToTerraform(struct?: SentinelAlertRuleAnomalyDuplicateTimeouts | cdktf.IResolvable): any;
export declare function sentinelAlertRuleAnomalyDuplicateTimeoutsToHclTerraform(struct?: SentinelAlertRuleAnomalyDuplicateTimeouts | cdktf.IResolvable): any;
export declare class SentinelAlertRuleAnomalyDuplicateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelAlertRuleAnomalyDuplicateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyDuplicateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate azurerm_sentinel_alert_rule_anomaly_duplicate}
*/
export declare class SentinelAlertRuleAnomalyDuplicate extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sentinel_alert_rule_anomaly_duplicate";
    /**
    * Generates CDKTF code for importing a SentinelAlertRuleAnomalyDuplicate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SentinelAlertRuleAnomalyDuplicate to import
    * @param importFromId The id of the existing SentinelAlertRuleAnomalyDuplicate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SentinelAlertRuleAnomalyDuplicate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/sentinel_alert_rule_anomaly_duplicate azurerm_sentinel_alert_rule_anomaly_duplicate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelAlertRuleAnomalyDuplicateConfig
    */
    constructor(scope: Construct, id: string, config: SentinelAlertRuleAnomalyDuplicateConfig);
    get anomalySettingsVersion(): number;
    get anomalyVersion(): string;
    private _builtInRuleId?;
    get builtInRuleId(): string;
    set builtInRuleId(value: string);
    get builtInRuleIdInput(): string | undefined;
    get description(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get frequency(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get isDefaultSettings(): cdktf.IResolvable;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    get name(): string;
    private _requiredDataConnector;
    get requiredDataConnector(): SentinelAlertRuleAnomalyDuplicateRequiredDataConnectorList;
    get settingsDefinitionId(): string;
    get tactics(): string[];
    get techniques(): string[];
    private _multiSelectObservation;
    get multiSelectObservation(): SentinelAlertRuleAnomalyDuplicateMultiSelectObservationList;
    putMultiSelectObservation(value: SentinelAlertRuleAnomalyDuplicateMultiSelectObservation[] | cdktf.IResolvable): void;
    resetMultiSelectObservation(): void;
    get multiSelectObservationInput(): cdktf.IResolvable | SentinelAlertRuleAnomalyDuplicateMultiSelectObservation[] | undefined;
    private _prioritizedExcludeObservation;
    get prioritizedExcludeObservation(): SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservationList;
    putPrioritizedExcludeObservation(value: SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservation[] | cdktf.IResolvable): void;
    resetPrioritizedExcludeObservation(): void;
    get prioritizedExcludeObservationInput(): cdktf.IResolvable | SentinelAlertRuleAnomalyDuplicatePrioritizedExcludeObservation[] | undefined;
    private _singleSelectObservation;
    get singleSelectObservation(): SentinelAlertRuleAnomalyDuplicateSingleSelectObservationList;
    putSingleSelectObservation(value: SentinelAlertRuleAnomalyDuplicateSingleSelectObservation[] | cdktf.IResolvable): void;
    resetSingleSelectObservation(): void;
    get singleSelectObservationInput(): cdktf.IResolvable | SentinelAlertRuleAnomalyDuplicateSingleSelectObservation[] | undefined;
    private _thresholdObservation;
    get thresholdObservation(): SentinelAlertRuleAnomalyDuplicateThresholdObservationList;
    putThresholdObservation(value: SentinelAlertRuleAnomalyDuplicateThresholdObservation[] | cdktf.IResolvable): void;
    resetThresholdObservation(): void;
    get thresholdObservationInput(): cdktf.IResolvable | SentinelAlertRuleAnomalyDuplicateThresholdObservation[] | undefined;
    private _timeouts;
    get timeouts(): SentinelAlertRuleAnomalyDuplicateTimeoutsOutputReference;
    putTimeouts(value: SentinelAlertRuleAnomalyDuplicateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SentinelAlertRuleAnomalyDuplicateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
