/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StaticWebAppFunctionAppRegistrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/static_web_app_function_app_registration#function_app_id StaticWebAppFunctionAppRegistration#function_app_id}
    */
    readonly functionAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/static_web_app_function_app_registration#id StaticWebAppFunctionAppRegistration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/static_web_app_function_app_registration#static_web_app_id StaticWebAppFunctionAppRegistration#static_web_app_id}
    */
    readonly staticWebAppId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/static_web_app_function_app_registration#timeouts StaticWebAppFunctionAppRegistration#timeouts}
    */
    readonly timeouts?: StaticWebAppFunctionAppRegistrationTimeouts;
}
export interface StaticWebAppFunctionAppRegistrationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/static_web_app_function_app_registration#create StaticWebAppFunctionAppRegistration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/static_web_app_function_app_registration#delete StaticWebAppFunctionAppRegistration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/static_web_app_function_app_registration#read StaticWebAppFunctionAppRegistration#read}
    */
    readonly read?: string;
}
export declare function staticWebAppFunctionAppRegistrationTimeoutsToTerraform(struct?: StaticWebAppFunctionAppRegistrationTimeouts | cdktf.IResolvable): any;
export declare function staticWebAppFunctionAppRegistrationTimeoutsToHclTerraform(struct?: StaticWebAppFunctionAppRegistrationTimeouts | cdktf.IResolvable): any;
export declare class StaticWebAppFunctionAppRegistrationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StaticWebAppFunctionAppRegistrationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StaticWebAppFunctionAppRegistrationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/static_web_app_function_app_registration azurerm_static_web_app_function_app_registration}
*/
export declare class StaticWebAppFunctionAppRegistration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_static_web_app_function_app_registration";
    /**
    * Generates CDKTF code for importing a StaticWebAppFunctionAppRegistration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StaticWebAppFunctionAppRegistration to import
    * @param importFromId The id of the existing StaticWebAppFunctionAppRegistration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/static_web_app_function_app_registration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StaticWebAppFunctionAppRegistration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/static_web_app_function_app_registration azurerm_static_web_app_function_app_registration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StaticWebAppFunctionAppRegistrationConfig
    */
    constructor(scope: Construct, id: string, config: StaticWebAppFunctionAppRegistrationConfig);
    private _functionAppId?;
    get functionAppId(): string;
    set functionAppId(value: string);
    get functionAppIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _staticWebAppId?;
    get staticWebAppId(): string;
    set staticWebAppId(value: string);
    get staticWebAppIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): StaticWebAppFunctionAppRegistrationTimeoutsOutputReference;
    putTimeouts(value: StaticWebAppFunctionAppRegistrationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StaticWebAppFunctionAppRegistrationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
