/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseWorkspaceVulnerabilityAssessmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#id SynapseWorkspaceVulnerabilityAssessment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_account_access_key SynapseWorkspaceVulnerabilityAssessment#storage_account_access_key}
    */
    readonly storageAccountAccessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_container_path SynapseWorkspaceVulnerabilityAssessment#storage_container_path}
    */
    readonly storageContainerPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_container_sas_key SynapseWorkspaceVulnerabilityAssessment#storage_container_sas_key}
    */
    readonly storageContainerSasKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#workspace_security_alert_policy_id SynapseWorkspaceVulnerabilityAssessment#workspace_security_alert_policy_id}
    */
    readonly workspaceSecurityAlertPolicyId: string;
    /**
    * recurring_scans block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#recurring_scans SynapseWorkspaceVulnerabilityAssessment#recurring_scans}
    */
    readonly recurringScans?: SynapseWorkspaceVulnerabilityAssessmentRecurringScans;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#timeouts SynapseWorkspaceVulnerabilityAssessment#timeouts}
    */
    readonly timeouts?: SynapseWorkspaceVulnerabilityAssessmentTimeouts;
}
export interface SynapseWorkspaceVulnerabilityAssessmentRecurringScans {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#email_subscription_admins_enabled SynapseWorkspaceVulnerabilityAssessment#email_subscription_admins_enabled}
    */
    readonly emailSubscriptionAdminsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#emails SynapseWorkspaceVulnerabilityAssessment#emails}
    */
    readonly emails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#enabled SynapseWorkspaceVulnerabilityAssessment#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function synapseWorkspaceVulnerabilityAssessmentRecurringScansToTerraform(struct?: SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference | SynapseWorkspaceVulnerabilityAssessmentRecurringScans): any;
export declare function synapseWorkspaceVulnerabilityAssessmentRecurringScansToHclTerraform(struct?: SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference | SynapseWorkspaceVulnerabilityAssessmentRecurringScans): any;
export declare class SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseWorkspaceVulnerabilityAssessmentRecurringScans | undefined;
    set internalValue(value: SynapseWorkspaceVulnerabilityAssessmentRecurringScans | undefined);
    private _emailSubscriptionAdminsEnabled?;
    get emailSubscriptionAdminsEnabled(): boolean | cdktf.IResolvable;
    set emailSubscriptionAdminsEnabled(value: boolean | cdktf.IResolvable);
    resetEmailSubscriptionAdminsEnabled(): void;
    get emailSubscriptionAdminsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _emails?;
    get emails(): string[];
    set emails(value: string[]);
    resetEmails(): void;
    get emailsInput(): string[] | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SynapseWorkspaceVulnerabilityAssessmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#create SynapseWorkspaceVulnerabilityAssessment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#delete SynapseWorkspaceVulnerabilityAssessment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#read SynapseWorkspaceVulnerabilityAssessment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#update SynapseWorkspaceVulnerabilityAssessment#update}
    */
    readonly update?: string;
}
export declare function synapseWorkspaceVulnerabilityAssessmentTimeoutsToTerraform(struct?: SynapseWorkspaceVulnerabilityAssessmentTimeouts | cdktf.IResolvable): any;
export declare function synapseWorkspaceVulnerabilityAssessmentTimeoutsToHclTerraform(struct?: SynapseWorkspaceVulnerabilityAssessmentTimeouts | cdktf.IResolvable): any;
export declare class SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseWorkspaceVulnerabilityAssessmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SynapseWorkspaceVulnerabilityAssessmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment azurerm_synapse_workspace_vulnerability_assessment}
*/
export declare class SynapseWorkspaceVulnerabilityAssessment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_synapse_workspace_vulnerability_assessment";
    /**
    * Generates CDKTF code for importing a SynapseWorkspaceVulnerabilityAssessment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SynapseWorkspaceVulnerabilityAssessment to import
    * @param importFromId The id of the existing SynapseWorkspaceVulnerabilityAssessment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SynapseWorkspaceVulnerabilityAssessment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/synapse_workspace_vulnerability_assessment azurerm_synapse_workspace_vulnerability_assessment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseWorkspaceVulnerabilityAssessmentConfig
    */
    constructor(scope: Construct, id: string, config: SynapseWorkspaceVulnerabilityAssessmentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    resetStorageAccountAccessKey(): void;
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageContainerPath?;
    get storageContainerPath(): string;
    set storageContainerPath(value: string);
    get storageContainerPathInput(): string | undefined;
    private _storageContainerSasKey?;
    get storageContainerSasKey(): string;
    set storageContainerSasKey(value: string);
    resetStorageContainerSasKey(): void;
    get storageContainerSasKeyInput(): string | undefined;
    private _workspaceSecurityAlertPolicyId?;
    get workspaceSecurityAlertPolicyId(): string;
    set workspaceSecurityAlertPolicyId(value: string);
    get workspaceSecurityAlertPolicyIdInput(): string | undefined;
    private _recurringScans;
    get recurringScans(): SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference;
    putRecurringScans(value: SynapseWorkspaceVulnerabilityAssessmentRecurringScans): void;
    resetRecurringScans(): void;
    get recurringScansInput(): SynapseWorkspaceVulnerabilityAssessmentRecurringScans | undefined;
    private _timeouts;
    get timeouts(): SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference;
    putTimeouts(value: SynapseWorkspaceVulnerabilityAssessmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SynapseWorkspaceVulnerabilityAssessmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
