/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WebPubsubSocketioConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#aad_auth_enabled WebPubsubSocketio#aad_auth_enabled}
    */
    readonly aadAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#id WebPubsubSocketio#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#live_trace_connectivity_logs_enabled WebPubsubSocketio#live_trace_connectivity_logs_enabled}
    */
    readonly liveTraceConnectivityLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#live_trace_enabled WebPubsubSocketio#live_trace_enabled}
    */
    readonly liveTraceEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#live_trace_http_request_logs_enabled WebPubsubSocketio#live_trace_http_request_logs_enabled}
    */
    readonly liveTraceHttpRequestLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#live_trace_messaging_logs_enabled WebPubsubSocketio#live_trace_messaging_logs_enabled}
    */
    readonly liveTraceMessagingLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#local_auth_enabled WebPubsubSocketio#local_auth_enabled}
    */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#location WebPubsubSocketio#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#name WebPubsubSocketio#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#public_network_access WebPubsubSocketio#public_network_access}
    */
    readonly publicNetworkAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#resource_group_name WebPubsubSocketio#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#service_mode WebPubsubSocketio#service_mode}
    */
    readonly serviceMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#tags WebPubsubSocketio#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#tls_client_cert_enabled WebPubsubSocketio#tls_client_cert_enabled}
    */
    readonly tlsClientCertEnabled?: boolean | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#identity WebPubsubSocketio#identity}
    */
    readonly identity?: WebPubsubSocketioIdentity;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#sku WebPubsubSocketio#sku}
    */
    readonly sku: WebPubsubSocketioSku;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#timeouts WebPubsubSocketio#timeouts}
    */
    readonly timeouts?: WebPubsubSocketioTimeouts;
}
export interface WebPubsubSocketioIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#identity_ids WebPubsubSocketio#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#type WebPubsubSocketio#type}
    */
    readonly type: string;
}
export declare function webPubsubSocketioIdentityToTerraform(struct?: WebPubsubSocketioIdentityOutputReference | WebPubsubSocketioIdentity): any;
export declare function webPubsubSocketioIdentityToHclTerraform(struct?: WebPubsubSocketioIdentityOutputReference | WebPubsubSocketioIdentity): any;
export declare class WebPubsubSocketioIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebPubsubSocketioIdentity | undefined;
    set internalValue(value: WebPubsubSocketioIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface WebPubsubSocketioSku {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#capacity WebPubsubSocketio#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#name WebPubsubSocketio#name}
    */
    readonly name: string;
}
export declare function webPubsubSocketioSkuToTerraform(struct?: WebPubsubSocketioSkuOutputReference | WebPubsubSocketioSku): any;
export declare function webPubsubSocketioSkuToHclTerraform(struct?: WebPubsubSocketioSkuOutputReference | WebPubsubSocketioSku): any;
export declare class WebPubsubSocketioSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebPubsubSocketioSku | undefined;
    set internalValue(value: WebPubsubSocketioSku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface WebPubsubSocketioTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#create WebPubsubSocketio#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#delete WebPubsubSocketio#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#read WebPubsubSocketio#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#update WebPubsubSocketio#update}
    */
    readonly update?: string;
}
export declare function webPubsubSocketioTimeoutsToTerraform(struct?: WebPubsubSocketioTimeouts | cdktf.IResolvable): any;
export declare function webPubsubSocketioTimeoutsToHclTerraform(struct?: WebPubsubSocketioTimeouts | cdktf.IResolvable): any;
export declare class WebPubsubSocketioTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebPubsubSocketioTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WebPubsubSocketioTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio azurerm_web_pubsub_socketio}
*/
export declare class WebPubsubSocketio extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_web_pubsub_socketio";
    /**
    * Generates CDKTF code for importing a WebPubsubSocketio resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the WebPubsubSocketio to import
    * @param importFromId The id of the existing WebPubsubSocketio that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the WebPubsubSocketio to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/web_pubsub_socketio azurerm_web_pubsub_socketio} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WebPubsubSocketioConfig
    */
    constructor(scope: Construct, id: string, config: WebPubsubSocketioConfig);
    private _aadAuthEnabled?;
    get aadAuthEnabled(): boolean | cdktf.IResolvable;
    set aadAuthEnabled(value: boolean | cdktf.IResolvable);
    resetAadAuthEnabled(): void;
    get aadAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get externalIp(): string;
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _liveTraceConnectivityLogsEnabled?;
    get liveTraceConnectivityLogsEnabled(): boolean | cdktf.IResolvable;
    set liveTraceConnectivityLogsEnabled(value: boolean | cdktf.IResolvable);
    resetLiveTraceConnectivityLogsEnabled(): void;
    get liveTraceConnectivityLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _liveTraceEnabled?;
    get liveTraceEnabled(): boolean | cdktf.IResolvable;
    set liveTraceEnabled(value: boolean | cdktf.IResolvable);
    resetLiveTraceEnabled(): void;
    get liveTraceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _liveTraceHttpRequestLogsEnabled?;
    get liveTraceHttpRequestLogsEnabled(): boolean | cdktf.IResolvable;
    set liveTraceHttpRequestLogsEnabled(value: boolean | cdktf.IResolvable);
    resetLiveTraceHttpRequestLogsEnabled(): void;
    get liveTraceHttpRequestLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _liveTraceMessagingLogsEnabled?;
    get liveTraceMessagingLogsEnabled(): boolean | cdktf.IResolvable;
    set liveTraceMessagingLogsEnabled(value: boolean | cdktf.IResolvable);
    resetLiveTraceMessagingLogsEnabled(): void;
    get liveTraceMessagingLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _localAuthEnabled?;
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthEnabled(): void;
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    get primaryConnectionString(): string;
    private _publicNetworkAccess?;
    get publicNetworkAccess(): string;
    set publicNetworkAccess(value: string);
    resetPublicNetworkAccess(): void;
    get publicNetworkAccessInput(): string | undefined;
    get publicPort(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryConnectionString(): string;
    get serverPort(): number;
    private _serviceMode?;
    get serviceMode(): string;
    set serviceMode(value: string);
    resetServiceMode(): void;
    get serviceModeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tlsClientCertEnabled?;
    get tlsClientCertEnabled(): boolean | cdktf.IResolvable;
    set tlsClientCertEnabled(value: boolean | cdktf.IResolvable);
    resetTlsClientCertEnabled(): void;
    get tlsClientCertEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _identity;
    get identity(): WebPubsubSocketioIdentityOutputReference;
    putIdentity(value: WebPubsubSocketioIdentity): void;
    resetIdentity(): void;
    get identityInput(): WebPubsubSocketioIdentity | undefined;
    private _sku;
    get sku(): WebPubsubSocketioSkuOutputReference;
    putSku(value: WebPubsubSocketioSku): void;
    get skuInput(): WebPubsubSocketioSku | undefined;
    private _timeouts;
    get timeouts(): WebPubsubSocketioTimeoutsOutputReference;
    putTimeouts(value: WebPubsubSocketioTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WebPubsubSocketioTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
