/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WindowsVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#admin_password WindowsVirtualMachine#admin_password}
    */
    readonly adminPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#admin_username WindowsVirtualMachine#admin_username}
    */
    readonly adminUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#allow_extension_operations WindowsVirtualMachine#allow_extension_operations}
    */
    readonly allowExtensionOperations?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#availability_set_id WindowsVirtualMachine#availability_set_id}
    */
    readonly availabilitySetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#bypass_platform_safety_checks_on_user_schedule_enabled WindowsVirtualMachine#bypass_platform_safety_checks_on_user_schedule_enabled}
    */
    readonly bypassPlatformSafetyChecksOnUserScheduleEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#capacity_reservation_group_id WindowsVirtualMachine#capacity_reservation_group_id}
    */
    readonly capacityReservationGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#computer_name WindowsVirtualMachine#computer_name}
    */
    readonly computerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#custom_data WindowsVirtualMachine#custom_data}
    */
    readonly customData?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#dedicated_host_group_id WindowsVirtualMachine#dedicated_host_group_id}
    */
    readonly dedicatedHostGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#dedicated_host_id WindowsVirtualMachine#dedicated_host_id}
    */
    readonly dedicatedHostId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#disk_controller_type WindowsVirtualMachine#disk_controller_type}
    */
    readonly diskControllerType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#edge_zone WindowsVirtualMachine#edge_zone}
    */
    readonly edgeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#enable_automatic_updates WindowsVirtualMachine#enable_automatic_updates}
    */
    readonly enableAutomaticUpdates?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#encryption_at_host_enabled WindowsVirtualMachine#encryption_at_host_enabled}
    */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#eviction_policy WindowsVirtualMachine#eviction_policy}
    */
    readonly evictionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#extensions_time_budget WindowsVirtualMachine#extensions_time_budget}
    */
    readonly extensionsTimeBudget?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#hotpatching_enabled WindowsVirtualMachine#hotpatching_enabled}
    */
    readonly hotpatchingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#id WindowsVirtualMachine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#license_type WindowsVirtualMachine#license_type}
    */
    readonly licenseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#location WindowsVirtualMachine#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#max_bid_price WindowsVirtualMachine#max_bid_price}
    */
    readonly maxBidPrice?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#name WindowsVirtualMachine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#network_interface_ids WindowsVirtualMachine#network_interface_ids}
    */
    readonly networkInterfaceIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#patch_assessment_mode WindowsVirtualMachine#patch_assessment_mode}
    */
    readonly patchAssessmentMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#patch_mode WindowsVirtualMachine#patch_mode}
    */
    readonly patchMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#platform_fault_domain WindowsVirtualMachine#platform_fault_domain}
    */
    readonly platformFaultDomain?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#priority WindowsVirtualMachine#priority}
    */
    readonly priority?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#provision_vm_agent WindowsVirtualMachine#provision_vm_agent}
    */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#proximity_placement_group_id WindowsVirtualMachine#proximity_placement_group_id}
    */
    readonly proximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#reboot_setting WindowsVirtualMachine#reboot_setting}
    */
    readonly rebootSetting?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#resource_group_name WindowsVirtualMachine#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#secure_boot_enabled WindowsVirtualMachine#secure_boot_enabled}
    */
    readonly secureBootEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#size WindowsVirtualMachine#size}
    */
    readonly size: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#source_image_id WindowsVirtualMachine#source_image_id}
    */
    readonly sourceImageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#tags WindowsVirtualMachine#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#timezone WindowsVirtualMachine#timezone}
    */
    readonly timezone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#user_data WindowsVirtualMachine#user_data}
    */
    readonly userData?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#virtual_machine_scale_set_id WindowsVirtualMachine#virtual_machine_scale_set_id}
    */
    readonly virtualMachineScaleSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#vm_agent_platform_updates_enabled WindowsVirtualMachine#vm_agent_platform_updates_enabled}
    */
    readonly vmAgentPlatformUpdatesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#vtpm_enabled WindowsVirtualMachine#vtpm_enabled}
    */
    readonly vtpmEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#zone WindowsVirtualMachine#zone}
    */
    readonly zone?: string;
    /**
    * additional_capabilities block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#additional_capabilities WindowsVirtualMachine#additional_capabilities}
    */
    readonly additionalCapabilities?: WindowsVirtualMachineAdditionalCapabilities;
    /**
    * additional_unattend_content block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#additional_unattend_content WindowsVirtualMachine#additional_unattend_content}
    */
    readonly additionalUnattendContent?: WindowsVirtualMachineAdditionalUnattendContent[] | cdktf.IResolvable;
    /**
    * boot_diagnostics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#boot_diagnostics WindowsVirtualMachine#boot_diagnostics}
    */
    readonly bootDiagnostics?: WindowsVirtualMachineBootDiagnostics;
    /**
    * gallery_application block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#gallery_application WindowsVirtualMachine#gallery_application}
    */
    readonly galleryApplication?: WindowsVirtualMachineGalleryApplication[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#identity WindowsVirtualMachine#identity}
    */
    readonly identity?: WindowsVirtualMachineIdentity;
    /**
    * os_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#os_disk WindowsVirtualMachine#os_disk}
    */
    readonly osDisk: WindowsVirtualMachineOsDisk;
    /**
    * os_image_notification block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#os_image_notification WindowsVirtualMachine#os_image_notification}
    */
    readonly osImageNotification?: WindowsVirtualMachineOsImageNotification;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#plan WindowsVirtualMachine#plan}
    */
    readonly plan?: WindowsVirtualMachinePlan;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#secret WindowsVirtualMachine#secret}
    */
    readonly secret?: WindowsVirtualMachineSecret[] | cdktf.IResolvable;
    /**
    * source_image_reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#source_image_reference WindowsVirtualMachine#source_image_reference}
    */
    readonly sourceImageReference?: WindowsVirtualMachineSourceImageReference;
    /**
    * termination_notification block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#termination_notification WindowsVirtualMachine#termination_notification}
    */
    readonly terminationNotification?: WindowsVirtualMachineTerminationNotification;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#timeouts WindowsVirtualMachine#timeouts}
    */
    readonly timeouts?: WindowsVirtualMachineTimeouts;
    /**
    * winrm_listener block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#winrm_listener WindowsVirtualMachine#winrm_listener}
    */
    readonly winrmListener?: WindowsVirtualMachineWinrmListener[] | cdktf.IResolvable;
}
export interface WindowsVirtualMachineAdditionalCapabilities {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#hibernation_enabled WindowsVirtualMachine#hibernation_enabled}
    */
    readonly hibernationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#ultra_ssd_enabled WindowsVirtualMachine#ultra_ssd_enabled}
    */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
}
export declare function windowsVirtualMachineAdditionalCapabilitiesToTerraform(struct?: WindowsVirtualMachineAdditionalCapabilitiesOutputReference | WindowsVirtualMachineAdditionalCapabilities): any;
export declare function windowsVirtualMachineAdditionalCapabilitiesToHclTerraform(struct?: WindowsVirtualMachineAdditionalCapabilitiesOutputReference | WindowsVirtualMachineAdditionalCapabilities): any;
export declare class WindowsVirtualMachineAdditionalCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineAdditionalCapabilities | undefined;
    set internalValue(value: WindowsVirtualMachineAdditionalCapabilities | undefined);
    private _hibernationEnabled?;
    get hibernationEnabled(): boolean | cdktf.IResolvable;
    set hibernationEnabled(value: boolean | cdktf.IResolvable);
    resetHibernationEnabled(): void;
    get hibernationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ultraSsdEnabled?;
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    resetUltraSsdEnabled(): void;
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsVirtualMachineAdditionalUnattendContent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#content WindowsVirtualMachine#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#setting WindowsVirtualMachine#setting}
    */
    readonly setting: string;
}
export declare function windowsVirtualMachineAdditionalUnattendContentToTerraform(struct?: WindowsVirtualMachineAdditionalUnattendContent | cdktf.IResolvable): any;
export declare function windowsVirtualMachineAdditionalUnattendContentToHclTerraform(struct?: WindowsVirtualMachineAdditionalUnattendContent | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineAdditionalUnattendContentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineAdditionalUnattendContent | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineAdditionalUnattendContent | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _setting?;
    get setting(): string;
    set setting(value: string);
    get settingInput(): string | undefined;
}
export declare class WindowsVirtualMachineAdditionalUnattendContentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineAdditionalUnattendContent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineAdditionalUnattendContentOutputReference;
}
export interface WindowsVirtualMachineBootDiagnostics {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#storage_account_uri WindowsVirtualMachine#storage_account_uri}
    */
    readonly storageAccountUri?: string;
}
export declare function windowsVirtualMachineBootDiagnosticsToTerraform(struct?: WindowsVirtualMachineBootDiagnosticsOutputReference | WindowsVirtualMachineBootDiagnostics): any;
export declare function windowsVirtualMachineBootDiagnosticsToHclTerraform(struct?: WindowsVirtualMachineBootDiagnosticsOutputReference | WindowsVirtualMachineBootDiagnostics): any;
export declare class WindowsVirtualMachineBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineBootDiagnostics | undefined;
    set internalValue(value: WindowsVirtualMachineBootDiagnostics | undefined);
    private _storageAccountUri?;
    get storageAccountUri(): string;
    set storageAccountUri(value: string);
    resetStorageAccountUri(): void;
    get storageAccountUriInput(): string | undefined;
}
export interface WindowsVirtualMachineGalleryApplication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#automatic_upgrade_enabled WindowsVirtualMachine#automatic_upgrade_enabled}
    */
    readonly automaticUpgradeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#configuration_blob_uri WindowsVirtualMachine#configuration_blob_uri}
    */
    readonly configurationBlobUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#order WindowsVirtualMachine#order}
    */
    readonly order?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#tag WindowsVirtualMachine#tag}
    */
    readonly tag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#treat_failure_as_deployment_failure_enabled WindowsVirtualMachine#treat_failure_as_deployment_failure_enabled}
    */
    readonly treatFailureAsDeploymentFailureEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#version_id WindowsVirtualMachine#version_id}
    */
    readonly versionId: string;
}
export declare function windowsVirtualMachineGalleryApplicationToTerraform(struct?: WindowsVirtualMachineGalleryApplication | cdktf.IResolvable): any;
export declare function windowsVirtualMachineGalleryApplicationToHclTerraform(struct?: WindowsVirtualMachineGalleryApplication | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineGalleryApplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineGalleryApplication | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineGalleryApplication | cdktf.IResolvable | undefined);
    private _automaticUpgradeEnabled?;
    get automaticUpgradeEnabled(): boolean | cdktf.IResolvable;
    set automaticUpgradeEnabled(value: boolean | cdktf.IResolvable);
    resetAutomaticUpgradeEnabled(): void;
    get automaticUpgradeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _configurationBlobUri?;
    get configurationBlobUri(): string;
    set configurationBlobUri(value: string);
    resetConfigurationBlobUri(): void;
    get configurationBlobUriInput(): string | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    resetOrder(): void;
    get orderInput(): number | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _treatFailureAsDeploymentFailureEnabled?;
    get treatFailureAsDeploymentFailureEnabled(): boolean | cdktf.IResolvable;
    set treatFailureAsDeploymentFailureEnabled(value: boolean | cdktf.IResolvable);
    resetTreatFailureAsDeploymentFailureEnabled(): void;
    get treatFailureAsDeploymentFailureEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _versionId?;
    get versionId(): string;
    set versionId(value: string);
    get versionIdInput(): string | undefined;
}
export declare class WindowsVirtualMachineGalleryApplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineGalleryApplication[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineGalleryApplicationOutputReference;
}
export interface WindowsVirtualMachineIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#identity_ids WindowsVirtualMachine#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#type WindowsVirtualMachine#type}
    */
    readonly type: string;
}
export declare function windowsVirtualMachineIdentityToTerraform(struct?: WindowsVirtualMachineIdentityOutputReference | WindowsVirtualMachineIdentity): any;
export declare function windowsVirtualMachineIdentityToHclTerraform(struct?: WindowsVirtualMachineIdentityOutputReference | WindowsVirtualMachineIdentity): any;
export declare class WindowsVirtualMachineIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineIdentity | undefined;
    set internalValue(value: WindowsVirtualMachineIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface WindowsVirtualMachineOsDiskDiffDiskSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#option WindowsVirtualMachine#option}
    */
    readonly option: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#placement WindowsVirtualMachine#placement}
    */
    readonly placement?: string;
}
export declare function windowsVirtualMachineOsDiskDiffDiskSettingsToTerraform(struct?: WindowsVirtualMachineOsDiskDiffDiskSettingsOutputReference | WindowsVirtualMachineOsDiskDiffDiskSettings): any;
export declare function windowsVirtualMachineOsDiskDiffDiskSettingsToHclTerraform(struct?: WindowsVirtualMachineOsDiskDiffDiskSettingsOutputReference | WindowsVirtualMachineOsDiskDiffDiskSettings): any;
export declare class WindowsVirtualMachineOsDiskDiffDiskSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineOsDiskDiffDiskSettings | undefined;
    set internalValue(value: WindowsVirtualMachineOsDiskDiffDiskSettings | undefined);
    private _option?;
    get option(): string;
    set option(value: string);
    get optionInput(): string | undefined;
    private _placement?;
    get placement(): string;
    set placement(value: string);
    resetPlacement(): void;
    get placementInput(): string | undefined;
}
export interface WindowsVirtualMachineOsDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#caching WindowsVirtualMachine#caching}
    */
    readonly caching: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#disk_encryption_set_id WindowsVirtualMachine#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#disk_size_gb WindowsVirtualMachine#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#name WindowsVirtualMachine#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#secure_vm_disk_encryption_set_id WindowsVirtualMachine#secure_vm_disk_encryption_set_id}
    */
    readonly secureVmDiskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#security_encryption_type WindowsVirtualMachine#security_encryption_type}
    */
    readonly securityEncryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#storage_account_type WindowsVirtualMachine#storage_account_type}
    */
    readonly storageAccountType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#write_accelerator_enabled WindowsVirtualMachine#write_accelerator_enabled}
    */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
    /**
    * diff_disk_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#diff_disk_settings WindowsVirtualMachine#diff_disk_settings}
    */
    readonly diffDiskSettings?: WindowsVirtualMachineOsDiskDiffDiskSettings;
}
export declare function windowsVirtualMachineOsDiskToTerraform(struct?: WindowsVirtualMachineOsDiskOutputReference | WindowsVirtualMachineOsDisk): any;
export declare function windowsVirtualMachineOsDiskToHclTerraform(struct?: WindowsVirtualMachineOsDiskOutputReference | WindowsVirtualMachineOsDisk): any;
export declare class WindowsVirtualMachineOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineOsDisk | undefined;
    set internalValue(value: WindowsVirtualMachineOsDisk | undefined);
    private _caching?;
    get caching(): string;
    set caching(value: string);
    get cachingInput(): string | undefined;
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _secureVmDiskEncryptionSetId?;
    get secureVmDiskEncryptionSetId(): string;
    set secureVmDiskEncryptionSetId(value: string);
    resetSecureVmDiskEncryptionSetId(): void;
    get secureVmDiskEncryptionSetIdInput(): string | undefined;
    private _securityEncryptionType?;
    get securityEncryptionType(): string;
    set securityEncryptionType(value: string);
    resetSecurityEncryptionType(): void;
    get securityEncryptionTypeInput(): string | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    get storageAccountTypeInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    resetWriteAcceleratorEnabled(): void;
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diffDiskSettings;
    get diffDiskSettings(): WindowsVirtualMachineOsDiskDiffDiskSettingsOutputReference;
    putDiffDiskSettings(value: WindowsVirtualMachineOsDiskDiffDiskSettings): void;
    resetDiffDiskSettings(): void;
    get diffDiskSettingsInput(): WindowsVirtualMachineOsDiskDiffDiskSettings | undefined;
}
export interface WindowsVirtualMachineOsImageNotification {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#timeout WindowsVirtualMachine#timeout}
    */
    readonly timeout?: string;
}
export declare function windowsVirtualMachineOsImageNotificationToTerraform(struct?: WindowsVirtualMachineOsImageNotificationOutputReference | WindowsVirtualMachineOsImageNotification): any;
export declare function windowsVirtualMachineOsImageNotificationToHclTerraform(struct?: WindowsVirtualMachineOsImageNotificationOutputReference | WindowsVirtualMachineOsImageNotification): any;
export declare class WindowsVirtualMachineOsImageNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineOsImageNotification | undefined;
    set internalValue(value: WindowsVirtualMachineOsImageNotification | undefined);
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface WindowsVirtualMachinePlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#name WindowsVirtualMachine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#product WindowsVirtualMachine#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#publisher WindowsVirtualMachine#publisher}
    */
    readonly publisher: string;
}
export declare function windowsVirtualMachinePlanToTerraform(struct?: WindowsVirtualMachinePlanOutputReference | WindowsVirtualMachinePlan): any;
export declare function windowsVirtualMachinePlanToHclTerraform(struct?: WindowsVirtualMachinePlanOutputReference | WindowsVirtualMachinePlan): any;
export declare class WindowsVirtualMachinePlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachinePlan | undefined;
    set internalValue(value: WindowsVirtualMachinePlan | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
}
export interface WindowsVirtualMachineSecretCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#store WindowsVirtualMachine#store}
    */
    readonly store: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#url WindowsVirtualMachine#url}
    */
    readonly url: string;
}
export declare function windowsVirtualMachineSecretCertificateToTerraform(struct?: WindowsVirtualMachineSecretCertificate | cdktf.IResolvable): any;
export declare function windowsVirtualMachineSecretCertificateToHclTerraform(struct?: WindowsVirtualMachineSecretCertificate | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineSecretCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineSecretCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineSecretCertificate | cdktf.IResolvable | undefined);
    private _store?;
    get store(): string;
    set store(value: string);
    get storeInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export declare class WindowsVirtualMachineSecretCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineSecretCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineSecretCertificateOutputReference;
}
export interface WindowsVirtualMachineSecret {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#key_vault_id WindowsVirtualMachine#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#certificate WindowsVirtualMachine#certificate}
    */
    readonly certificate: WindowsVirtualMachineSecretCertificate[] | cdktf.IResolvable;
}
export declare function windowsVirtualMachineSecretToTerraform(struct?: WindowsVirtualMachineSecret | cdktf.IResolvable): any;
export declare function windowsVirtualMachineSecretToHclTerraform(struct?: WindowsVirtualMachineSecret | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineSecret | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineSecret | cdktf.IResolvable | undefined);
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _certificate;
    get certificate(): WindowsVirtualMachineSecretCertificateList;
    putCertificate(value: WindowsVirtualMachineSecretCertificate[] | cdktf.IResolvable): void;
    get certificateInput(): cdktf.IResolvable | WindowsVirtualMachineSecretCertificate[] | undefined;
}
export declare class WindowsVirtualMachineSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineSecretOutputReference;
}
export interface WindowsVirtualMachineSourceImageReference {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#offer WindowsVirtualMachine#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#publisher WindowsVirtualMachine#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#sku WindowsVirtualMachine#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#version WindowsVirtualMachine#version}
    */
    readonly version: string;
}
export declare function windowsVirtualMachineSourceImageReferenceToTerraform(struct?: WindowsVirtualMachineSourceImageReferenceOutputReference | WindowsVirtualMachineSourceImageReference): any;
export declare function windowsVirtualMachineSourceImageReferenceToHclTerraform(struct?: WindowsVirtualMachineSourceImageReferenceOutputReference | WindowsVirtualMachineSourceImageReference): any;
export declare class WindowsVirtualMachineSourceImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineSourceImageReference | undefined;
    set internalValue(value: WindowsVirtualMachineSourceImageReference | undefined);
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface WindowsVirtualMachineTerminationNotification {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#enabled WindowsVirtualMachine#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#timeout WindowsVirtualMachine#timeout}
    */
    readonly timeout?: string;
}
export declare function windowsVirtualMachineTerminationNotificationToTerraform(struct?: WindowsVirtualMachineTerminationNotificationOutputReference | WindowsVirtualMachineTerminationNotification): any;
export declare function windowsVirtualMachineTerminationNotificationToHclTerraform(struct?: WindowsVirtualMachineTerminationNotificationOutputReference | WindowsVirtualMachineTerminationNotification): any;
export declare class WindowsVirtualMachineTerminationNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineTerminationNotification | undefined;
    set internalValue(value: WindowsVirtualMachineTerminationNotification | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface WindowsVirtualMachineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#create WindowsVirtualMachine#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#delete WindowsVirtualMachine#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#read WindowsVirtualMachine#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#update WindowsVirtualMachine#update}
    */
    readonly update?: string;
}
export declare function windowsVirtualMachineTimeoutsToTerraform(struct?: WindowsVirtualMachineTimeouts | cdktf.IResolvable): any;
export declare function windowsVirtualMachineTimeoutsToHclTerraform(struct?: WindowsVirtualMachineTimeouts | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface WindowsVirtualMachineWinrmListener {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#certificate_url WindowsVirtualMachine#certificate_url}
    */
    readonly certificateUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#protocol WindowsVirtualMachine#protocol}
    */
    readonly protocol: string;
}
export declare function windowsVirtualMachineWinrmListenerToTerraform(struct?: WindowsVirtualMachineWinrmListener | cdktf.IResolvable): any;
export declare function windowsVirtualMachineWinrmListenerToHclTerraform(struct?: WindowsVirtualMachineWinrmListener | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineWinrmListenerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineWinrmListener | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineWinrmListener | cdktf.IResolvable | undefined);
    private _certificateUrl?;
    get certificateUrl(): string;
    set certificateUrl(value: string);
    resetCertificateUrl(): void;
    get certificateUrlInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export declare class WindowsVirtualMachineWinrmListenerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineWinrmListener[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineWinrmListenerOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine azurerm_windows_virtual_machine}
*/
export declare class WindowsVirtualMachine extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_windows_virtual_machine";
    /**
    * Generates CDKTF code for importing a WindowsVirtualMachine resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the WindowsVirtualMachine to import
    * @param importFromId The id of the existing WindowsVirtualMachine that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the WindowsVirtualMachine to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.29.0/docs/resources/windows_virtual_machine azurerm_windows_virtual_machine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WindowsVirtualMachineConfig
    */
    constructor(scope: Construct, id: string, config: WindowsVirtualMachineConfig);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    get adminUsernameInput(): string | undefined;
    private _allowExtensionOperations?;
    get allowExtensionOperations(): boolean | cdktf.IResolvable;
    set allowExtensionOperations(value: boolean | cdktf.IResolvable);
    resetAllowExtensionOperations(): void;
    get allowExtensionOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _availabilitySetId?;
    get availabilitySetId(): string;
    set availabilitySetId(value: string);
    resetAvailabilitySetId(): void;
    get availabilitySetIdInput(): string | undefined;
    private _bypassPlatformSafetyChecksOnUserScheduleEnabled?;
    get bypassPlatformSafetyChecksOnUserScheduleEnabled(): boolean | cdktf.IResolvable;
    set bypassPlatformSafetyChecksOnUserScheduleEnabled(value: boolean | cdktf.IResolvable);
    resetBypassPlatformSafetyChecksOnUserScheduleEnabled(): void;
    get bypassPlatformSafetyChecksOnUserScheduleEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _capacityReservationGroupId?;
    get capacityReservationGroupId(): string;
    set capacityReservationGroupId(value: string);
    resetCapacityReservationGroupId(): void;
    get capacityReservationGroupIdInput(): string | undefined;
    private _computerName?;
    get computerName(): string;
    set computerName(value: string);
    resetComputerName(): void;
    get computerNameInput(): string | undefined;
    private _customData?;
    get customData(): string;
    set customData(value: string);
    resetCustomData(): void;
    get customDataInput(): string | undefined;
    private _dedicatedHostGroupId?;
    get dedicatedHostGroupId(): string;
    set dedicatedHostGroupId(value: string);
    resetDedicatedHostGroupId(): void;
    get dedicatedHostGroupIdInput(): string | undefined;
    private _dedicatedHostId?;
    get dedicatedHostId(): string;
    set dedicatedHostId(value: string);
    resetDedicatedHostId(): void;
    get dedicatedHostIdInput(): string | undefined;
    private _diskControllerType?;
    get diskControllerType(): string;
    set diskControllerType(value: string);
    resetDiskControllerType(): void;
    get diskControllerTypeInput(): string | undefined;
    private _edgeZone?;
    get edgeZone(): string;
    set edgeZone(value: string);
    resetEdgeZone(): void;
    get edgeZoneInput(): string | undefined;
    private _enableAutomaticUpdates?;
    get enableAutomaticUpdates(): boolean | cdktf.IResolvable;
    set enableAutomaticUpdates(value: boolean | cdktf.IResolvable);
    resetEnableAutomaticUpdates(): void;
    get enableAutomaticUpdatesInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionAtHostEnabled?;
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionAtHostEnabled(): void;
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evictionPolicy?;
    get evictionPolicy(): string;
    set evictionPolicy(value: string);
    resetEvictionPolicy(): void;
    get evictionPolicyInput(): string | undefined;
    private _extensionsTimeBudget?;
    get extensionsTimeBudget(): string;
    set extensionsTimeBudget(value: string);
    resetExtensionsTimeBudget(): void;
    get extensionsTimeBudgetInput(): string | undefined;
    private _hotpatchingEnabled?;
    get hotpatchingEnabled(): boolean | cdktf.IResolvable;
    set hotpatchingEnabled(value: boolean | cdktf.IResolvable);
    resetHotpatchingEnabled(): void;
    get hotpatchingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    resetLicenseType(): void;
    get licenseTypeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maxBidPrice?;
    get maxBidPrice(): number;
    set maxBidPrice(value: number);
    resetMaxBidPrice(): void;
    get maxBidPriceInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkInterfaceIds?;
    get networkInterfaceIds(): string[];
    set networkInterfaceIds(value: string[]);
    get networkInterfaceIdsInput(): string[] | undefined;
    private _patchAssessmentMode?;
    get patchAssessmentMode(): string;
    set patchAssessmentMode(value: string);
    resetPatchAssessmentMode(): void;
    get patchAssessmentModeInput(): string | undefined;
    private _patchMode?;
    get patchMode(): string;
    set patchMode(value: string);
    resetPatchMode(): void;
    get patchModeInput(): string | undefined;
    private _platformFaultDomain?;
    get platformFaultDomain(): number;
    set platformFaultDomain(value: number);
    resetPlatformFaultDomain(): void;
    get platformFaultDomainInput(): number | undefined;
    private _priority?;
    get priority(): string;
    set priority(value: string);
    resetPriority(): void;
    get priorityInput(): string | undefined;
    get privateIpAddress(): string;
    get privateIpAddresses(): string[];
    private _provisionVmAgent?;
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    resetProvisionVmAgent(): void;
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _proximityPlacementGroupId?;
    get proximityPlacementGroupId(): string;
    set proximityPlacementGroupId(value: string);
    resetProximityPlacementGroupId(): void;
    get proximityPlacementGroupIdInput(): string | undefined;
    get publicIpAddress(): string;
    get publicIpAddresses(): string[];
    private _rebootSetting?;
    get rebootSetting(): string;
    set rebootSetting(value: string);
    resetRebootSetting(): void;
    get rebootSettingInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _secureBootEnabled?;
    get secureBootEnabled(): boolean | cdktf.IResolvable;
    set secureBootEnabled(value: boolean | cdktf.IResolvable);
    resetSecureBootEnabled(): void;
    get secureBootEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _size?;
    get size(): string;
    set size(value: string);
    get sizeInput(): string | undefined;
    private _sourceImageId?;
    get sourceImageId(): string;
    set sourceImageId(value: string);
    resetSourceImageId(): void;
    get sourceImageIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    get virtualMachineId(): string;
    private _virtualMachineScaleSetId?;
    get virtualMachineScaleSetId(): string;
    set virtualMachineScaleSetId(value: string);
    resetVirtualMachineScaleSetId(): void;
    get virtualMachineScaleSetIdInput(): string | undefined;
    private _vmAgentPlatformUpdatesEnabled?;
    get vmAgentPlatformUpdatesEnabled(): boolean | cdktf.IResolvable;
    set vmAgentPlatformUpdatesEnabled(value: boolean | cdktf.IResolvable);
    resetVmAgentPlatformUpdatesEnabled(): void;
    get vmAgentPlatformUpdatesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vtpmEnabled?;
    get vtpmEnabled(): boolean | cdktf.IResolvable;
    set vtpmEnabled(value: boolean | cdktf.IResolvable);
    resetVtpmEnabled(): void;
    get vtpmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _additionalCapabilities;
    get additionalCapabilities(): WindowsVirtualMachineAdditionalCapabilitiesOutputReference;
    putAdditionalCapabilities(value: WindowsVirtualMachineAdditionalCapabilities): void;
    resetAdditionalCapabilities(): void;
    get additionalCapabilitiesInput(): WindowsVirtualMachineAdditionalCapabilities | undefined;
    private _additionalUnattendContent;
    get additionalUnattendContent(): WindowsVirtualMachineAdditionalUnattendContentList;
    putAdditionalUnattendContent(value: WindowsVirtualMachineAdditionalUnattendContent[] | cdktf.IResolvable): void;
    resetAdditionalUnattendContent(): void;
    get additionalUnattendContentInput(): cdktf.IResolvable | WindowsVirtualMachineAdditionalUnattendContent[] | undefined;
    private _bootDiagnostics;
    get bootDiagnostics(): WindowsVirtualMachineBootDiagnosticsOutputReference;
    putBootDiagnostics(value: WindowsVirtualMachineBootDiagnostics): void;
    resetBootDiagnostics(): void;
    get bootDiagnosticsInput(): WindowsVirtualMachineBootDiagnostics | undefined;
    private _galleryApplication;
    get galleryApplication(): WindowsVirtualMachineGalleryApplicationList;
    putGalleryApplication(value: WindowsVirtualMachineGalleryApplication[] | cdktf.IResolvable): void;
    resetGalleryApplication(): void;
    get galleryApplicationInput(): cdktf.IResolvable | WindowsVirtualMachineGalleryApplication[] | undefined;
    private _identity;
    get identity(): WindowsVirtualMachineIdentityOutputReference;
    putIdentity(value: WindowsVirtualMachineIdentity): void;
    resetIdentity(): void;
    get identityInput(): WindowsVirtualMachineIdentity | undefined;
    private _osDisk;
    get osDisk(): WindowsVirtualMachineOsDiskOutputReference;
    putOsDisk(value: WindowsVirtualMachineOsDisk): void;
    get osDiskInput(): WindowsVirtualMachineOsDisk | undefined;
    private _osImageNotification;
    get osImageNotification(): WindowsVirtualMachineOsImageNotificationOutputReference;
    putOsImageNotification(value: WindowsVirtualMachineOsImageNotification): void;
    resetOsImageNotification(): void;
    get osImageNotificationInput(): WindowsVirtualMachineOsImageNotification | undefined;
    private _plan;
    get plan(): WindowsVirtualMachinePlanOutputReference;
    putPlan(value: WindowsVirtualMachinePlan): void;
    resetPlan(): void;
    get planInput(): WindowsVirtualMachinePlan | undefined;
    private _secret;
    get secret(): WindowsVirtualMachineSecretList;
    putSecret(value: WindowsVirtualMachineSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | WindowsVirtualMachineSecret[] | undefined;
    private _sourceImageReference;
    get sourceImageReference(): WindowsVirtualMachineSourceImageReferenceOutputReference;
    putSourceImageReference(value: WindowsVirtualMachineSourceImageReference): void;
    resetSourceImageReference(): void;
    get sourceImageReferenceInput(): WindowsVirtualMachineSourceImageReference | undefined;
    private _terminationNotification;
    get terminationNotification(): WindowsVirtualMachineTerminationNotificationOutputReference;
    putTerminationNotification(value: WindowsVirtualMachineTerminationNotification): void;
    resetTerminationNotification(): void;
    get terminationNotificationInput(): WindowsVirtualMachineTerminationNotification | undefined;
    private _timeouts;
    get timeouts(): WindowsVirtualMachineTimeoutsOutputReference;
    putTimeouts(value: WindowsVirtualMachineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WindowsVirtualMachineTimeouts | undefined;
    private _winrmListener;
    get winrmListener(): WindowsVirtualMachineWinrmListenerList;
    putWinrmListener(value: WindowsVirtualMachineWinrmListener[] | cdktf.IResolvable): void;
    resetWinrmListener(): void;
    get winrmListenerInput(): cdktf.IResolvable | WindowsVirtualMachineWinrmListener[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
