"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aspects = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ASPECTS_SYMBOL = Symbol.for('cdk-aspects');
/**
 * Aspects can be applied to CDK tree scopes and can operate on the tree before
 * synthesis.
 */
class Aspects {
    // TODO(2.0): private readonly _aspects = new Array<IAspect>();
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * Returns the `Aspects` object associated with a construct scope.
     * @param scope The scope for which these aspects will apply.
     */
    static of(scope) {
        jsiiDeprecationWarnings._aws_cdk_core_IConstruct(scope);
        let aspects = scope[ASPECTS_SYMBOL];
        if (!aspects) {
            aspects = new Aspects(scope);
            Object.defineProperty(scope, ASPECTS_SYMBOL, {
                value: aspects,
                configurable: false,
                enumerable: false,
            });
        }
        return aspects;
    }
    /**
     * Adds an aspect to apply this scope before synthesis.
     * @param aspect The aspect to add.
     */
    add(aspect) {
        jsiiDeprecationWarnings._aws_cdk_core_IAspect(aspect);
        // TODO(2.0): this._aspects.push(aspect);
        this.scope.node._actualNode.applyAspect(aspect);
    }
    /**
     * The list of aspects which were directly applied on this scope.
     */
    get aspects() {
        // TODO(2.0): return  [ ...this._aspects ];
        return [...this.scope.node._actualNode._aspects]; // clone
    }
}
exports.Aspects = Aspects;
_a = JSII_RTTI_SYMBOL_1;
Aspects[_a] = { fqn: "@aws-cdk/core.Aspects", version: "1.150.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXNwZWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXNwZWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUVBLE1BQU0sY0FBYyxHQUFHLE1BQU0sQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7QUFZakQ7OztHQUdHO0FBQ0gsTUFBYSxPQUFPO0lBb0JsQiwrREFBK0Q7SUFDL0QsWUFBcUMsS0FBaUI7UUFBakIsVUFBSyxHQUFMLEtBQUssQ0FBWTtLQUFLO0lBbkIzRDs7O09BR0c7SUFDSSxNQUFNLENBQUMsRUFBRSxDQUFDLEtBQWlCOztRQUNoQyxJQUFJLE9BQU8sR0FBSSxLQUFhLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDN0MsSUFBSSxDQUFDLE9BQU8sRUFBRTtZQUNaLE9BQU8sR0FBRyxJQUFJLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUU3QixNQUFNLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRSxjQUFjLEVBQUU7Z0JBQzNDLEtBQUssRUFBRSxPQUFPO2dCQUNkLFlBQVksRUFBRSxLQUFLO2dCQUNuQixVQUFVLEVBQUUsS0FBSzthQUNsQixDQUFDLENBQUM7U0FDSjtRQUNELE9BQU8sT0FBTyxDQUFDO0tBQ2hCO0lBS0Q7OztPQUdHO0lBQ0ksR0FBRyxDQUFDLE1BQWU7O1FBQ3hCLHlDQUF5QztRQUN6QyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0tBQ2pEO0lBRUQ7O09BRUc7SUFDSCxJQUFXLE9BQU87UUFDaEIsMkNBQTJDO1FBQzNDLE9BQU8sQ0FBQyxHQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFdBQW1CLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxRQUFRO0tBQ3BFOztBQXRDSCwwQkF1Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJQ29uc3RydWN0IH0gZnJvbSAnLi9jb25zdHJ1Y3QtY29tcGF0JztcblxuY29uc3QgQVNQRUNUU19TWU1CT0wgPSBTeW1ib2wuZm9yKCdjZGstYXNwZWN0cycpO1xuXG4vKipcbiAqIFJlcHJlc2VudHMgYW4gQXNwZWN0XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUFzcGVjdCB7XG4gIC8qKlxuICAgKiBBbGwgYXNwZWN0cyBjYW4gdmlzaXQgYW4gSUNvbnN0cnVjdFxuICAgKi9cbiAgdmlzaXQobm9kZTogSUNvbnN0cnVjdCk6IHZvaWQ7XG59XG5cbi8qKlxuICogQXNwZWN0cyBjYW4gYmUgYXBwbGllZCB0byBDREsgdHJlZSBzY29wZXMgYW5kIGNhbiBvcGVyYXRlIG9uIHRoZSB0cmVlIGJlZm9yZVxuICogc3ludGhlc2lzLlxuICovXG5leHBvcnQgY2xhc3MgQXNwZWN0cyB7XG5cbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIGBBc3BlY3RzYCBvYmplY3QgYXNzb2NpYXRlZCB3aXRoIGEgY29uc3RydWN0IHNjb3BlLlxuICAgKiBAcGFyYW0gc2NvcGUgVGhlIHNjb3BlIGZvciB3aGljaCB0aGVzZSBhc3BlY3RzIHdpbGwgYXBwbHkuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIG9mKHNjb3BlOiBJQ29uc3RydWN0KTogQXNwZWN0cyB7XG4gICAgbGV0IGFzcGVjdHMgPSAoc2NvcGUgYXMgYW55KVtBU1BFQ1RTX1NZTUJPTF07XG4gICAgaWYgKCFhc3BlY3RzKSB7XG4gICAgICBhc3BlY3RzID0gbmV3IEFzcGVjdHMoc2NvcGUpO1xuXG4gICAgICBPYmplY3QuZGVmaW5lUHJvcGVydHkoc2NvcGUsIEFTUEVDVFNfU1lNQk9MLCB7XG4gICAgICAgIHZhbHVlOiBhc3BlY3RzLFxuICAgICAgICBjb25maWd1cmFibGU6IGZhbHNlLFxuICAgICAgICBlbnVtZXJhYmxlOiBmYWxzZSxcbiAgICAgIH0pO1xuICAgIH1cbiAgICByZXR1cm4gYXNwZWN0cztcbiAgfVxuXG4gIC8vIFRPRE8oMi4wKTogcHJpdmF0ZSByZWFkb25seSBfYXNwZWN0cyA9IG5ldyBBcnJheTxJQXNwZWN0PigpO1xuICBwcml2YXRlIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgc2NvcGU6IElDb25zdHJ1Y3QpIHsgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGFuIGFzcGVjdCB0byBhcHBseSB0aGlzIHNjb3BlIGJlZm9yZSBzeW50aGVzaXMuXG4gICAqIEBwYXJhbSBhc3BlY3QgVGhlIGFzcGVjdCB0byBhZGQuXG4gICAqL1xuICBwdWJsaWMgYWRkKGFzcGVjdDogSUFzcGVjdCkge1xuICAgIC8vIFRPRE8oMi4wKTogdGhpcy5fYXNwZWN0cy5wdXNoKGFzcGVjdCk7XG4gICAgdGhpcy5zY29wZS5ub2RlLl9hY3R1YWxOb2RlLmFwcGx5QXNwZWN0KGFzcGVjdCk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIGxpc3Qgb2YgYXNwZWN0cyB3aGljaCB3ZXJlIGRpcmVjdGx5IGFwcGxpZWQgb24gdGhpcyBzY29wZS5cbiAgICovXG4gIHB1YmxpYyBnZXQgYXNwZWN0cygpOiBJQXNwZWN0W10ge1xuICAgIC8vIFRPRE8oMi4wKTogcmV0dXJuICBbIC4uLnRoaXMuX2FzcGVjdHMgXTtcbiAgICByZXR1cm4gWy4uLih0aGlzLnNjb3BlLm5vZGUuX2FjdHVhbE5vZGUgYXMgYW55KS5fYXNwZWN0c107IC8vIGNsb25lXG4gIH1cbn0iXX0=