import datetime
import typing
from concurrent.futures import Future
from datetime import timedelta
from typing import (
    Any,
    Optional,
)
from os import PathLike

import assertionengine

from .utils.data_types import *


class Browser:
    timeout: Any = ...
    def __init__(self, timeout: timedelta = timedelta(seconds=10.0), enable_playwright_debug: bool = False, auto_closing_level: AutoClosingLevel = AutoClosingLevel.TEST, retry_assertions_for: timedelta = timedelta(seconds=1.0), run_on_failure: str = 'Take Screenshot  fail-screenshot-{index}', external_browser_executable: Union[typing.Dict[SupportedBrowsers, str], None] = None, jsextension: Union[str, None] = None, enable_presenter_mode: bool = False, playwright_process_port: Union[int, None] = None, strict: bool = True): ...
    def add_cookie(self, name: str, value: str, url: Union[str, None] = None, domain: Union[str, None] = None, path: Union[str, None] = None, expires: Union[str, None] = None, httpOnly: Union[bool, None] = None, secure: Union[bool, None] = None, sameSite: Union[CookieSameSite, None] = None): ...
    def add_style_tag(self, content: str): ...
    def check_checkbox(self, selector: str): ...
    def clear_permissions(self): ...
    def clear_text(self, selector: str): ...
    def click(self, selector: str, button: MouseButton = MouseButton.left, clickCount: int = 1, delay: Union[datetime.timedelta, None] = None, position_x: Union[float, None] = None, position_y: Union[float, None] = None, force: bool = False, noWaitAfter: bool = False, *modifiers: KeyboardModifier): ...
    def close_browser(self, browser: str = 'CURRENT'): ...
    def close_context(self, context: str = 'CURRENT', browser: str = 'CURRENT'): ...
    def close_page(self, page: str = 'CURRENT', context: str = 'CURRENT', browser: str = 'CURRENT'): ...
    def connect_to_browser(self, wsEndpoint: str, browser: SupportedBrowsers = SupportedBrowsers.chromium): ...
    def crawl_site(self, url: Union[str, None] = None, page_crawl_keyword = 'take_screenshot', max_number_of_page_to_crawl: int = 1000, max_depth_to_crawl: int = 50): ...
    def delete_all_cookies(self): ...
    def deselect_options(self, selector: str): ...
    def download(self, url: str): ...
    def drag_and_drop(self, selector_from: str, selector_to: str, steps: int = 1): ...
    def drag_and_drop_by_coordinates(self, from_x: float, from_y: float, to_x: float, to_y: float, steps: int = 1): ...
    def eat_all_cookies(self): ...
    def execute_javascript(self, function: str, selector: str = ''): ...
    def fill_secret(self, selector: str, secret: str): ...
    def fill_text(self, selector: str, txt: str): ...
    def focus(self, selector: str): ...
    def get_attribute(self, selector: str, attribute: str, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_attribute_names(self, selector: str, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, *assertion_expected, message: Union[str, None] = None): ...
    def get_boundingbox(self, selector: str, key: BoundingBoxFields = BoundingBoxFields.ALL, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_browser_catalog(self, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_browser_ids(self, browser: SelectionType = SelectionType.ALL): ...
    def get_checkbox_state(self, selector: str, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, expected_state: Union[bool, str] = 'Unchecked', message: Union[str, None] = None): ...
    def get_classes(self, selector: str, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, *assertion_expected, message: Union[str, None] = None): ...
    def get_client_size(self, selector: Union[str, None] = None, key: SizeFields = SizeFields.ALL, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_context_ids(self, context: SelectionType = SelectionType.ALL, browser: SelectionType = SelectionType.ALL): ...
    def get_cookie(self, cookie: str, return_type: CookieType = CookieType.dictionary): ...
    def get_cookies(self, return_type: CookieType = CookieType.dictionary): ...
    def get_device(self, name: str): ...
    def get_devices(self): ...
    def get_element(self, selector: str): ...
    def get_element_count(self, selector: str, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, expected_value: Union[int, str] = 0, message: Union[str, None] = None): ...
    def get_element_state(self, selector: str, state: ElementStateKey = ElementStateKey.visible, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_elements(self, selector: str): ...
    def get_page_ids(self, page: SelectionType = SelectionType.ALL, context: SelectionType = SelectionType.ALL, browser: SelectionType = SelectionType.ALL): ...
    def get_page_source(self, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_property(self, selector: str, property: str, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_scroll_position(self, selector: Union[str, None] = None, key: AreaFields = AreaFields.ALL, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_scroll_size(self, selector: Union[str, None] = None, key: SizeFields = SizeFields.ALL, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_select_options(self, selector: str, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_selected_options(self, selector: str, option_attribute: SelectAttribute = SelectAttribute.label, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, *assertion_expected): ...
    def get_style(self, selector: str, key: str = 'ALL', assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_text(self, selector: str, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_title(self, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_url(self, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def get_viewport_size(self, key: SizeFields = SizeFields.ALL, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def go_back(self): ...
    def go_forward(self): ...
    def go_to(self, url: str, timeout: Union[datetime.timedelta, None] = None): ...
    def grant_permissions(self, *permissions: Permission, origin: Union[str, None] = None): ...
    def handle_future_dialogs(self, action: DialogAction, prompt_input: str = ''): ...
    def highlight_elements(self, selector: str, duration: timedelta = timedelta(seconds=5.0), width: str = '2px', style: str = 'dotted', color: str = 'blue'): ...
    def hover(self, selector: str, position_x: Union[float, None] = None, position_y: Union[float, None] = None, force: bool = False, *modifiers: KeyboardModifier): ...
    def http(self, url: str, method: RequestMethod = RequestMethod.GET, body: Union[str, None] = None, headers: Union[dict, None] = None): ...
    def keyboard_input(self, action: KeyboardInputAction, input: str, delay = 0): ...
    def keyboard_key(self, action: KeyAction, key: str): ...
    def local_storage_clear(self): ...
    def local_storage_get_item(self, key: str, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None, message: Union[str, None] = None): ...
    def local_storage_remove_item(self, key: str): ...
    def local_storage_set_item(self, key: str, value: str): ...
    def mouse_button(self, action: MouseButtonAction, x: Union[float, None] = None, y: Union[float, None] = None, button: MouseButton = MouseButton.left, clickCount: int = 1, delay: int = 0): ...
    def mouse_move(self, x: float, y: float, steps: int = 1): ...
    def mouse_move_relative_to(self, selector: str, x: float = 0.0, y: float = 0.0, steps: int = 1): ...
    def new_browser(self, browser: SupportedBrowsers = SupportedBrowsers.chromium, headless: bool = True, executablePath: Union[str, None] = None, args: Union[typing.List[str], None] = None, ignoreDefaultArgs: Union[typing.List[str], None] = None, proxy: Union[Proxy, None] = None, downloadsPath: Union[str, None] = None, handleSIGINT: bool = True, handleSIGTERM: bool = True, handleSIGHUP: bool = True, timeout: timedelta = timedelta(seconds=30.0), env: Union[typing.Dict, None] = None, devtools: bool = False, slowMo: timedelta = timedelta(seconds=0.0), channel: Union[str, None] = None): ...
    def new_context(self, acceptDownloads: bool = False, ignoreHTTPSErrors: bool = False, bypassCSP: bool = False, viewport: Union[ViewportDimensions, None] = None, userAgent: Union[str, None] = None, deviceScaleFactor: float = 1.0, isMobile: bool = False, hasTouch: bool = False, javaScriptEnabled: bool = True, timezoneId: Union[str, None] = None, geolocation: Union[GeoLocation, None] = None, locale: Union[str, None] = None, permissions: Union[typing.List[Permission], None] = None, extraHTTPHeaders: Union[typing.Dict[str, str], None] = None, offline: bool = False, httpCredentials: Union[HttpCredentials, None] = None, colorScheme: Union[ColorScheme, None] = None, proxy: Union[Proxy, None] = None, videosPath: Union[str, None] = None, videoSize: Union[ViewportDimensions, None] = None, defaultBrowserType: Union[SupportedBrowsers, None] = None, hideRfBrowser: bool = False, recordVideo: Union[RecordVideo, None] = None, recordHar: Union[RecordHar, None] = None, tracing: Union[str, None] = None, screen: Union[typing.Dict[str, int], None] = None, storageState: Union[str, None] = None): ...
    def new_page(self, url: Union[str, None] = None): ...
    def open_browser(self, url: Union[str, None] = None, browser: SupportedBrowsers = SupportedBrowsers.chromium, headless: bool = False, pause_on_failure: bool = True, bypassCSP = True): ...
    def press_keys(self, selector: str, *keys: str): ...
    def promise_to(self, kw: str, *args): ...
    def promise_to_upload_file(self, path: PathLike): ...
    def promise_to_wait_for_download(self, saveAs: str = ''): ...
    def record_selector(self, label: Union[str, None] = None): ...
    def register_keyword_to_run_on_failure(self, keyword: Union[str, None], *args: str): ...
    def reload(self): ...
    def save_storage_state(self): ...
    def scroll_by(self, selector: Union[str, None] = None, vertical: str = 'height', horizontal: str = '0', behavior: ScrollBehavior = ScrollBehavior.auto): ...
    def scroll_to(self, selector: Union[str, None] = None, vertical: str = 'top', horizontal: str = 'left', behavior: ScrollBehavior = ScrollBehavior.auto): ...
    def select_options_by(self, selector: str, attribute: SelectAttribute, *values): ...
    def session_storage_clear(self): ...
    def session_storage_get_item(self, key: str, assertion_operator: Union[assertionengine.assertion_engine.AssertionOperator, None] = None, assertion_expected: Union[typing.Any, None] = None): ...
    def session_storage_remove_item(self, key: str): ...
    def session_storage_set_item(self, key: str, value: str): ...
    def set_assertion_formatters(self, formatters: Dict[str, typing.List[str]]): ...
    def set_browser_timeout(self, timeout: timedelta): ...
    def set_geolocation(self, latitude: float, longitude: float, accuracy: Union[float, None] = None): ...
    def set_offline(self, offline: bool = True): ...
    def set_retry_assertions_for(self, timeout: timedelta): ...
    def set_strict_mode(self, mode: bool): ...
    def set_viewport_size(self, width: int, height: int): ...
    def switch_browser(self, id: str): ...
    def switch_context(self, id: str, browser: str = 'CURRENT'): ...
    def switch_page(self, id: Union[NewPageDetails, str], context: str = 'CURRENT', browser: str = 'CURRENT'): ...
    def take_screenshot(self, filename: str = 'robotframework-browser-screenshot-{index}', selector: str = '', fullPage: bool = False, fileType: ScreenshotFileTypes = ScreenshotFileTypes.png, quality: str = '', timeout: Union[datetime.timedelta, None] = None): ...
    def type_secret(self, selector: str, secret: str, delay: timedelta = timedelta(seconds=0.0), clear: bool = True): ...
    def type_text(self, selector: str, txt: str, delay: timedelta = timedelta(seconds=0.0), clear: bool = True): ...
    def uncheck_checkbox(self, selector: str): ...
    def upload_file_by_selector(self, selector: str, path: PathLike): ...
    def wait_for(self, *promises: Future): ...
    def wait_for_alert(self, action: DialogAction, prompt_input: str = '', text: Union[str, None] = None): ...
    def wait_for_all_promises(self): ...
    def wait_for_elements_state(self, selector: str, state: ElementState = ElementState.visible, timeout: Union[datetime.timedelta, None] = None, message: Union[str, None] = None): ...
    def wait_for_function(self, function: str, selector: str = '', polling: Union[str, datetime.timedelta] = 'raf', timeout: Union[datetime.timedelta, None] = None, message: Union[str, None] = None): ...
    def wait_for_navigation(self, url: str, timeout: Union[datetime.timedelta, None] = None, wait_until: PageLoadStates = PageLoadStates.load): ...
    def wait_for_request(self, matcher: str = '', timeout: Union[datetime.timedelta, None] = None): ...
    def wait_for_response(self, matcher: str = '', timeout: Union[datetime.timedelta, None] = None): ...
    def wait_until_network_is_idle(self, timeout: Union[datetime.timedelta, None] = None): ...
    def get_timeout(self, timeout: Union[timedelta, None]) -> float: ...
    def convert_timeout(self, timeout: Union[timedelta, float], to_ms: bool = True) -> float: ...
    def millisecs_to_timestr(self, timeout: float)  -> str: ...
    def get_strict_mode(self, strict: Union[bool, None]) -> bool: ...
    def _parse_run_on_failure_keyword(self, keyword_name: Union[str, None]) -> DelayedKeyword: ...

