from akida.core import Layer, LayerParams, LayerType


class Dequantizer(Layer):
    """A layer capable of dequantizing an input tensor.

    This resolve the scales of an input tensor, following the equantion::

        output = input x scales
    """

    def __init__(self, name=""):
        try:
            params = LayerParams(LayerType.Dequantizer, {})
            Layer.__init__(self, params, name)
        except BaseException:
            self = None
            raise
