import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WarehouseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#auto_resume Warehouse#auto_resume}
    */
    readonly autoResume?: boolean | cdktf.IResolvable;
    /**
    * Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#auto_suspend Warehouse#auto_suspend}
    */
    readonly autoSuspend?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#comment Warehouse#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#id Warehouse#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies whether the warehouse is created initially in the ‘Suspended’ state.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#initially_suspended Warehouse#initially_suspended}
    */
    readonly initiallySuspended?: boolean | cdktf.IResolvable;
    /**
    * Specifies the maximum number of server clusters for the warehouse.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#max_cluster_count Warehouse#max_cluster_count}
    */
    readonly maxClusterCount?: number;
    /**
    * Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#max_concurrency_level Warehouse#max_concurrency_level}
    */
    readonly maxConcurrencyLevel?: number;
    /**
    * Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#min_cluster_count Warehouse#min_cluster_count}
    */
    readonly minClusterCount?: number;
    /**
    * Identifier for the virtual warehouse; must be unique for your account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#name Warehouse#name}
    */
    readonly name: string;
    /**
    * Specifies the name of a resource monitor that is explicitly assigned to the warehouse.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#resource_monitor Warehouse#resource_monitor}
    */
    readonly resourceMonitor?: string;
    /**
    * Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#scaling_policy Warehouse#scaling_policy}
    */
    readonly scalingPolicy?: string;
    /**
    * Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#statement_queued_timeout_in_seconds Warehouse#statement_queued_timeout_in_seconds}
    */
    readonly statementQueuedTimeoutInSeconds?: number;
    /**
    * Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#statement_timeout_in_seconds Warehouse#statement_timeout_in_seconds}
    */
    readonly statementTimeoutInSeconds?: number;
    /**
    * Specifies whether the warehouse, after being resized, waits for all the servers to provision before executing any queued or new queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#wait_for_provisioning Warehouse#wait_for_provisioning}
    */
    readonly waitForProvisioning?: boolean | cdktf.IResolvable;
    /**
    * Specifies the size of the virtual warehouse. Larger warehouse sizes 5X-Large and 6X-Large are currently in preview and only available on Amazon Web Services (AWS).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#warehouse_size Warehouse#warehouse_size}
    */
    readonly warehouseSize?: string;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#tag Warehouse#tag}
    */
    readonly tag?: WarehouseTag[] | cdktf.IResolvable;
}
export interface WarehouseTag {
    /**
    * Name of the database that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#database Warehouse#database}
    */
    readonly database?: string;
    /**
    * Tag name, e.g. department.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#name Warehouse#name}
    */
    readonly name: string;
    /**
    * Name of the schema that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#schema Warehouse#schema}
    */
    readonly schema?: string;
    /**
    * Tag value, e.g. marketing_info.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#value Warehouse#value}
    */
    readonly value: string;
}
export declare function warehouseTagToTerraform(struct?: WarehouseTag | cdktf.IResolvable): any;
export declare class WarehouseTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WarehouseTag | cdktf.IResolvable | undefined;
    set internalValue(value: WarehouseTag | cdktf.IResolvable | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class WarehouseTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WarehouseTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WarehouseTagOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse snowflake_warehouse}
*/
export declare class Warehouse extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_warehouse";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse snowflake_warehouse} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WarehouseConfig
    */
    constructor(scope: Construct, id: string, config: WarehouseConfig);
    private _autoResume?;
    get autoResume(): boolean | cdktf.IResolvable;
    set autoResume(value: boolean | cdktf.IResolvable);
    resetAutoResume(): void;
    get autoResumeInput(): boolean | cdktf.IResolvable | undefined;
    private _autoSuspend?;
    get autoSuspend(): number;
    set autoSuspend(value: number);
    resetAutoSuspend(): void;
    get autoSuspendInput(): number | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initiallySuspended?;
    get initiallySuspended(): boolean | cdktf.IResolvable;
    set initiallySuspended(value: boolean | cdktf.IResolvable);
    resetInitiallySuspended(): void;
    get initiallySuspendedInput(): boolean | cdktf.IResolvable | undefined;
    private _maxClusterCount?;
    get maxClusterCount(): number;
    set maxClusterCount(value: number);
    resetMaxClusterCount(): void;
    get maxClusterCountInput(): number | undefined;
    private _maxConcurrencyLevel?;
    get maxConcurrencyLevel(): number;
    set maxConcurrencyLevel(value: number);
    resetMaxConcurrencyLevel(): void;
    get maxConcurrencyLevelInput(): number | undefined;
    private _minClusterCount?;
    get minClusterCount(): number;
    set minClusterCount(value: number);
    resetMinClusterCount(): void;
    get minClusterCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceMonitor?;
    get resourceMonitor(): string;
    set resourceMonitor(value: string);
    resetResourceMonitor(): void;
    get resourceMonitorInput(): string | undefined;
    private _scalingPolicy?;
    get scalingPolicy(): string;
    set scalingPolicy(value: string);
    resetScalingPolicy(): void;
    get scalingPolicyInput(): string | undefined;
    private _statementQueuedTimeoutInSeconds?;
    get statementQueuedTimeoutInSeconds(): number;
    set statementQueuedTimeoutInSeconds(value: number);
    resetStatementQueuedTimeoutInSeconds(): void;
    get statementQueuedTimeoutInSecondsInput(): number | undefined;
    private _statementTimeoutInSeconds?;
    get statementTimeoutInSeconds(): number;
    set statementTimeoutInSeconds(value: number);
    resetStatementTimeoutInSeconds(): void;
    get statementTimeoutInSecondsInput(): number | undefined;
    private _waitForProvisioning?;
    get waitForProvisioning(): boolean | cdktf.IResolvable;
    set waitForProvisioning(value: boolean | cdktf.IResolvable);
    resetWaitForProvisioning(): void;
    get waitForProvisioningInput(): boolean | cdktf.IResolvable | undefined;
    private _warehouseSize?;
    get warehouseSize(): string;
    set warehouseSize(value: string);
    resetWarehouseSize(): void;
    get warehouseSizeInput(): string | undefined;
    private _tag;
    get tag(): WarehouseTagList;
    putTag(value: WarehouseTag[] | cdktf.IResolvable): void;
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | WarehouseTag[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
