import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementApiDiagnosticConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#always_log_errors ApiManagementApiDiagnostic#always_log_errors}
    */
    readonly alwaysLogErrors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#api_management_logger_id ApiManagementApiDiagnostic#api_management_logger_id}
    */
    readonly apiManagementLoggerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#api_management_name ApiManagementApiDiagnostic#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#api_name ApiManagementApiDiagnostic#api_name}
    */
    readonly apiName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#http_correlation_protocol ApiManagementApiDiagnostic#http_correlation_protocol}
    */
    readonly httpCorrelationProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#identifier ApiManagementApiDiagnostic#identifier}
    */
    readonly identifier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#log_client_ip ApiManagementApiDiagnostic#log_client_ip}
    */
    readonly logClientIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#operation_name_format ApiManagementApiDiagnostic#operation_name_format}
    */
    readonly operationNameFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#resource_group_name ApiManagementApiDiagnostic#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#sampling_percentage ApiManagementApiDiagnostic#sampling_percentage}
    */
    readonly samplingPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#verbosity ApiManagementApiDiagnostic#verbosity}
    */
    readonly verbosity?: string;
    /**
    * backend_request block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#backend_request ApiManagementApiDiagnostic#backend_request}
    */
    readonly backendRequest?: ApiManagementApiDiagnosticBackendRequest;
    /**
    * backend_response block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#backend_response ApiManagementApiDiagnostic#backend_response}
    */
    readonly backendResponse?: ApiManagementApiDiagnosticBackendResponse;
    /**
    * frontend_request block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#frontend_request ApiManagementApiDiagnostic#frontend_request}
    */
    readonly frontendRequest?: ApiManagementApiDiagnosticFrontendRequest;
    /**
    * frontend_response block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#frontend_response ApiManagementApiDiagnostic#frontend_response}
    */
    readonly frontendResponse?: ApiManagementApiDiagnosticFrontendResponse;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#timeouts ApiManagementApiDiagnostic#timeouts}
    */
    readonly timeouts?: ApiManagementApiDiagnosticTimeouts;
}
export interface ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticBackendRequestDataMaskingHeadersToTerraform(struct?: ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders | cdktf.IResolvable): any;
export interface ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticBackendRequestDataMaskingQueryParamsToTerraform(struct?: ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams | cdktf.IResolvable): any;
export interface ApiManagementApiDiagnosticBackendRequestDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers ApiManagementApiDiagnostic#headers}
    */
    readonly headers?: ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#query_params ApiManagementApiDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementApiDiagnosticBackendRequestDataMaskingToTerraform(struct?: ApiManagementApiDiagnosticBackendRequestDataMaskingOutputReference | ApiManagementApiDiagnosticBackendRequestDataMasking): any;
export declare class ApiManagementApiDiagnosticBackendRequestDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiDiagnosticBackendRequestDataMasking | undefined;
    set internalValue(value: ApiManagementApiDiagnosticBackendRequestDataMasking | undefined);
    private _headers?;
    get headers(): ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    set headers(value: ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders[] | cdktf.IResolvable);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders[] | undefined;
    private _queryParams?;
    get queryParams(): ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
    set queryParams(value: ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams[] | cdktf.IResolvable);
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementApiDiagnosticBackendRequest {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#body_bytes ApiManagementApiDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers_to_log ApiManagementApiDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#data_masking ApiManagementApiDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementApiDiagnosticBackendRequestDataMasking;
}
export declare function apiManagementApiDiagnosticBackendRequestToTerraform(struct?: ApiManagementApiDiagnosticBackendRequestOutputReference | ApiManagementApiDiagnosticBackendRequest): any;
export declare class ApiManagementApiDiagnosticBackendRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiDiagnosticBackendRequest | undefined;
    set internalValue(value: ApiManagementApiDiagnosticBackendRequest | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementApiDiagnosticBackendRequestDataMaskingOutputReference;
    putDataMasking(value: ApiManagementApiDiagnosticBackendRequestDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementApiDiagnosticBackendRequestDataMasking | undefined;
}
export interface ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticBackendResponseDataMaskingHeadersToTerraform(struct?: ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders | cdktf.IResolvable): any;
export interface ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticBackendResponseDataMaskingQueryParamsToTerraform(struct?: ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams | cdktf.IResolvable): any;
export interface ApiManagementApiDiagnosticBackendResponseDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers ApiManagementApiDiagnostic#headers}
    */
    readonly headers?: ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#query_params ApiManagementApiDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementApiDiagnosticBackendResponseDataMaskingToTerraform(struct?: ApiManagementApiDiagnosticBackendResponseDataMaskingOutputReference | ApiManagementApiDiagnosticBackendResponseDataMasking): any;
export declare class ApiManagementApiDiagnosticBackendResponseDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiDiagnosticBackendResponseDataMasking | undefined;
    set internalValue(value: ApiManagementApiDiagnosticBackendResponseDataMasking | undefined);
    private _headers?;
    get headers(): ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    set headers(value: ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders[] | cdktf.IResolvable);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders[] | undefined;
    private _queryParams?;
    get queryParams(): ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
    set queryParams(value: ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams[] | cdktf.IResolvable);
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementApiDiagnosticBackendResponse {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#body_bytes ApiManagementApiDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers_to_log ApiManagementApiDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#data_masking ApiManagementApiDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementApiDiagnosticBackendResponseDataMasking;
}
export declare function apiManagementApiDiagnosticBackendResponseToTerraform(struct?: ApiManagementApiDiagnosticBackendResponseOutputReference | ApiManagementApiDiagnosticBackendResponse): any;
export declare class ApiManagementApiDiagnosticBackendResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiDiagnosticBackendResponse | undefined;
    set internalValue(value: ApiManagementApiDiagnosticBackendResponse | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementApiDiagnosticBackendResponseDataMaskingOutputReference;
    putDataMasking(value: ApiManagementApiDiagnosticBackendResponseDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementApiDiagnosticBackendResponseDataMasking | undefined;
}
export interface ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticFrontendRequestDataMaskingHeadersToTerraform(struct?: ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders | cdktf.IResolvable): any;
export interface ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticFrontendRequestDataMaskingQueryParamsToTerraform(struct?: ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams | cdktf.IResolvable): any;
export interface ApiManagementApiDiagnosticFrontendRequestDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers ApiManagementApiDiagnostic#headers}
    */
    readonly headers?: ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#query_params ApiManagementApiDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementApiDiagnosticFrontendRequestDataMaskingToTerraform(struct?: ApiManagementApiDiagnosticFrontendRequestDataMaskingOutputReference | ApiManagementApiDiagnosticFrontendRequestDataMasking): any;
export declare class ApiManagementApiDiagnosticFrontendRequestDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiDiagnosticFrontendRequestDataMasking | undefined;
    set internalValue(value: ApiManagementApiDiagnosticFrontendRequestDataMasking | undefined);
    private _headers?;
    get headers(): ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    set headers(value: ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders[] | cdktf.IResolvable);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders[] | undefined;
    private _queryParams?;
    get queryParams(): ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
    set queryParams(value: ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams[] | cdktf.IResolvable);
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementApiDiagnosticFrontendRequest {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#body_bytes ApiManagementApiDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers_to_log ApiManagementApiDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#data_masking ApiManagementApiDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementApiDiagnosticFrontendRequestDataMasking;
}
export declare function apiManagementApiDiagnosticFrontendRequestToTerraform(struct?: ApiManagementApiDiagnosticFrontendRequestOutputReference | ApiManagementApiDiagnosticFrontendRequest): any;
export declare class ApiManagementApiDiagnosticFrontendRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiDiagnosticFrontendRequest | undefined;
    set internalValue(value: ApiManagementApiDiagnosticFrontendRequest | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementApiDiagnosticFrontendRequestDataMaskingOutputReference;
    putDataMasking(value: ApiManagementApiDiagnosticFrontendRequestDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementApiDiagnosticFrontendRequestDataMasking | undefined;
}
export interface ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticFrontendResponseDataMaskingHeadersToTerraform(struct?: ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders | cdktf.IResolvable): any;
export interface ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticFrontendResponseDataMaskingQueryParamsToTerraform(struct?: ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams | cdktf.IResolvable): any;
export interface ApiManagementApiDiagnosticFrontendResponseDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers ApiManagementApiDiagnostic#headers}
    */
    readonly headers?: ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#query_params ApiManagementApiDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementApiDiagnosticFrontendResponseDataMaskingToTerraform(struct?: ApiManagementApiDiagnosticFrontendResponseDataMaskingOutputReference | ApiManagementApiDiagnosticFrontendResponseDataMasking): any;
export declare class ApiManagementApiDiagnosticFrontendResponseDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiDiagnosticFrontendResponseDataMasking | undefined;
    set internalValue(value: ApiManagementApiDiagnosticFrontendResponseDataMasking | undefined);
    private _headers?;
    get headers(): ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    set headers(value: ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders[] | cdktf.IResolvable);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders[] | undefined;
    private _queryParams?;
    get queryParams(): ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
    set queryParams(value: ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams[] | cdktf.IResolvable);
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementApiDiagnosticFrontendResponse {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#body_bytes ApiManagementApiDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers_to_log ApiManagementApiDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#data_masking ApiManagementApiDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementApiDiagnosticFrontendResponseDataMasking;
}
export declare function apiManagementApiDiagnosticFrontendResponseToTerraform(struct?: ApiManagementApiDiagnosticFrontendResponseOutputReference | ApiManagementApiDiagnosticFrontendResponse): any;
export declare class ApiManagementApiDiagnosticFrontendResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiDiagnosticFrontendResponse | undefined;
    set internalValue(value: ApiManagementApiDiagnosticFrontendResponse | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementApiDiagnosticFrontendResponseDataMaskingOutputReference;
    putDataMasking(value: ApiManagementApiDiagnosticFrontendResponseDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementApiDiagnosticFrontendResponseDataMasking | undefined;
}
export interface ApiManagementApiDiagnosticTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#create ApiManagementApiDiagnostic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#delete ApiManagementApiDiagnostic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#read ApiManagementApiDiagnostic#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#update ApiManagementApiDiagnostic#update}
    */
    readonly update?: string;
}
export declare function apiManagementApiDiagnosticTimeoutsToTerraform(struct?: ApiManagementApiDiagnosticTimeoutsOutputReference | ApiManagementApiDiagnosticTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementApiDiagnosticTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiDiagnosticTimeouts | undefined;
    set internalValue(value: ApiManagementApiDiagnosticTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic azurerm_api_management_api_diagnostic}
*/
export declare class ApiManagementApiDiagnostic extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_api_diagnostic";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic azurerm_api_management_api_diagnostic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementApiDiagnosticConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementApiDiagnosticConfig);
    private _alwaysLogErrors?;
    get alwaysLogErrors(): boolean | cdktf.IResolvable;
    set alwaysLogErrors(value: boolean | cdktf.IResolvable);
    resetAlwaysLogErrors(): void;
    get alwaysLogErrorsInput(): boolean | cdktf.IResolvable | undefined;
    private _apiManagementLoggerId?;
    get apiManagementLoggerId(): string;
    set apiManagementLoggerId(value: string);
    get apiManagementLoggerIdInput(): string | undefined;
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _apiName?;
    get apiName(): string;
    set apiName(value: string);
    get apiNameInput(): string | undefined;
    private _httpCorrelationProtocol?;
    get httpCorrelationProtocol(): string;
    set httpCorrelationProtocol(value: string);
    resetHttpCorrelationProtocol(): void;
    get httpCorrelationProtocolInput(): string | undefined;
    get id(): string;
    private _identifier?;
    get identifier(): string;
    set identifier(value: string);
    get identifierInput(): string | undefined;
    private _logClientIp?;
    get logClientIp(): boolean | cdktf.IResolvable;
    set logClientIp(value: boolean | cdktf.IResolvable);
    resetLogClientIp(): void;
    get logClientIpInput(): boolean | cdktf.IResolvable | undefined;
    private _operationNameFormat?;
    get operationNameFormat(): string;
    set operationNameFormat(value: string);
    resetOperationNameFormat(): void;
    get operationNameFormatInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _samplingPercentage?;
    get samplingPercentage(): number;
    set samplingPercentage(value: number);
    resetSamplingPercentage(): void;
    get samplingPercentageInput(): number | undefined;
    private _verbosity?;
    get verbosity(): string;
    set verbosity(value: string);
    resetVerbosity(): void;
    get verbosityInput(): string | undefined;
    private _backendRequest;
    get backendRequest(): ApiManagementApiDiagnosticBackendRequestOutputReference;
    putBackendRequest(value: ApiManagementApiDiagnosticBackendRequest): void;
    resetBackendRequest(): void;
    get backendRequestInput(): ApiManagementApiDiagnosticBackendRequest | undefined;
    private _backendResponse;
    get backendResponse(): ApiManagementApiDiagnosticBackendResponseOutputReference;
    putBackendResponse(value: ApiManagementApiDiagnosticBackendResponse): void;
    resetBackendResponse(): void;
    get backendResponseInput(): ApiManagementApiDiagnosticBackendResponse | undefined;
    private _frontendRequest;
    get frontendRequest(): ApiManagementApiDiagnosticFrontendRequestOutputReference;
    putFrontendRequest(value: ApiManagementApiDiagnosticFrontendRequest): void;
    resetFrontendRequest(): void;
    get frontendRequestInput(): ApiManagementApiDiagnosticFrontendRequest | undefined;
    private _frontendResponse;
    get frontendResponse(): ApiManagementApiDiagnosticFrontendResponseOutputReference;
    putFrontendResponse(value: ApiManagementApiDiagnosticFrontendResponse): void;
    resetFrontendResponse(): void;
    get frontendResponseInput(): ApiManagementApiDiagnosticFrontendResponse | undefined;
    private _timeouts;
    get timeouts(): ApiManagementApiDiagnosticTimeoutsOutputReference;
    putTimeouts(value: ApiManagementApiDiagnosticTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementApiDiagnosticTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
