import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementDiagnosticConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#always_log_errors ApiManagementDiagnostic#always_log_errors}
    */
    readonly alwaysLogErrors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#api_management_logger_id ApiManagementDiagnostic#api_management_logger_id}
    */
    readonly apiManagementLoggerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#api_management_name ApiManagementDiagnostic#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#enabled ApiManagementDiagnostic#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#http_correlation_protocol ApiManagementDiagnostic#http_correlation_protocol}
    */
    readonly httpCorrelationProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#identifier ApiManagementDiagnostic#identifier}
    */
    readonly identifier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#log_client_ip ApiManagementDiagnostic#log_client_ip}
    */
    readonly logClientIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#operation_name_format ApiManagementDiagnostic#operation_name_format}
    */
    readonly operationNameFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#resource_group_name ApiManagementDiagnostic#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#sampling_percentage ApiManagementDiagnostic#sampling_percentage}
    */
    readonly samplingPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#verbosity ApiManagementDiagnostic#verbosity}
    */
    readonly verbosity?: string;
    /**
    * backend_request block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#backend_request ApiManagementDiagnostic#backend_request}
    */
    readonly backendRequest?: ApiManagementDiagnosticBackendRequest;
    /**
    * backend_response block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#backend_response ApiManagementDiagnostic#backend_response}
    */
    readonly backendResponse?: ApiManagementDiagnosticBackendResponse;
    /**
    * frontend_request block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#frontend_request ApiManagementDiagnostic#frontend_request}
    */
    readonly frontendRequest?: ApiManagementDiagnosticFrontendRequest;
    /**
    * frontend_response block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#frontend_response ApiManagementDiagnostic#frontend_response}
    */
    readonly frontendResponse?: ApiManagementDiagnosticFrontendResponse;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#timeouts ApiManagementDiagnostic#timeouts}
    */
    readonly timeouts?: ApiManagementDiagnosticTimeouts;
}
export interface ApiManagementDiagnosticBackendRequestDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendRequestDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingHeaders | cdktf.IResolvable): any;
export interface ApiManagementDiagnosticBackendRequestDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendRequestDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams | cdktf.IResolvable): any;
export interface ApiManagementDiagnosticBackendRequestDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#headers ApiManagementDiagnostic#headers}
    */
    readonly headers?: ApiManagementDiagnosticBackendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#query_params ApiManagementDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementDiagnosticBackendRequestDataMaskingToTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingOutputReference | ApiManagementDiagnosticBackendRequestDataMasking): any;
export declare class ApiManagementDiagnosticBackendRequestDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticBackendRequestDataMasking | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendRequestDataMasking | undefined);
    private _headers?;
    get headers(): ApiManagementDiagnosticBackendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    set headers(value: ApiManagementDiagnosticBackendRequestDataMaskingHeaders[] | cdktf.IResolvable);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementDiagnosticBackendRequestDataMaskingHeaders[] | undefined;
    private _queryParams?;
    get queryParams(): ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
    set queryParams(value: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[] | cdktf.IResolvable);
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementDiagnosticBackendRequest {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#body_bytes ApiManagementDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#headers_to_log ApiManagementDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#data_masking ApiManagementDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementDiagnosticBackendRequestDataMasking;
}
export declare function apiManagementDiagnosticBackendRequestToTerraform(struct?: ApiManagementDiagnosticBackendRequestOutputReference | ApiManagementDiagnosticBackendRequest): any;
export declare class ApiManagementDiagnosticBackendRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticBackendRequest | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendRequest | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementDiagnosticBackendRequestDataMaskingOutputReference;
    putDataMasking(value: ApiManagementDiagnosticBackendRequestDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementDiagnosticBackendRequestDataMasking | undefined;
}
export interface ApiManagementDiagnosticBackendResponseDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendResponseDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingHeaders | cdktf.IResolvable): any;
export interface ApiManagementDiagnosticBackendResponseDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendResponseDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams | cdktf.IResolvable): any;
export interface ApiManagementDiagnosticBackendResponseDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#headers ApiManagementDiagnostic#headers}
    */
    readonly headers?: ApiManagementDiagnosticBackendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#query_params ApiManagementDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementDiagnosticBackendResponseDataMaskingToTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingOutputReference | ApiManagementDiagnosticBackendResponseDataMasking): any;
export declare class ApiManagementDiagnosticBackendResponseDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticBackendResponseDataMasking | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendResponseDataMasking | undefined);
    private _headers?;
    get headers(): ApiManagementDiagnosticBackendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    set headers(value: ApiManagementDiagnosticBackendResponseDataMaskingHeaders[] | cdktf.IResolvable);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementDiagnosticBackendResponseDataMaskingHeaders[] | undefined;
    private _queryParams?;
    get queryParams(): ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
    set queryParams(value: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[] | cdktf.IResolvable);
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementDiagnosticBackendResponse {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#body_bytes ApiManagementDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#headers_to_log ApiManagementDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#data_masking ApiManagementDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementDiagnosticBackendResponseDataMasking;
}
export declare function apiManagementDiagnosticBackendResponseToTerraform(struct?: ApiManagementDiagnosticBackendResponseOutputReference | ApiManagementDiagnosticBackendResponse): any;
export declare class ApiManagementDiagnosticBackendResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticBackendResponse | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendResponse | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementDiagnosticBackendResponseDataMaskingOutputReference;
    putDataMasking(value: ApiManagementDiagnosticBackendResponseDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementDiagnosticBackendResponseDataMasking | undefined;
}
export interface ApiManagementDiagnosticFrontendRequestDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendRequestDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders | cdktf.IResolvable): any;
export interface ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendRequestDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams | cdktf.IResolvable): any;
export interface ApiManagementDiagnosticFrontendRequestDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#headers ApiManagementDiagnostic#headers}
    */
    readonly headers?: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#query_params ApiManagementDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementDiagnosticFrontendRequestDataMaskingToTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingOutputReference | ApiManagementDiagnosticFrontendRequestDataMasking): any;
export declare class ApiManagementDiagnosticFrontendRequestDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticFrontendRequestDataMasking | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendRequestDataMasking | undefined);
    private _headers?;
    get headers(): ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    set headers(value: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[] | cdktf.IResolvable);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[] | undefined;
    private _queryParams?;
    get queryParams(): ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
    set queryParams(value: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[] | cdktf.IResolvable);
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementDiagnosticFrontendRequest {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#body_bytes ApiManagementDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#headers_to_log ApiManagementDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#data_masking ApiManagementDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementDiagnosticFrontendRequestDataMasking;
}
export declare function apiManagementDiagnosticFrontendRequestToTerraform(struct?: ApiManagementDiagnosticFrontendRequestOutputReference | ApiManagementDiagnosticFrontendRequest): any;
export declare class ApiManagementDiagnosticFrontendRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticFrontendRequest | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendRequest | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementDiagnosticFrontendRequestDataMaskingOutputReference;
    putDataMasking(value: ApiManagementDiagnosticFrontendRequestDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementDiagnosticFrontendRequestDataMasking | undefined;
}
export interface ApiManagementDiagnosticFrontendResponseDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendResponseDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders | cdktf.IResolvable): any;
export interface ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendResponseDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams | cdktf.IResolvable): any;
export interface ApiManagementDiagnosticFrontendResponseDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#headers ApiManagementDiagnostic#headers}
    */
    readonly headers?: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#query_params ApiManagementDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementDiagnosticFrontendResponseDataMaskingToTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingOutputReference | ApiManagementDiagnosticFrontendResponseDataMasking): any;
export declare class ApiManagementDiagnosticFrontendResponseDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticFrontendResponseDataMasking | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendResponseDataMasking | undefined);
    private _headers?;
    get headers(): ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    set headers(value: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[] | cdktf.IResolvable);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[] | undefined;
    private _queryParams?;
    get queryParams(): ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
    set queryParams(value: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[] | cdktf.IResolvable);
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementDiagnosticFrontendResponse {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#body_bytes ApiManagementDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#headers_to_log ApiManagementDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#data_masking ApiManagementDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementDiagnosticFrontendResponseDataMasking;
}
export declare function apiManagementDiagnosticFrontendResponseToTerraform(struct?: ApiManagementDiagnosticFrontendResponseOutputReference | ApiManagementDiagnosticFrontendResponse): any;
export declare class ApiManagementDiagnosticFrontendResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticFrontendResponse | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendResponse | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementDiagnosticFrontendResponseDataMaskingOutputReference;
    putDataMasking(value: ApiManagementDiagnosticFrontendResponseDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementDiagnosticFrontendResponseDataMasking | undefined;
}
export interface ApiManagementDiagnosticTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#create ApiManagementDiagnostic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#delete ApiManagementDiagnostic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#read ApiManagementDiagnostic#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic#update ApiManagementDiagnostic#update}
    */
    readonly update?: string;
}
export declare function apiManagementDiagnosticTimeoutsToTerraform(struct?: ApiManagementDiagnosticTimeoutsOutputReference | ApiManagementDiagnosticTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementDiagnosticTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticTimeouts | undefined;
    set internalValue(value: ApiManagementDiagnosticTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic azurerm_api_management_diagnostic}
*/
export declare class ApiManagementDiagnostic extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_diagnostic";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_diagnostic azurerm_api_management_diagnostic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementDiagnosticConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementDiagnosticConfig);
    private _alwaysLogErrors?;
    get alwaysLogErrors(): boolean | cdktf.IResolvable;
    set alwaysLogErrors(value: boolean | cdktf.IResolvable);
    resetAlwaysLogErrors(): void;
    get alwaysLogErrorsInput(): boolean | cdktf.IResolvable | undefined;
    private _apiManagementLoggerId?;
    get apiManagementLoggerId(): string;
    set apiManagementLoggerId(value: string);
    get apiManagementLoggerIdInput(): string | undefined;
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpCorrelationProtocol?;
    get httpCorrelationProtocol(): string;
    set httpCorrelationProtocol(value: string);
    resetHttpCorrelationProtocol(): void;
    get httpCorrelationProtocolInput(): string | undefined;
    get id(): string;
    private _identifier?;
    get identifier(): string;
    set identifier(value: string);
    get identifierInput(): string | undefined;
    private _logClientIp?;
    get logClientIp(): boolean | cdktf.IResolvable;
    set logClientIp(value: boolean | cdktf.IResolvable);
    resetLogClientIp(): void;
    get logClientIpInput(): boolean | cdktf.IResolvable | undefined;
    private _operationNameFormat?;
    get operationNameFormat(): string;
    set operationNameFormat(value: string);
    resetOperationNameFormat(): void;
    get operationNameFormatInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _samplingPercentage?;
    get samplingPercentage(): number;
    set samplingPercentage(value: number);
    resetSamplingPercentage(): void;
    get samplingPercentageInput(): number | undefined;
    private _verbosity?;
    get verbosity(): string;
    set verbosity(value: string);
    resetVerbosity(): void;
    get verbosityInput(): string | undefined;
    private _backendRequest;
    get backendRequest(): ApiManagementDiagnosticBackendRequestOutputReference;
    putBackendRequest(value: ApiManagementDiagnosticBackendRequest): void;
    resetBackendRequest(): void;
    get backendRequestInput(): ApiManagementDiagnosticBackendRequest | undefined;
    private _backendResponse;
    get backendResponse(): ApiManagementDiagnosticBackendResponseOutputReference;
    putBackendResponse(value: ApiManagementDiagnosticBackendResponse): void;
    resetBackendResponse(): void;
    get backendResponseInput(): ApiManagementDiagnosticBackendResponse | undefined;
    private _frontendRequest;
    get frontendRequest(): ApiManagementDiagnosticFrontendRequestOutputReference;
    putFrontendRequest(value: ApiManagementDiagnosticFrontendRequest): void;
    resetFrontendRequest(): void;
    get frontendRequestInput(): ApiManagementDiagnosticFrontendRequest | undefined;
    private _frontendResponse;
    get frontendResponse(): ApiManagementDiagnosticFrontendResponseOutputReference;
    putFrontendResponse(value: ApiManagementDiagnosticFrontendResponse): void;
    resetFrontendResponse(): void;
    get frontendResponseInput(): ApiManagementDiagnosticFrontendResponse | undefined;
    private _timeouts;
    get timeouts(): ApiManagementDiagnosticTimeoutsOutputReference;
    putTimeouts(value: ApiManagementDiagnosticTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementDiagnosticTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
