import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServicePublicCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#app_service_name AppServicePublicCertificate#app_service_name}
    */
    readonly appServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#blob AppServicePublicCertificate#blob}
    */
    readonly blob: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#certificate_location AppServicePublicCertificate#certificate_location}
    */
    readonly certificateLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#certificate_name AppServicePublicCertificate#certificate_name}
    */
    readonly certificateName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#resource_group_name AppServicePublicCertificate#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#timeouts AppServicePublicCertificate#timeouts}
    */
    readonly timeouts?: AppServicePublicCertificateTimeouts;
}
export interface AppServicePublicCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#create AppServicePublicCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#delete AppServicePublicCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#read AppServicePublicCertificate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#update AppServicePublicCertificate#update}
    */
    readonly update?: string;
}
export declare function appServicePublicCertificateTimeoutsToTerraform(struct?: AppServicePublicCertificateTimeoutsOutputReference | AppServicePublicCertificateTimeouts | cdktf.IResolvable): any;
export declare class AppServicePublicCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServicePublicCertificateTimeouts | undefined;
    set internalValue(value: AppServicePublicCertificateTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate azurerm_app_service_public_certificate}
*/
export declare class AppServicePublicCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_public_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate azurerm_app_service_public_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServicePublicCertificateConfig
    */
    constructor(scope: Construct, id: string, config: AppServicePublicCertificateConfig);
    private _appServiceName?;
    get appServiceName(): string;
    set appServiceName(value: string);
    get appServiceNameInput(): string | undefined;
    private _blob?;
    get blob(): string;
    set blob(value: string);
    get blobInput(): string | undefined;
    private _certificateLocation?;
    get certificateLocation(): string;
    set certificateLocation(value: string);
    get certificateLocationInput(): string | undefined;
    private _certificateName?;
    get certificateName(): string;
    set certificateName(value: string);
    get certificateNameInput(): string | undefined;
    get id(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get thumbprint(): string;
    private _timeouts;
    get timeouts(): AppServicePublicCertificateTimeoutsOutputReference;
    putTimeouts(value: AppServicePublicCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppServicePublicCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
