import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceSlotCustomHostnameBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#app_service_slot_id AppServiceSlotCustomHostnameBinding#app_service_slot_id}
    */
    readonly appServiceSlotId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#hostname AppServiceSlotCustomHostnameBinding#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#ssl_state AppServiceSlotCustomHostnameBinding#ssl_state}
    */
    readonly sslState?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#thumbprint AppServiceSlotCustomHostnameBinding#thumbprint}
    */
    readonly thumbprint?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#timeouts AppServiceSlotCustomHostnameBinding#timeouts}
    */
    readonly timeouts?: AppServiceSlotCustomHostnameBindingTimeouts;
}
export interface AppServiceSlotCustomHostnameBindingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#create AppServiceSlotCustomHostnameBinding#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#delete AppServiceSlotCustomHostnameBinding#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding#read AppServiceSlotCustomHostnameBinding#read}
    */
    readonly read?: string;
}
export declare function appServiceSlotCustomHostnameBindingTimeoutsToTerraform(struct?: AppServiceSlotCustomHostnameBindingTimeoutsOutputReference | AppServiceSlotCustomHostnameBindingTimeouts | cdktf.IResolvable): any;
export declare class AppServiceSlotCustomHostnameBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSlotCustomHostnameBindingTimeouts | undefined;
    set internalValue(value: AppServiceSlotCustomHostnameBindingTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding azurerm_app_service_slot_custom_hostname_binding}
*/
export declare class AppServiceSlotCustomHostnameBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_slot_custom_hostname_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot_custom_hostname_binding azurerm_app_service_slot_custom_hostname_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceSlotCustomHostnameBindingConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceSlotCustomHostnameBindingConfig);
    private _appServiceSlotId?;
    get appServiceSlotId(): string;
    set appServiceSlotId(value: string);
    get appServiceSlotIdInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    get id(): string;
    private _sslState?;
    get sslState(): string;
    set sslState(value: string);
    resetSslState(): void;
    get sslStateInput(): string | undefined;
    private _thumbprint?;
    get thumbprint(): string;
    set thumbprint(value: string);
    resetThumbprint(): void;
    get thumbprintInput(): string | undefined;
    get virtualIp(): string;
    private _timeouts;
    get timeouts(): AppServiceSlotCustomHostnameBindingTimeoutsOutputReference;
    putTimeouts(value: AppServiceSlotCustomHostnameBindingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppServiceSlotCustomHostnameBindingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
