import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceSourceControlTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token#token AppServiceSourceControlToken#token}
    */
    readonly token: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token#token_secret AppServiceSourceControlToken#token_secret}
    */
    readonly tokenSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token#type AppServiceSourceControlToken#type}
    */
    readonly type: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token#timeouts AppServiceSourceControlToken#timeouts}
    */
    readonly timeouts?: AppServiceSourceControlTokenTimeouts;
}
export interface AppServiceSourceControlTokenTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token#create AppServiceSourceControlToken#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token#delete AppServiceSourceControlToken#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token#read AppServiceSourceControlToken#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token#update AppServiceSourceControlToken#update}
    */
    readonly update?: string;
}
export declare function appServiceSourceControlTokenTimeoutsToTerraform(struct?: AppServiceSourceControlTokenTimeoutsOutputReference | AppServiceSourceControlTokenTimeouts | cdktf.IResolvable): any;
export declare class AppServiceSourceControlTokenTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSourceControlTokenTimeouts | undefined;
    set internalValue(value: AppServiceSourceControlTokenTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token azurerm_app_service_source_control_token}
*/
export declare class AppServiceSourceControlToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_source_control_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_source_control_token azurerm_app_service_source_control_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceSourceControlTokenConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceSourceControlTokenConfig);
    get id(): string;
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
    private _tokenSecret?;
    get tokenSecret(): string;
    set tokenSecret(value: string);
    resetTokenSecret(): void;
    get tokenSecretInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): AppServiceSourceControlTokenTimeoutsOutputReference;
    putTimeouts(value: AppServiceSourceControlTokenTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppServiceSourceControlTokenTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
