import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#enable_http2 ApplicationGateway#enable_http2}
    */
    readonly enableHttp2?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#fips_enabled ApplicationGateway#fips_enabled}
    */
    readonly fipsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#firewall_policy_id ApplicationGateway#firewall_policy_id}
    */
    readonly firewallPolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#force_firewall_policy_association ApplicationGateway#force_firewall_policy_association}
    */
    readonly forceFirewallPolicyAssociation?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#location ApplicationGateway#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#resource_group_name ApplicationGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#tags ApplicationGateway#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#zones ApplicationGateway#zones}
    */
    readonly zones?: string[];
    /**
    * authentication_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#authentication_certificate ApplicationGateway#authentication_certificate}
    */
    readonly authenticationCertificate?: ApplicationGatewayAuthenticationCertificate[] | cdktf.IResolvable;
    /**
    * autoscale_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#autoscale_configuration ApplicationGateway#autoscale_configuration}
    */
    readonly autoscaleConfiguration?: ApplicationGatewayAutoscaleConfiguration;
    /**
    * backend_address_pool block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_address_pool ApplicationGateway#backend_address_pool}
    */
    readonly backendAddressPool: ApplicationGatewayBackendAddressPool[] | cdktf.IResolvable;
    /**
    * backend_http_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_http_settings ApplicationGateway#backend_http_settings}
    */
    readonly backendHttpSettings: ApplicationGatewayBackendHttpSettings[] | cdktf.IResolvable;
    /**
    * custom_error_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#custom_error_configuration ApplicationGateway#custom_error_configuration}
    */
    readonly customErrorConfiguration?: ApplicationGatewayCustomErrorConfiguration[] | cdktf.IResolvable;
    /**
    * frontend_ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#frontend_ip_configuration ApplicationGateway#frontend_ip_configuration}
    */
    readonly frontendIpConfiguration: ApplicationGatewayFrontendIpConfiguration[] | cdktf.IResolvable;
    /**
    * frontend_port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#frontend_port ApplicationGateway#frontend_port}
    */
    readonly frontendPort: ApplicationGatewayFrontendPort[] | cdktf.IResolvable;
    /**
    * gateway_ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#gateway_ip_configuration ApplicationGateway#gateway_ip_configuration}
    */
    readonly gatewayIpConfiguration: ApplicationGatewayGatewayIpConfiguration[] | cdktf.IResolvable;
    /**
    * http_listener block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#http_listener ApplicationGateway#http_listener}
    */
    readonly httpListener: ApplicationGatewayHttpListener[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#identity ApplicationGateway#identity}
    */
    readonly identity?: ApplicationGatewayIdentity;
    /**
    * private_link_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_link_configuration ApplicationGateway#private_link_configuration}
    */
    readonly privateLinkConfiguration?: ApplicationGatewayPrivateLinkConfiguration[] | cdktf.IResolvable;
    /**
    * probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#probe ApplicationGateway#probe}
    */
    readonly probe?: ApplicationGatewayProbe[] | cdktf.IResolvable;
    /**
    * redirect_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#redirect_configuration ApplicationGateway#redirect_configuration}
    */
    readonly redirectConfiguration?: ApplicationGatewayRedirectConfiguration[] | cdktf.IResolvable;
    /**
    * request_routing_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#request_routing_rule ApplicationGateway#request_routing_rule}
    */
    readonly requestRoutingRule: ApplicationGatewayRequestRoutingRule[] | cdktf.IResolvable;
    /**
    * rewrite_rule_set block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rewrite_rule_set ApplicationGateway#rewrite_rule_set}
    */
    readonly rewriteRuleSet?: ApplicationGatewayRewriteRuleSet[] | cdktf.IResolvable;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#sku ApplicationGateway#sku}
    */
    readonly sku: ApplicationGatewaySku;
    /**
    * ssl_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_certificate ApplicationGateway#ssl_certificate}
    */
    readonly sslCertificate?: ApplicationGatewaySslCertificate[] | cdktf.IResolvable;
    /**
    * ssl_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_policy ApplicationGateway#ssl_policy}
    */
    readonly sslPolicy?: ApplicationGatewaySslPolicy;
    /**
    * ssl_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_profile ApplicationGateway#ssl_profile}
    */
    readonly sslProfile?: ApplicationGatewaySslProfile[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#timeouts ApplicationGateway#timeouts}
    */
    readonly timeouts?: ApplicationGatewayTimeouts;
    /**
    * trusted_client_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#trusted_client_certificate ApplicationGateway#trusted_client_certificate}
    */
    readonly trustedClientCertificate?: ApplicationGatewayTrustedClientCertificate[] | cdktf.IResolvable;
    /**
    * trusted_root_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#trusted_root_certificate ApplicationGateway#trusted_root_certificate}
    */
    readonly trustedRootCertificate?: ApplicationGatewayTrustedRootCertificate[] | cdktf.IResolvable;
    /**
    * url_path_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#url_path_map ApplicationGateway#url_path_map}
    */
    readonly urlPathMap?: ApplicationGatewayUrlPathMap[] | cdktf.IResolvable;
    /**
    * waf_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#waf_configuration ApplicationGateway#waf_configuration}
    */
    readonly wafConfiguration?: ApplicationGatewayWafConfiguration;
}
export interface ApplicationGatewayPrivateEndpointConnection {
}
export declare function applicationGatewayPrivateEndpointConnectionToTerraform(struct?: ApplicationGatewayPrivateEndpointConnection): any;
export declare class ApplicationGatewayPrivateEndpointConnectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationGatewayPrivateEndpointConnection | undefined;
    set internalValue(value: ApplicationGatewayPrivateEndpointConnection | undefined);
    get id(): string;
    get name(): string;
}
export declare class ApplicationGatewayPrivateEndpointConnectionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationGatewayPrivateEndpointConnectionOutputReference;
}
export interface ApplicationGatewayAuthenticationCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#data ApplicationGateway#data}
    */
    readonly data: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
}
export declare function applicationGatewayAuthenticationCertificateToTerraform(struct?: ApplicationGatewayAuthenticationCertificate | cdktf.IResolvable): any;
export interface ApplicationGatewayAutoscaleConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#max_capacity ApplicationGateway#max_capacity}
    */
    readonly maxCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#min_capacity ApplicationGateway#min_capacity}
    */
    readonly minCapacity: number;
}
export declare function applicationGatewayAutoscaleConfigurationToTerraform(struct?: ApplicationGatewayAutoscaleConfigurationOutputReference | ApplicationGatewayAutoscaleConfiguration): any;
export declare class ApplicationGatewayAutoscaleConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayAutoscaleConfiguration | undefined;
    set internalValue(value: ApplicationGatewayAutoscaleConfiguration | undefined);
    private _maxCapacity?;
    get maxCapacity(): number;
    set maxCapacity(value: number);
    resetMaxCapacity(): void;
    get maxCapacityInput(): number | undefined;
    private _minCapacity?;
    get minCapacity(): number;
    set minCapacity(value: number);
    get minCapacityInput(): number | undefined;
}
export interface ApplicationGatewayBackendAddressPool {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#fqdns ApplicationGateway#fqdns}
    */
    readonly fqdns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ip_addresses ApplicationGateway#ip_addresses}
    */
    readonly ipAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
}
export declare function applicationGatewayBackendAddressPoolToTerraform(struct?: ApplicationGatewayBackendAddressPool | cdktf.IResolvable): any;
export interface ApplicationGatewayBackendHttpSettingsAuthenticationCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
}
export declare function applicationGatewayBackendHttpSettingsAuthenticationCertificateToTerraform(struct?: ApplicationGatewayBackendHttpSettingsAuthenticationCertificate | cdktf.IResolvable): any;
export interface ApplicationGatewayBackendHttpSettingsConnectionDraining {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#drain_timeout_sec ApplicationGateway#drain_timeout_sec}
    */
    readonly drainTimeoutSec: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#enabled ApplicationGateway#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function applicationGatewayBackendHttpSettingsConnectionDrainingToTerraform(struct?: ApplicationGatewayBackendHttpSettingsConnectionDrainingOutputReference | ApplicationGatewayBackendHttpSettingsConnectionDraining): any;
export declare class ApplicationGatewayBackendHttpSettingsConnectionDrainingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayBackendHttpSettingsConnectionDraining | undefined;
    set internalValue(value: ApplicationGatewayBackendHttpSettingsConnectionDraining | undefined);
    private _drainTimeoutSec?;
    get drainTimeoutSec(): number;
    set drainTimeoutSec(value: number);
    get drainTimeoutSecInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApplicationGatewayBackendHttpSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#affinity_cookie_name ApplicationGateway#affinity_cookie_name}
    */
    readonly affinityCookieName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#cookie_based_affinity ApplicationGateway#cookie_based_affinity}
    */
    readonly cookieBasedAffinity: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#host_name ApplicationGateway#host_name}
    */
    readonly hostName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#path ApplicationGateway#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#pick_host_name_from_backend_address ApplicationGateway#pick_host_name_from_backend_address}
    */
    readonly pickHostNameFromBackendAddress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#port ApplicationGateway#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#probe_name ApplicationGateway#probe_name}
    */
    readonly probeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#protocol ApplicationGateway#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#request_timeout ApplicationGateway#request_timeout}
    */
    readonly requestTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#trusted_root_certificate_names ApplicationGateway#trusted_root_certificate_names}
    */
    readonly trustedRootCertificateNames?: string[];
    /**
    * authentication_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#authentication_certificate ApplicationGateway#authentication_certificate}
    */
    readonly authenticationCertificate?: ApplicationGatewayBackendHttpSettingsAuthenticationCertificate[] | cdktf.IResolvable;
    /**
    * connection_draining block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#connection_draining ApplicationGateway#connection_draining}
    */
    readonly connectionDraining?: ApplicationGatewayBackendHttpSettingsConnectionDraining;
}
export declare function applicationGatewayBackendHttpSettingsToTerraform(struct?: ApplicationGatewayBackendHttpSettings | cdktf.IResolvable): any;
export interface ApplicationGatewayCustomErrorConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#custom_error_page_url ApplicationGateway#custom_error_page_url}
    */
    readonly customErrorPageUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#status_code ApplicationGateway#status_code}
    */
    readonly statusCode: string;
}
export declare function applicationGatewayCustomErrorConfigurationToTerraform(struct?: ApplicationGatewayCustomErrorConfiguration | cdktf.IResolvable): any;
export interface ApplicationGatewayFrontendIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_ip_address ApplicationGateway#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_ip_address_allocation ApplicationGateway#private_ip_address_allocation}
    */
    readonly privateIpAddressAllocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_link_configuration_name ApplicationGateway#private_link_configuration_name}
    */
    readonly privateLinkConfigurationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#public_ip_address_id ApplicationGateway#public_ip_address_id}
    */
    readonly publicIpAddressId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#subnet_id ApplicationGateway#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function applicationGatewayFrontendIpConfigurationToTerraform(struct?: ApplicationGatewayFrontendIpConfiguration | cdktf.IResolvable): any;
export interface ApplicationGatewayFrontendPort {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#port ApplicationGateway#port}
    */
    readonly port: number;
}
export declare function applicationGatewayFrontendPortToTerraform(struct?: ApplicationGatewayFrontendPort | cdktf.IResolvable): any;
export interface ApplicationGatewayGatewayIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#subnet_id ApplicationGateway#subnet_id}
    */
    readonly subnetId: string;
}
export declare function applicationGatewayGatewayIpConfigurationToTerraform(struct?: ApplicationGatewayGatewayIpConfiguration | cdktf.IResolvable): any;
export interface ApplicationGatewayHttpListenerCustomErrorConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#custom_error_page_url ApplicationGateway#custom_error_page_url}
    */
    readonly customErrorPageUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#status_code ApplicationGateway#status_code}
    */
    readonly statusCode: string;
}
export declare function applicationGatewayHttpListenerCustomErrorConfigurationToTerraform(struct?: ApplicationGatewayHttpListenerCustomErrorConfiguration | cdktf.IResolvable): any;
export interface ApplicationGatewayHttpListener {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#firewall_policy_id ApplicationGateway#firewall_policy_id}
    */
    readonly firewallPolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#frontend_ip_configuration_name ApplicationGateway#frontend_ip_configuration_name}
    */
    readonly frontendIpConfigurationName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#frontend_port_name ApplicationGateway#frontend_port_name}
    */
    readonly frontendPortName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#host_name ApplicationGateway#host_name}
    */
    readonly hostName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#host_names ApplicationGateway#host_names}
    */
    readonly hostNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#protocol ApplicationGateway#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#require_sni ApplicationGateway#require_sni}
    */
    readonly requireSni?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_certificate_name ApplicationGateway#ssl_certificate_name}
    */
    readonly sslCertificateName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_profile_name ApplicationGateway#ssl_profile_name}
    */
    readonly sslProfileName?: string;
    /**
    * custom_error_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#custom_error_configuration ApplicationGateway#custom_error_configuration}
    */
    readonly customErrorConfiguration?: ApplicationGatewayHttpListenerCustomErrorConfiguration[] | cdktf.IResolvable;
}
export declare function applicationGatewayHttpListenerToTerraform(struct?: ApplicationGatewayHttpListener | cdktf.IResolvable): any;
export interface ApplicationGatewayIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#identity_ids ApplicationGateway#identity_ids}
    */
    readonly identityIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#type ApplicationGateway#type}
    */
    readonly type: string;
}
export declare function applicationGatewayIdentityToTerraform(struct?: ApplicationGatewayIdentityOutputReference | ApplicationGatewayIdentity): any;
export declare class ApplicationGatewayIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayIdentity | undefined;
    set internalValue(value: ApplicationGatewayIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    get identityIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ApplicationGatewayPrivateLinkConfigurationIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#primary ApplicationGateway#primary}
    */
    readonly primary: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_ip_address ApplicationGateway#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_ip_address_allocation ApplicationGateway#private_ip_address_allocation}
    */
    readonly privateIpAddressAllocation: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#subnet_id ApplicationGateway#subnet_id}
    */
    readonly subnetId: string;
}
export declare function applicationGatewayPrivateLinkConfigurationIpConfigurationToTerraform(struct?: ApplicationGatewayPrivateLinkConfigurationIpConfiguration | cdktf.IResolvable): any;
export interface ApplicationGatewayPrivateLinkConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ip_configuration ApplicationGateway#ip_configuration}
    */
    readonly ipConfiguration: ApplicationGatewayPrivateLinkConfigurationIpConfiguration[] | cdktf.IResolvable;
}
export declare function applicationGatewayPrivateLinkConfigurationToTerraform(struct?: ApplicationGatewayPrivateLinkConfiguration | cdktf.IResolvable): any;
export interface ApplicationGatewayProbeMatch {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#body ApplicationGateway#body}
    */
    readonly body?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#status_code ApplicationGateway#status_code}
    */
    readonly statusCode?: string[];
}
export declare function applicationGatewayProbeMatchToTerraform(struct?: ApplicationGatewayProbeMatchOutputReference | ApplicationGatewayProbeMatch): any;
export declare class ApplicationGatewayProbeMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayProbeMatch | undefined;
    set internalValue(value: ApplicationGatewayProbeMatch | undefined);
    private _body?;
    get body(): string;
    set body(value: string);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _statusCode?;
    get statusCode(): string[];
    set statusCode(value: string[]);
    resetStatusCode(): void;
    get statusCodeInput(): string[] | undefined;
}
export interface ApplicationGatewayProbe {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#host ApplicationGateway#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#interval ApplicationGateway#interval}
    */
    readonly interval: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#minimum_servers ApplicationGateway#minimum_servers}
    */
    readonly minimumServers?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#path ApplicationGateway#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#pick_host_name_from_backend_http_settings ApplicationGateway#pick_host_name_from_backend_http_settings}
    */
    readonly pickHostNameFromBackendHttpSettings?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#port ApplicationGateway#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#protocol ApplicationGateway#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#timeout ApplicationGateway#timeout}
    */
    readonly timeout: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#unhealthy_threshold ApplicationGateway#unhealthy_threshold}
    */
    readonly unhealthyThreshold: number;
    /**
    * match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#match ApplicationGateway#match}
    */
    readonly match?: ApplicationGatewayProbeMatch;
}
export declare function applicationGatewayProbeToTerraform(struct?: ApplicationGatewayProbe | cdktf.IResolvable): any;
export interface ApplicationGatewayRedirectConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#include_path ApplicationGateway#include_path}
    */
    readonly includePath?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#include_query_string ApplicationGateway#include_query_string}
    */
    readonly includeQueryString?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#redirect_type ApplicationGateway#redirect_type}
    */
    readonly redirectType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#target_listener_name ApplicationGateway#target_listener_name}
    */
    readonly targetListenerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#target_url ApplicationGateway#target_url}
    */
    readonly targetUrl?: string;
}
export declare function applicationGatewayRedirectConfigurationToTerraform(struct?: ApplicationGatewayRedirectConfiguration | cdktf.IResolvable): any;
export interface ApplicationGatewayRequestRoutingRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_address_pool_name ApplicationGateway#backend_address_pool_name}
    */
    readonly backendAddressPoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_http_settings_name ApplicationGateway#backend_http_settings_name}
    */
    readonly backendHttpSettingsName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#http_listener_name ApplicationGateway#http_listener_name}
    */
    readonly httpListenerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#priority ApplicationGateway#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#redirect_configuration_name ApplicationGateway#redirect_configuration_name}
    */
    readonly redirectConfigurationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rewrite_rule_set_name ApplicationGateway#rewrite_rule_set_name}
    */
    readonly rewriteRuleSetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rule_type ApplicationGateway#rule_type}
    */
    readonly ruleType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#url_path_map_name ApplicationGateway#url_path_map_name}
    */
    readonly urlPathMapName?: string;
}
export declare function applicationGatewayRequestRoutingRuleToTerraform(struct?: ApplicationGatewayRequestRoutingRule | cdktf.IResolvable): any;
export interface ApplicationGatewayRewriteRuleSetRewriteRuleCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ignore_case ApplicationGateway#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#negate ApplicationGateway#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#pattern ApplicationGateway#pattern}
    */
    readonly pattern: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#variable ApplicationGateway#variable}
    */
    readonly variable: string;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleConditionToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleCondition | cdktf.IResolvable): any;
export interface ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#header_name ApplicationGateway#header_name}
    */
    readonly headerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#header_value ApplicationGateway#header_value}
    */
    readonly headerValue: string;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration | cdktf.IResolvable): any;
export interface ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#header_name ApplicationGateway#header_name}
    */
    readonly headerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#header_value ApplicationGateway#header_value}
    */
    readonly headerValue: string;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration | cdktf.IResolvable): any;
export interface ApplicationGatewayRewriteRuleSetRewriteRuleUrl {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#path ApplicationGateway#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#query_string ApplicationGateway#query_string}
    */
    readonly queryString?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#reroute ApplicationGateway#reroute}
    */
    readonly reroute?: boolean | cdktf.IResolvable;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleUrlToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleUrlOutputReference | ApplicationGatewayRewriteRuleSetRewriteRuleUrl): any;
export declare class ApplicationGatewayRewriteRuleSetRewriteRuleUrlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayRewriteRuleSetRewriteRuleUrl | undefined;
    set internalValue(value: ApplicationGatewayRewriteRuleSetRewriteRuleUrl | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _queryString?;
    get queryString(): string;
    set queryString(value: string);
    resetQueryString(): void;
    get queryStringInput(): string | undefined;
    private _reroute?;
    get reroute(): boolean | cdktf.IResolvable;
    set reroute(value: boolean | cdktf.IResolvable);
    resetReroute(): void;
    get rerouteInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApplicationGatewayRewriteRuleSetRewriteRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rule_sequence ApplicationGateway#rule_sequence}
    */
    readonly ruleSequence: number;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#condition ApplicationGateway#condition}
    */
    readonly condition?: ApplicationGatewayRewriteRuleSetRewriteRuleCondition[] | cdktf.IResolvable;
    /**
    * request_header_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#request_header_configuration ApplicationGateway#request_header_configuration}
    */
    readonly requestHeaderConfiguration?: ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration[] | cdktf.IResolvable;
    /**
    * response_header_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#response_header_configuration ApplicationGateway#response_header_configuration}
    */
    readonly responseHeaderConfiguration?: ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration[] | cdktf.IResolvable;
    /**
    * url block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#url ApplicationGateway#url}
    */
    readonly url?: ApplicationGatewayRewriteRuleSetRewriteRuleUrl;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRule | cdktf.IResolvable): any;
export interface ApplicationGatewayRewriteRuleSet {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * rewrite_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rewrite_rule ApplicationGateway#rewrite_rule}
    */
    readonly rewriteRule?: ApplicationGatewayRewriteRuleSetRewriteRule[] | cdktf.IResolvable;
}
export declare function applicationGatewayRewriteRuleSetToTerraform(struct?: ApplicationGatewayRewriteRuleSet | cdktf.IResolvable): any;
export interface ApplicationGatewaySku {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#capacity ApplicationGateway#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#tier ApplicationGateway#tier}
    */
    readonly tier: string;
}
export declare function applicationGatewaySkuToTerraform(struct?: ApplicationGatewaySkuOutputReference | ApplicationGatewaySku): any;
export declare class ApplicationGatewaySkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewaySku | undefined;
    set internalValue(value: ApplicationGatewaySku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
}
export interface ApplicationGatewaySslCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#data ApplicationGateway#data}
    */
    readonly data?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#key_vault_secret_id ApplicationGateway#key_vault_secret_id}
    */
    readonly keyVaultSecretId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#password ApplicationGateway#password}
    */
    readonly password?: string;
}
export declare function applicationGatewaySslCertificateToTerraform(struct?: ApplicationGatewaySslCertificate | cdktf.IResolvable): any;
export interface ApplicationGatewaySslPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#cipher_suites ApplicationGateway#cipher_suites}
    */
    readonly cipherSuites?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#disabled_protocols ApplicationGateway#disabled_protocols}
    */
    readonly disabledProtocols?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#min_protocol_version ApplicationGateway#min_protocol_version}
    */
    readonly minProtocolVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#policy_name ApplicationGateway#policy_name}
    */
    readonly policyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#policy_type ApplicationGateway#policy_type}
    */
    readonly policyType?: string;
}
export declare function applicationGatewaySslPolicyToTerraform(struct?: ApplicationGatewaySslPolicyOutputReference | ApplicationGatewaySslPolicy): any;
export declare class ApplicationGatewaySslPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewaySslPolicy | undefined;
    set internalValue(value: ApplicationGatewaySslPolicy | undefined);
    private _cipherSuites?;
    get cipherSuites(): string[];
    set cipherSuites(value: string[]);
    resetCipherSuites(): void;
    get cipherSuitesInput(): string[] | undefined;
    private _disabledProtocols?;
    get disabledProtocols(): string[];
    set disabledProtocols(value: string[]);
    resetDisabledProtocols(): void;
    get disabledProtocolsInput(): string[] | undefined;
    private _minProtocolVersion?;
    get minProtocolVersion(): string;
    set minProtocolVersion(value: string);
    resetMinProtocolVersion(): void;
    get minProtocolVersionInput(): string | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
    private _policyType?;
    get policyType(): string;
    set policyType(value: string);
    resetPolicyType(): void;
    get policyTypeInput(): string | undefined;
}
export interface ApplicationGatewaySslProfileSslPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#cipher_suites ApplicationGateway#cipher_suites}
    */
    readonly cipherSuites?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#disabled_protocols ApplicationGateway#disabled_protocols}
    */
    readonly disabledProtocols?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#min_protocol_version ApplicationGateway#min_protocol_version}
    */
    readonly minProtocolVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#policy_name ApplicationGateway#policy_name}
    */
    readonly policyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#policy_type ApplicationGateway#policy_type}
    */
    readonly policyType?: string;
}
export declare function applicationGatewaySslProfileSslPolicyToTerraform(struct?: ApplicationGatewaySslProfileSslPolicyOutputReference | ApplicationGatewaySslProfileSslPolicy): any;
export declare class ApplicationGatewaySslProfileSslPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewaySslProfileSslPolicy | undefined;
    set internalValue(value: ApplicationGatewaySslProfileSslPolicy | undefined);
    private _cipherSuites?;
    get cipherSuites(): string[];
    set cipherSuites(value: string[]);
    resetCipherSuites(): void;
    get cipherSuitesInput(): string[] | undefined;
    private _disabledProtocols?;
    get disabledProtocols(): string[];
    set disabledProtocols(value: string[]);
    resetDisabledProtocols(): void;
    get disabledProtocolsInput(): string[] | undefined;
    private _minProtocolVersion?;
    get minProtocolVersion(): string;
    set minProtocolVersion(value: string);
    resetMinProtocolVersion(): void;
    get minProtocolVersionInput(): string | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
    private _policyType?;
    get policyType(): string;
    set policyType(value: string);
    resetPolicyType(): void;
    get policyTypeInput(): string | undefined;
}
export interface ApplicationGatewaySslProfile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#trusted_client_certificate_names ApplicationGateway#trusted_client_certificate_names}
    */
    readonly trustedClientCertificateNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#verify_client_cert_issuer_dn ApplicationGateway#verify_client_cert_issuer_dn}
    */
    readonly verifyClientCertIssuerDn?: boolean | cdktf.IResolvable;
    /**
    * ssl_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_policy ApplicationGateway#ssl_policy}
    */
    readonly sslPolicy?: ApplicationGatewaySslProfileSslPolicy;
}
export declare function applicationGatewaySslProfileToTerraform(struct?: ApplicationGatewaySslProfile | cdktf.IResolvable): any;
export interface ApplicationGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#create ApplicationGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#delete ApplicationGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#read ApplicationGateway#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#update ApplicationGateway#update}
    */
    readonly update?: string;
}
export declare function applicationGatewayTimeoutsToTerraform(struct?: ApplicationGatewayTimeoutsOutputReference | ApplicationGatewayTimeouts | cdktf.IResolvable): any;
export declare class ApplicationGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayTimeouts | undefined;
    set internalValue(value: ApplicationGatewayTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ApplicationGatewayTrustedClientCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#data ApplicationGateway#data}
    */
    readonly data: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
}
export declare function applicationGatewayTrustedClientCertificateToTerraform(struct?: ApplicationGatewayTrustedClientCertificate | cdktf.IResolvable): any;
export interface ApplicationGatewayTrustedRootCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#data ApplicationGateway#data}
    */
    readonly data?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#key_vault_secret_id ApplicationGateway#key_vault_secret_id}
    */
    readonly keyVaultSecretId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
}
export declare function applicationGatewayTrustedRootCertificateToTerraform(struct?: ApplicationGatewayTrustedRootCertificate | cdktf.IResolvable): any;
export interface ApplicationGatewayUrlPathMapPathRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_address_pool_name ApplicationGateway#backend_address_pool_name}
    */
    readonly backendAddressPoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_http_settings_name ApplicationGateway#backend_http_settings_name}
    */
    readonly backendHttpSettingsName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#firewall_policy_id ApplicationGateway#firewall_policy_id}
    */
    readonly firewallPolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#paths ApplicationGateway#paths}
    */
    readonly paths: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#redirect_configuration_name ApplicationGateway#redirect_configuration_name}
    */
    readonly redirectConfigurationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rewrite_rule_set_name ApplicationGateway#rewrite_rule_set_name}
    */
    readonly rewriteRuleSetName?: string;
}
export declare function applicationGatewayUrlPathMapPathRuleToTerraform(struct?: ApplicationGatewayUrlPathMapPathRule | cdktf.IResolvable): any;
export interface ApplicationGatewayUrlPathMap {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#default_backend_address_pool_name ApplicationGateway#default_backend_address_pool_name}
    */
    readonly defaultBackendAddressPoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#default_backend_http_settings_name ApplicationGateway#default_backend_http_settings_name}
    */
    readonly defaultBackendHttpSettingsName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#default_redirect_configuration_name ApplicationGateway#default_redirect_configuration_name}
    */
    readonly defaultRedirectConfigurationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#default_rewrite_rule_set_name ApplicationGateway#default_rewrite_rule_set_name}
    */
    readonly defaultRewriteRuleSetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}
    */
    readonly name: string;
    /**
    * path_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#path_rule ApplicationGateway#path_rule}
    */
    readonly pathRule: ApplicationGatewayUrlPathMapPathRule[] | cdktf.IResolvable;
}
export declare function applicationGatewayUrlPathMapToTerraform(struct?: ApplicationGatewayUrlPathMap | cdktf.IResolvable): any;
export interface ApplicationGatewayWafConfigurationDisabledRuleGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rule_group_name ApplicationGateway#rule_group_name}
    */
    readonly ruleGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rules ApplicationGateway#rules}
    */
    readonly rules?: number[];
}
export declare function applicationGatewayWafConfigurationDisabledRuleGroupToTerraform(struct?: ApplicationGatewayWafConfigurationDisabledRuleGroup | cdktf.IResolvable): any;
export interface ApplicationGatewayWafConfigurationExclusion {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#match_variable ApplicationGateway#match_variable}
    */
    readonly matchVariable: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#selector ApplicationGateway#selector}
    */
    readonly selector?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#selector_match_operator ApplicationGateway#selector_match_operator}
    */
    readonly selectorMatchOperator?: string;
}
export declare function applicationGatewayWafConfigurationExclusionToTerraform(struct?: ApplicationGatewayWafConfigurationExclusion | cdktf.IResolvable): any;
export interface ApplicationGatewayWafConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#enabled ApplicationGateway#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#file_upload_limit_mb ApplicationGateway#file_upload_limit_mb}
    */
    readonly fileUploadLimitMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#firewall_mode ApplicationGateway#firewall_mode}
    */
    readonly firewallMode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#max_request_body_size_kb ApplicationGateway#max_request_body_size_kb}
    */
    readonly maxRequestBodySizeKb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#request_body_check ApplicationGateway#request_body_check}
    */
    readonly requestBodyCheck?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rule_set_type ApplicationGateway#rule_set_type}
    */
    readonly ruleSetType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rule_set_version ApplicationGateway#rule_set_version}
    */
    readonly ruleSetVersion: string;
    /**
    * disabled_rule_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#disabled_rule_group ApplicationGateway#disabled_rule_group}
    */
    readonly disabledRuleGroup?: ApplicationGatewayWafConfigurationDisabledRuleGroup[] | cdktf.IResolvable;
    /**
    * exclusion block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#exclusion ApplicationGateway#exclusion}
    */
    readonly exclusion?: ApplicationGatewayWafConfigurationExclusion[] | cdktf.IResolvable;
}
export declare function applicationGatewayWafConfigurationToTerraform(struct?: ApplicationGatewayWafConfigurationOutputReference | ApplicationGatewayWafConfiguration): any;
export declare class ApplicationGatewayWafConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationGatewayWafConfiguration | undefined;
    set internalValue(value: ApplicationGatewayWafConfiguration | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _fileUploadLimitMb?;
    get fileUploadLimitMb(): number;
    set fileUploadLimitMb(value: number);
    resetFileUploadLimitMb(): void;
    get fileUploadLimitMbInput(): number | undefined;
    private _firewallMode?;
    get firewallMode(): string;
    set firewallMode(value: string);
    get firewallModeInput(): string | undefined;
    private _maxRequestBodySizeKb?;
    get maxRequestBodySizeKb(): number;
    set maxRequestBodySizeKb(value: number);
    resetMaxRequestBodySizeKb(): void;
    get maxRequestBodySizeKbInput(): number | undefined;
    private _requestBodyCheck?;
    get requestBodyCheck(): boolean | cdktf.IResolvable;
    set requestBodyCheck(value: boolean | cdktf.IResolvable);
    resetRequestBodyCheck(): void;
    get requestBodyCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _ruleSetType?;
    get ruleSetType(): string;
    set ruleSetType(value: string);
    resetRuleSetType(): void;
    get ruleSetTypeInput(): string | undefined;
    private _ruleSetVersion?;
    get ruleSetVersion(): string;
    set ruleSetVersion(value: string);
    get ruleSetVersionInput(): string | undefined;
    private _disabledRuleGroup?;
    get disabledRuleGroup(): ApplicationGatewayWafConfigurationDisabledRuleGroup[] | cdktf.IResolvable;
    set disabledRuleGroup(value: ApplicationGatewayWafConfigurationDisabledRuleGroup[] | cdktf.IResolvable);
    resetDisabledRuleGroup(): void;
    get disabledRuleGroupInput(): cdktf.IResolvable | ApplicationGatewayWafConfigurationDisabledRuleGroup[] | undefined;
    private _exclusion?;
    get exclusion(): ApplicationGatewayWafConfigurationExclusion[] | cdktf.IResolvable;
    set exclusion(value: ApplicationGatewayWafConfigurationExclusion[] | cdktf.IResolvable);
    resetExclusion(): void;
    get exclusionInput(): cdktf.IResolvable | ApplicationGatewayWafConfigurationExclusion[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway azurerm_application_gateway}
*/
export declare class ApplicationGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_application_gateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway azurerm_application_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationGatewayConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationGatewayConfig);
    private _enableHttp2?;
    get enableHttp2(): boolean | cdktf.IResolvable;
    set enableHttp2(value: boolean | cdktf.IResolvable);
    resetEnableHttp2(): void;
    get enableHttp2Input(): boolean | cdktf.IResolvable | undefined;
    private _fipsEnabled?;
    get fipsEnabled(): boolean | cdktf.IResolvable;
    set fipsEnabled(value: boolean | cdktf.IResolvable);
    resetFipsEnabled(): void;
    get fipsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallPolicyId?;
    get firewallPolicyId(): string;
    set firewallPolicyId(value: string);
    resetFirewallPolicyId(): void;
    get firewallPolicyIdInput(): string | undefined;
    private _forceFirewallPolicyAssociation?;
    get forceFirewallPolicyAssociation(): boolean | cdktf.IResolvable;
    set forceFirewallPolicyAssociation(value: boolean | cdktf.IResolvable);
    resetForceFirewallPolicyAssociation(): void;
    get forceFirewallPolicyAssociationInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateEndpointConnection;
    get privateEndpointConnection(): ApplicationGatewayPrivateEndpointConnectionList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _authenticationCertificate?;
    get authenticationCertificate(): ApplicationGatewayAuthenticationCertificate[] | cdktf.IResolvable;
    set authenticationCertificate(value: ApplicationGatewayAuthenticationCertificate[] | cdktf.IResolvable);
    resetAuthenticationCertificate(): void;
    get authenticationCertificateInput(): cdktf.IResolvable | ApplicationGatewayAuthenticationCertificate[] | undefined;
    private _autoscaleConfiguration;
    get autoscaleConfiguration(): ApplicationGatewayAutoscaleConfigurationOutputReference;
    putAutoscaleConfiguration(value: ApplicationGatewayAutoscaleConfiguration): void;
    resetAutoscaleConfiguration(): void;
    get autoscaleConfigurationInput(): ApplicationGatewayAutoscaleConfiguration | undefined;
    private _backendAddressPool?;
    get backendAddressPool(): ApplicationGatewayBackendAddressPool[] | cdktf.IResolvable;
    set backendAddressPool(value: ApplicationGatewayBackendAddressPool[] | cdktf.IResolvable);
    get backendAddressPoolInput(): cdktf.IResolvable | ApplicationGatewayBackendAddressPool[] | undefined;
    private _backendHttpSettings?;
    get backendHttpSettings(): ApplicationGatewayBackendHttpSettings[] | cdktf.IResolvable;
    set backendHttpSettings(value: ApplicationGatewayBackendHttpSettings[] | cdktf.IResolvable);
    get backendHttpSettingsInput(): cdktf.IResolvable | ApplicationGatewayBackendHttpSettings[] | undefined;
    private _customErrorConfiguration?;
    get customErrorConfiguration(): ApplicationGatewayCustomErrorConfiguration[] | cdktf.IResolvable;
    set customErrorConfiguration(value: ApplicationGatewayCustomErrorConfiguration[] | cdktf.IResolvable);
    resetCustomErrorConfiguration(): void;
    get customErrorConfigurationInput(): cdktf.IResolvable | ApplicationGatewayCustomErrorConfiguration[] | undefined;
    private _frontendIpConfiguration?;
    get frontendIpConfiguration(): ApplicationGatewayFrontendIpConfiguration[] | cdktf.IResolvable;
    set frontendIpConfiguration(value: ApplicationGatewayFrontendIpConfiguration[] | cdktf.IResolvable);
    get frontendIpConfigurationInput(): cdktf.IResolvable | ApplicationGatewayFrontendIpConfiguration[] | undefined;
    private _frontendPort?;
    get frontendPort(): ApplicationGatewayFrontendPort[] | cdktf.IResolvable;
    set frontendPort(value: ApplicationGatewayFrontendPort[] | cdktf.IResolvable);
    get frontendPortInput(): cdktf.IResolvable | ApplicationGatewayFrontendPort[] | undefined;
    private _gatewayIpConfiguration?;
    get gatewayIpConfiguration(): ApplicationGatewayGatewayIpConfiguration[] | cdktf.IResolvable;
    set gatewayIpConfiguration(value: ApplicationGatewayGatewayIpConfiguration[] | cdktf.IResolvable);
    get gatewayIpConfigurationInput(): cdktf.IResolvable | ApplicationGatewayGatewayIpConfiguration[] | undefined;
    private _httpListener?;
    get httpListener(): ApplicationGatewayHttpListener[] | cdktf.IResolvable;
    set httpListener(value: ApplicationGatewayHttpListener[] | cdktf.IResolvable);
    get httpListenerInput(): cdktf.IResolvable | ApplicationGatewayHttpListener[] | undefined;
    private _identity;
    get identity(): ApplicationGatewayIdentityOutputReference;
    putIdentity(value: ApplicationGatewayIdentity): void;
    resetIdentity(): void;
    get identityInput(): ApplicationGatewayIdentity | undefined;
    private _privateLinkConfiguration?;
    get privateLinkConfiguration(): ApplicationGatewayPrivateLinkConfiguration[] | cdktf.IResolvable;
    set privateLinkConfiguration(value: ApplicationGatewayPrivateLinkConfiguration[] | cdktf.IResolvable);
    resetPrivateLinkConfiguration(): void;
    get privateLinkConfigurationInput(): cdktf.IResolvable | ApplicationGatewayPrivateLinkConfiguration[] | undefined;
    private _probe?;
    get probe(): ApplicationGatewayProbe[] | cdktf.IResolvable;
    set probe(value: ApplicationGatewayProbe[] | cdktf.IResolvable);
    resetProbe(): void;
    get probeInput(): cdktf.IResolvable | ApplicationGatewayProbe[] | undefined;
    private _redirectConfiguration?;
    get redirectConfiguration(): ApplicationGatewayRedirectConfiguration[] | cdktf.IResolvable;
    set redirectConfiguration(value: ApplicationGatewayRedirectConfiguration[] | cdktf.IResolvable);
    resetRedirectConfiguration(): void;
    get redirectConfigurationInput(): cdktf.IResolvable | ApplicationGatewayRedirectConfiguration[] | undefined;
    private _requestRoutingRule?;
    get requestRoutingRule(): ApplicationGatewayRequestRoutingRule[] | cdktf.IResolvable;
    set requestRoutingRule(value: ApplicationGatewayRequestRoutingRule[] | cdktf.IResolvable);
    get requestRoutingRuleInput(): cdktf.IResolvable | ApplicationGatewayRequestRoutingRule[] | undefined;
    private _rewriteRuleSet?;
    get rewriteRuleSet(): ApplicationGatewayRewriteRuleSet[] | cdktf.IResolvable;
    set rewriteRuleSet(value: ApplicationGatewayRewriteRuleSet[] | cdktf.IResolvable);
    resetRewriteRuleSet(): void;
    get rewriteRuleSetInput(): cdktf.IResolvable | ApplicationGatewayRewriteRuleSet[] | undefined;
    private _sku;
    get sku(): ApplicationGatewaySkuOutputReference;
    putSku(value: ApplicationGatewaySku): void;
    get skuInput(): ApplicationGatewaySku | undefined;
    private _sslCertificate?;
    get sslCertificate(): ApplicationGatewaySslCertificate[] | cdktf.IResolvable;
    set sslCertificate(value: ApplicationGatewaySslCertificate[] | cdktf.IResolvable);
    resetSslCertificate(): void;
    get sslCertificateInput(): cdktf.IResolvable | ApplicationGatewaySslCertificate[] | undefined;
    private _sslPolicy;
    get sslPolicy(): ApplicationGatewaySslPolicyOutputReference;
    putSslPolicy(value: ApplicationGatewaySslPolicy): void;
    resetSslPolicy(): void;
    get sslPolicyInput(): ApplicationGatewaySslPolicy | undefined;
    private _sslProfile?;
    get sslProfile(): ApplicationGatewaySslProfile[] | cdktf.IResolvable;
    set sslProfile(value: ApplicationGatewaySslProfile[] | cdktf.IResolvable);
    resetSslProfile(): void;
    get sslProfileInput(): cdktf.IResolvable | ApplicationGatewaySslProfile[] | undefined;
    private _timeouts;
    get timeouts(): ApplicationGatewayTimeoutsOutputReference;
    putTimeouts(value: ApplicationGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApplicationGatewayTimeouts | undefined;
    private _trustedClientCertificate?;
    get trustedClientCertificate(): ApplicationGatewayTrustedClientCertificate[] | cdktf.IResolvable;
    set trustedClientCertificate(value: ApplicationGatewayTrustedClientCertificate[] | cdktf.IResolvable);
    resetTrustedClientCertificate(): void;
    get trustedClientCertificateInput(): cdktf.IResolvable | ApplicationGatewayTrustedClientCertificate[] | undefined;
    private _trustedRootCertificate?;
    get trustedRootCertificate(): ApplicationGatewayTrustedRootCertificate[] | cdktf.IResolvable;
    set trustedRootCertificate(value: ApplicationGatewayTrustedRootCertificate[] | cdktf.IResolvable);
    resetTrustedRootCertificate(): void;
    get trustedRootCertificateInput(): cdktf.IResolvable | ApplicationGatewayTrustedRootCertificate[] | undefined;
    private _urlPathMap?;
    get urlPathMap(): ApplicationGatewayUrlPathMap[] | cdktf.IResolvable;
    set urlPathMap(value: ApplicationGatewayUrlPathMap[] | cdktf.IResolvable);
    resetUrlPathMap(): void;
    get urlPathMapInput(): cdktf.IResolvable | ApplicationGatewayUrlPathMap[] | undefined;
    private _wafConfiguration;
    get wafConfiguration(): ApplicationGatewayWafConfigurationOutputReference;
    putWafConfiguration(value: ApplicationGatewayWafConfiguration): void;
    resetWafConfiguration(): void;
    get wafConfigurationInput(): ApplicationGatewayWafConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
