import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryTaskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#agent_pool_name ContainerRegistryTask#agent_pool_name}
    */
    readonly agentPoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#container_registry_id ContainerRegistryTask#container_registry_id}
    */
    readonly containerRegistryId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#enabled ContainerRegistryTask#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#is_system_task ContainerRegistryTask#is_system_task}
    */
    readonly isSystemTask?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#log_template ContainerRegistryTask#log_template}
    */
    readonly logTemplate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#name ContainerRegistryTask#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#tags ContainerRegistryTask#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#timeout_in_seconds ContainerRegistryTask#timeout_in_seconds}
    */
    readonly timeoutInSeconds?: number;
    /**
    * agent_setting block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#agent_setting ContainerRegistryTask#agent_setting}
    */
    readonly agentSetting?: ContainerRegistryTaskAgentSetting;
    /**
    * base_image_trigger block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#base_image_trigger ContainerRegistryTask#base_image_trigger}
    */
    readonly baseImageTrigger?: ContainerRegistryTaskBaseImageTrigger;
    /**
    * docker_step block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#docker_step ContainerRegistryTask#docker_step}
    */
    readonly dockerStep?: ContainerRegistryTaskDockerStep;
    /**
    * encoded_step block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#encoded_step ContainerRegistryTask#encoded_step}
    */
    readonly encodedStep?: ContainerRegistryTaskEncodedStep;
    /**
    * file_step block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#file_step ContainerRegistryTask#file_step}
    */
    readonly fileStep?: ContainerRegistryTaskFileStep;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#identity ContainerRegistryTask#identity}
    */
    readonly identity?: ContainerRegistryTaskIdentity;
    /**
    * platform block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#platform ContainerRegistryTask#platform}
    */
    readonly platform?: ContainerRegistryTaskPlatform;
    /**
    * registry_credential block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#registry_credential ContainerRegistryTask#registry_credential}
    */
    readonly registryCredential?: ContainerRegistryTaskRegistryCredential;
    /**
    * source_trigger block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#source_trigger ContainerRegistryTask#source_trigger}
    */
    readonly sourceTrigger?: ContainerRegistryTaskSourceTrigger[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#timeouts ContainerRegistryTask#timeouts}
    */
    readonly timeouts?: ContainerRegistryTaskTimeouts;
    /**
    * timer_trigger block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#timer_trigger ContainerRegistryTask#timer_trigger}
    */
    readonly timerTrigger?: ContainerRegistryTaskTimerTrigger[] | cdktf.IResolvable;
}
export interface ContainerRegistryTaskAgentSetting {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#cpu ContainerRegistryTask#cpu}
    */
    readonly cpu: number;
}
export declare function containerRegistryTaskAgentSettingToTerraform(struct?: ContainerRegistryTaskAgentSettingOutputReference | ContainerRegistryTaskAgentSetting): any;
export declare class ContainerRegistryTaskAgentSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTaskAgentSetting | undefined;
    set internalValue(value: ContainerRegistryTaskAgentSetting | undefined);
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    get cpuInput(): number | undefined;
}
export interface ContainerRegistryTaskBaseImageTrigger {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#enabled ContainerRegistryTask#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#name ContainerRegistryTask#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#type ContainerRegistryTask#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#update_trigger_endpoint ContainerRegistryTask#update_trigger_endpoint}
    */
    readonly updateTriggerEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#update_trigger_payload_type ContainerRegistryTask#update_trigger_payload_type}
    */
    readonly updateTriggerPayloadType?: string;
}
export declare function containerRegistryTaskBaseImageTriggerToTerraform(struct?: ContainerRegistryTaskBaseImageTriggerOutputReference | ContainerRegistryTaskBaseImageTrigger): any;
export declare class ContainerRegistryTaskBaseImageTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTaskBaseImageTrigger | undefined;
    set internalValue(value: ContainerRegistryTaskBaseImageTrigger | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _updateTriggerEndpoint?;
    get updateTriggerEndpoint(): string;
    set updateTriggerEndpoint(value: string);
    resetUpdateTriggerEndpoint(): void;
    get updateTriggerEndpointInput(): string | undefined;
    private _updateTriggerPayloadType?;
    get updateTriggerPayloadType(): string;
    set updateTriggerPayloadType(value: string);
    resetUpdateTriggerPayloadType(): void;
    get updateTriggerPayloadTypeInput(): string | undefined;
}
export interface ContainerRegistryTaskDockerStep {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#arguments ContainerRegistryTask#arguments}
    */
    readonly arguments?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#cache_enabled ContainerRegistryTask#cache_enabled}
    */
    readonly cacheEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_access_token ContainerRegistryTask#context_access_token}
    */
    readonly contextAccessToken: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_path ContainerRegistryTask#context_path}
    */
    readonly contextPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#dockerfile_path ContainerRegistryTask#dockerfile_path}
    */
    readonly dockerfilePath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#image_names ContainerRegistryTask#image_names}
    */
    readonly imageNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#push_enabled ContainerRegistryTask#push_enabled}
    */
    readonly pushEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#secret_arguments ContainerRegistryTask#secret_arguments}
    */
    readonly secretArguments?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#target ContainerRegistryTask#target}
    */
    readonly target?: string;
}
export declare function containerRegistryTaskDockerStepToTerraform(struct?: ContainerRegistryTaskDockerStepOutputReference | ContainerRegistryTaskDockerStep): any;
export declare class ContainerRegistryTaskDockerStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTaskDockerStep | undefined;
    set internalValue(value: ContainerRegistryTaskDockerStep | undefined);
    private _arguments?;
    get arguments(): {
        [key: string]: string;
    };
    set arguments(value: {
        [key: string]: string;
    });
    resetArguments(): void;
    get argumentsInput(): {
        [key: string]: string;
    } | undefined;
    private _cacheEnabled?;
    get cacheEnabled(): boolean | cdktf.IResolvable;
    set cacheEnabled(value: boolean | cdktf.IResolvable);
    resetCacheEnabled(): void;
    get cacheEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _contextAccessToken?;
    get contextAccessToken(): string;
    set contextAccessToken(value: string);
    get contextAccessTokenInput(): string | undefined;
    private _contextPath?;
    get contextPath(): string;
    set contextPath(value: string);
    get contextPathInput(): string | undefined;
    private _dockerfilePath?;
    get dockerfilePath(): string;
    set dockerfilePath(value: string);
    get dockerfilePathInput(): string | undefined;
    private _imageNames?;
    get imageNames(): string[];
    set imageNames(value: string[]);
    resetImageNames(): void;
    get imageNamesInput(): string[] | undefined;
    private _pushEnabled?;
    get pushEnabled(): boolean | cdktf.IResolvable;
    set pushEnabled(value: boolean | cdktf.IResolvable);
    resetPushEnabled(): void;
    get pushEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _secretArguments?;
    get secretArguments(): {
        [key: string]: string;
    };
    set secretArguments(value: {
        [key: string]: string;
    });
    resetSecretArguments(): void;
    get secretArgumentsInput(): {
        [key: string]: string;
    } | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
}
export interface ContainerRegistryTaskEncodedStep {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_access_token ContainerRegistryTask#context_access_token}
    */
    readonly contextAccessToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_path ContainerRegistryTask#context_path}
    */
    readonly contextPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#secret_values ContainerRegistryTask#secret_values}
    */
    readonly secretValues?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#task_content ContainerRegistryTask#task_content}
    */
    readonly taskContent: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#value_content ContainerRegistryTask#value_content}
    */
    readonly valueContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#values ContainerRegistryTask#values}
    */
    readonly values?: {
        [key: string]: string;
    };
}
export declare function containerRegistryTaskEncodedStepToTerraform(struct?: ContainerRegistryTaskEncodedStepOutputReference | ContainerRegistryTaskEncodedStep): any;
export declare class ContainerRegistryTaskEncodedStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTaskEncodedStep | undefined;
    set internalValue(value: ContainerRegistryTaskEncodedStep | undefined);
    private _contextAccessToken?;
    get contextAccessToken(): string;
    set contextAccessToken(value: string);
    resetContextAccessToken(): void;
    get contextAccessTokenInput(): string | undefined;
    private _contextPath?;
    get contextPath(): string;
    set contextPath(value: string);
    resetContextPath(): void;
    get contextPathInput(): string | undefined;
    private _secretValues?;
    get secretValues(): {
        [key: string]: string;
    };
    set secretValues(value: {
        [key: string]: string;
    });
    resetSecretValues(): void;
    get secretValuesInput(): {
        [key: string]: string;
    } | undefined;
    private _taskContent?;
    get taskContent(): string;
    set taskContent(value: string);
    get taskContentInput(): string | undefined;
    private _valueContent?;
    get valueContent(): string;
    set valueContent(value: string);
    resetValueContent(): void;
    get valueContentInput(): string | undefined;
    private _values?;
    get values(): {
        [key: string]: string;
    };
    set values(value: {
        [key: string]: string;
    });
    resetValues(): void;
    get valuesInput(): {
        [key: string]: string;
    } | undefined;
}
export interface ContainerRegistryTaskFileStep {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_access_token ContainerRegistryTask#context_access_token}
    */
    readonly contextAccessToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_path ContainerRegistryTask#context_path}
    */
    readonly contextPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#secret_values ContainerRegistryTask#secret_values}
    */
    readonly secretValues?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#task_file_path ContainerRegistryTask#task_file_path}
    */
    readonly taskFilePath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#value_file_path ContainerRegistryTask#value_file_path}
    */
    readonly valueFilePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#values ContainerRegistryTask#values}
    */
    readonly values?: {
        [key: string]: string;
    };
}
export declare function containerRegistryTaskFileStepToTerraform(struct?: ContainerRegistryTaskFileStepOutputReference | ContainerRegistryTaskFileStep): any;
export declare class ContainerRegistryTaskFileStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTaskFileStep | undefined;
    set internalValue(value: ContainerRegistryTaskFileStep | undefined);
    private _contextAccessToken?;
    get contextAccessToken(): string;
    set contextAccessToken(value: string);
    resetContextAccessToken(): void;
    get contextAccessTokenInput(): string | undefined;
    private _contextPath?;
    get contextPath(): string;
    set contextPath(value: string);
    resetContextPath(): void;
    get contextPathInput(): string | undefined;
    private _secretValues?;
    get secretValues(): {
        [key: string]: string;
    };
    set secretValues(value: {
        [key: string]: string;
    });
    resetSecretValues(): void;
    get secretValuesInput(): {
        [key: string]: string;
    } | undefined;
    private _taskFilePath?;
    get taskFilePath(): string;
    set taskFilePath(value: string);
    get taskFilePathInput(): string | undefined;
    private _valueFilePath?;
    get valueFilePath(): string;
    set valueFilePath(value: string);
    resetValueFilePath(): void;
    get valueFilePathInput(): string | undefined;
    private _values?;
    get values(): {
        [key: string]: string;
    };
    set values(value: {
        [key: string]: string;
    });
    resetValues(): void;
    get valuesInput(): {
        [key: string]: string;
    } | undefined;
}
export interface ContainerRegistryTaskIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#identity_ids ContainerRegistryTask#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#type ContainerRegistryTask#type}
    */
    readonly type: string;
}
export declare function containerRegistryTaskIdentityToTerraform(struct?: ContainerRegistryTaskIdentityOutputReference | ContainerRegistryTaskIdentity): any;
export declare class ContainerRegistryTaskIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTaskIdentity | undefined;
    set internalValue(value: ContainerRegistryTaskIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ContainerRegistryTaskPlatform {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#architecture ContainerRegistryTask#architecture}
    */
    readonly architecture?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#os ContainerRegistryTask#os}
    */
    readonly os: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#variant ContainerRegistryTask#variant}
    */
    readonly variant?: string;
}
export declare function containerRegistryTaskPlatformToTerraform(struct?: ContainerRegistryTaskPlatformOutputReference | ContainerRegistryTaskPlatform): any;
export declare class ContainerRegistryTaskPlatformOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTaskPlatform | undefined;
    set internalValue(value: ContainerRegistryTaskPlatform | undefined);
    private _architecture?;
    get architecture(): string;
    set architecture(value: string);
    resetArchitecture(): void;
    get architectureInput(): string | undefined;
    private _os?;
    get os(): string;
    set os(value: string);
    get osInput(): string | undefined;
    private _variant?;
    get variant(): string;
    set variant(value: string);
    resetVariant(): void;
    get variantInput(): string | undefined;
}
export interface ContainerRegistryTaskRegistryCredentialCustom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#identity ContainerRegistryTask#identity}
    */
    readonly identity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#login_server ContainerRegistryTask#login_server}
    */
    readonly loginServer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#password ContainerRegistryTask#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#username ContainerRegistryTask#username}
    */
    readonly username?: string;
}
export declare function containerRegistryTaskRegistryCredentialCustomToTerraform(struct?: ContainerRegistryTaskRegistryCredentialCustom | cdktf.IResolvable): any;
export interface ContainerRegistryTaskRegistryCredentialSource {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#login_mode ContainerRegistryTask#login_mode}
    */
    readonly loginMode: string;
}
export declare function containerRegistryTaskRegistryCredentialSourceToTerraform(struct?: ContainerRegistryTaskRegistryCredentialSourceOutputReference | ContainerRegistryTaskRegistryCredentialSource): any;
export declare class ContainerRegistryTaskRegistryCredentialSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTaskRegistryCredentialSource | undefined;
    set internalValue(value: ContainerRegistryTaskRegistryCredentialSource | undefined);
    private _loginMode?;
    get loginMode(): string;
    set loginMode(value: string);
    get loginModeInput(): string | undefined;
}
export interface ContainerRegistryTaskRegistryCredential {
    /**
    * custom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#custom ContainerRegistryTask#custom}
    */
    readonly custom?: ContainerRegistryTaskRegistryCredentialCustom[] | cdktf.IResolvable;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#source ContainerRegistryTask#source}
    */
    readonly source?: ContainerRegistryTaskRegistryCredentialSource;
}
export declare function containerRegistryTaskRegistryCredentialToTerraform(struct?: ContainerRegistryTaskRegistryCredentialOutputReference | ContainerRegistryTaskRegistryCredential): any;
export declare class ContainerRegistryTaskRegistryCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTaskRegistryCredential | undefined;
    set internalValue(value: ContainerRegistryTaskRegistryCredential | undefined);
    private _custom?;
    get custom(): ContainerRegistryTaskRegistryCredentialCustom[] | cdktf.IResolvable;
    set custom(value: ContainerRegistryTaskRegistryCredentialCustom[] | cdktf.IResolvable);
    resetCustom(): void;
    get customInput(): cdktf.IResolvable | ContainerRegistryTaskRegistryCredentialCustom[] | undefined;
    private _source;
    get source(): ContainerRegistryTaskRegistryCredentialSourceOutputReference;
    putSource(value: ContainerRegistryTaskRegistryCredentialSource): void;
    resetSource(): void;
    get sourceInput(): ContainerRegistryTaskRegistryCredentialSource | undefined;
}
export interface ContainerRegistryTaskSourceTriggerAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#expire_in_seconds ContainerRegistryTask#expire_in_seconds}
    */
    readonly expireInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#refresh_token ContainerRegistryTask#refresh_token}
    */
    readonly refreshToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#scope ContainerRegistryTask#scope}
    */
    readonly scope?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#token ContainerRegistryTask#token}
    */
    readonly token: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#token_type ContainerRegistryTask#token_type}
    */
    readonly tokenType: string;
}
export declare function containerRegistryTaskSourceTriggerAuthenticationToTerraform(struct?: ContainerRegistryTaskSourceTriggerAuthenticationOutputReference | ContainerRegistryTaskSourceTriggerAuthentication): any;
export declare class ContainerRegistryTaskSourceTriggerAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTaskSourceTriggerAuthentication | undefined;
    set internalValue(value: ContainerRegistryTaskSourceTriggerAuthentication | undefined);
    private _expireInSeconds?;
    get expireInSeconds(): number;
    set expireInSeconds(value: number);
    resetExpireInSeconds(): void;
    get expireInSecondsInput(): number | undefined;
    private _refreshToken?;
    get refreshToken(): string;
    set refreshToken(value: string);
    resetRefreshToken(): void;
    get refreshTokenInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    get tokenTypeInput(): string | undefined;
}
export interface ContainerRegistryTaskSourceTrigger {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#branch ContainerRegistryTask#branch}
    */
    readonly branch?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#enabled ContainerRegistryTask#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#events ContainerRegistryTask#events}
    */
    readonly events: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#name ContainerRegistryTask#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#repository_url ContainerRegistryTask#repository_url}
    */
    readonly repositoryUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#source_type ContainerRegistryTask#source_type}
    */
    readonly sourceType: string;
    /**
    * authentication block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#authentication ContainerRegistryTask#authentication}
    */
    readonly authentication?: ContainerRegistryTaskSourceTriggerAuthentication;
}
export declare function containerRegistryTaskSourceTriggerToTerraform(struct?: ContainerRegistryTaskSourceTrigger | cdktf.IResolvable): any;
export interface ContainerRegistryTaskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#create ContainerRegistryTask#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#delete ContainerRegistryTask#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#read ContainerRegistryTask#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#update ContainerRegistryTask#update}
    */
    readonly update?: string;
}
export declare function containerRegistryTaskTimeoutsToTerraform(struct?: ContainerRegistryTaskTimeoutsOutputReference | ContainerRegistryTaskTimeouts | cdktf.IResolvable): any;
export declare class ContainerRegistryTaskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTaskTimeouts | undefined;
    set internalValue(value: ContainerRegistryTaskTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ContainerRegistryTaskTimerTrigger {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#enabled ContainerRegistryTask#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#name ContainerRegistryTask#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#schedule ContainerRegistryTask#schedule}
    */
    readonly schedule: string;
}
export declare function containerRegistryTaskTimerTriggerToTerraform(struct?: ContainerRegistryTaskTimerTrigger | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task azurerm_container_registry_task}
*/
export declare class ContainerRegistryTask extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_registry_task";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task azurerm_container_registry_task} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerRegistryTaskConfig
    */
    constructor(scope: Construct, id: string, config: ContainerRegistryTaskConfig);
    private _agentPoolName?;
    get agentPoolName(): string;
    set agentPoolName(value: string);
    resetAgentPoolName(): void;
    get agentPoolNameInput(): string | undefined;
    private _containerRegistryId?;
    get containerRegistryId(): string;
    set containerRegistryId(value: string);
    get containerRegistryIdInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _isSystemTask?;
    get isSystemTask(): boolean | cdktf.IResolvable;
    set isSystemTask(value: boolean | cdktf.IResolvable);
    resetIsSystemTask(): void;
    get isSystemTaskInput(): boolean | cdktf.IResolvable | undefined;
    private _logTemplate?;
    get logTemplate(): string;
    set logTemplate(value: string);
    resetLogTemplate(): void;
    get logTemplateInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeoutInSeconds?;
    get timeoutInSeconds(): number;
    set timeoutInSeconds(value: number);
    resetTimeoutInSeconds(): void;
    get timeoutInSecondsInput(): number | undefined;
    private _agentSetting;
    get agentSetting(): ContainerRegistryTaskAgentSettingOutputReference;
    putAgentSetting(value: ContainerRegistryTaskAgentSetting): void;
    resetAgentSetting(): void;
    get agentSettingInput(): ContainerRegistryTaskAgentSetting | undefined;
    private _baseImageTrigger;
    get baseImageTrigger(): ContainerRegistryTaskBaseImageTriggerOutputReference;
    putBaseImageTrigger(value: ContainerRegistryTaskBaseImageTrigger): void;
    resetBaseImageTrigger(): void;
    get baseImageTriggerInput(): ContainerRegistryTaskBaseImageTrigger | undefined;
    private _dockerStep;
    get dockerStep(): ContainerRegistryTaskDockerStepOutputReference;
    putDockerStep(value: ContainerRegistryTaskDockerStep): void;
    resetDockerStep(): void;
    get dockerStepInput(): ContainerRegistryTaskDockerStep | undefined;
    private _encodedStep;
    get encodedStep(): ContainerRegistryTaskEncodedStepOutputReference;
    putEncodedStep(value: ContainerRegistryTaskEncodedStep): void;
    resetEncodedStep(): void;
    get encodedStepInput(): ContainerRegistryTaskEncodedStep | undefined;
    private _fileStep;
    get fileStep(): ContainerRegistryTaskFileStepOutputReference;
    putFileStep(value: ContainerRegistryTaskFileStep): void;
    resetFileStep(): void;
    get fileStepInput(): ContainerRegistryTaskFileStep | undefined;
    private _identity;
    get identity(): ContainerRegistryTaskIdentityOutputReference;
    putIdentity(value: ContainerRegistryTaskIdentity): void;
    resetIdentity(): void;
    get identityInput(): ContainerRegistryTaskIdentity | undefined;
    private _platform;
    get platform(): ContainerRegistryTaskPlatformOutputReference;
    putPlatform(value: ContainerRegistryTaskPlatform): void;
    resetPlatform(): void;
    get platformInput(): ContainerRegistryTaskPlatform | undefined;
    private _registryCredential;
    get registryCredential(): ContainerRegistryTaskRegistryCredentialOutputReference;
    putRegistryCredential(value: ContainerRegistryTaskRegistryCredential): void;
    resetRegistryCredential(): void;
    get registryCredentialInput(): ContainerRegistryTaskRegistryCredential | undefined;
    private _sourceTrigger?;
    get sourceTrigger(): ContainerRegistryTaskSourceTrigger[] | cdktf.IResolvable;
    set sourceTrigger(value: ContainerRegistryTaskSourceTrigger[] | cdktf.IResolvable);
    resetSourceTrigger(): void;
    get sourceTriggerInput(): cdktf.IResolvable | ContainerRegistryTaskSourceTrigger[] | undefined;
    private _timeouts;
    get timeouts(): ContainerRegistryTaskTimeoutsOutputReference;
    putTimeouts(value: ContainerRegistryTaskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ContainerRegistryTaskTimeouts | undefined;
    private _timerTrigger?;
    get timerTrigger(): ContainerRegistryTaskTimerTrigger[] | cdktf.IResolvable;
    set timerTrigger(value: ContainerRegistryTaskTimerTrigger[] | cdktf.IResolvable);
    resetTimerTrigger(): void;
    get timerTriggerInput(): cdktf.IResolvable | ContainerRegistryTaskTimerTrigger[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
