import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApplicationInsightsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_insights#name DataAzurermApplicationInsights#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_insights#resource_group_name DataAzurermApplicationInsights#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_insights#timeouts DataAzurermApplicationInsights#timeouts}
    */
    readonly timeouts?: DataAzurermApplicationInsightsTimeouts;
}
export interface DataAzurermApplicationInsightsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_insights#read DataAzurermApplicationInsights#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApplicationInsightsTimeoutsToTerraform(struct?: DataAzurermApplicationInsightsTimeoutsOutputReference | DataAzurermApplicationInsightsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApplicationInsightsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermApplicationInsightsTimeouts | undefined;
    set internalValue(value: DataAzurermApplicationInsightsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/application_insights azurerm_application_insights}
*/
export declare class DataAzurermApplicationInsights extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_application_insights";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/application_insights azurerm_application_insights} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApplicationInsightsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApplicationInsightsConfig);
    get appId(): string;
    get applicationType(): string;
    get connectionString(): string;
    get id(): string;
    get instrumentationKey(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get retentionInDays(): number;
    tags(key: string): string | cdktf.IResolvable;
    get workspaceId(): string;
    private _timeouts;
    get timeouts(): DataAzurermApplicationInsightsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApplicationInsightsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermApplicationInsightsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
