import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCosmosdbAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#name DataAzurermCosmosdbAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#resource_group_name DataAzurermCosmosdbAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#timeouts DataAzurermCosmosdbAccount#timeouts}
    */
    readonly timeouts?: DataAzurermCosmosdbAccountTimeouts;
}
export interface DataAzurermCosmosdbAccountCapabilities {
}
export declare function dataAzurermCosmosdbAccountCapabilitiesToTerraform(struct?: DataAzurermCosmosdbAccountCapabilities): any;
export declare class DataAzurermCosmosdbAccountCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCosmosdbAccountCapabilities | undefined;
    set internalValue(value: DataAzurermCosmosdbAccountCapabilities | undefined);
    get name(): string;
}
export declare class DataAzurermCosmosdbAccountCapabilitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCosmosdbAccountCapabilitiesOutputReference;
}
export interface DataAzurermCosmosdbAccountConsistencyPolicy {
}
export declare function dataAzurermCosmosdbAccountConsistencyPolicyToTerraform(struct?: DataAzurermCosmosdbAccountConsistencyPolicy): any;
export declare class DataAzurermCosmosdbAccountConsistencyPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCosmosdbAccountConsistencyPolicy | undefined;
    set internalValue(value: DataAzurermCosmosdbAccountConsistencyPolicy | undefined);
    get consistencyLevel(): string;
    get maxIntervalInSeconds(): number;
    get maxStalenessPrefix(): number;
}
export declare class DataAzurermCosmosdbAccountConsistencyPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCosmosdbAccountConsistencyPolicyOutputReference;
}
export interface DataAzurermCosmosdbAccountGeoLocation {
}
export declare function dataAzurermCosmosdbAccountGeoLocationToTerraform(struct?: DataAzurermCosmosdbAccountGeoLocation): any;
export declare class DataAzurermCosmosdbAccountGeoLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCosmosdbAccountGeoLocation | undefined;
    set internalValue(value: DataAzurermCosmosdbAccountGeoLocation | undefined);
    get failoverPriority(): number;
    get id(): string;
    get location(): string;
}
export declare class DataAzurermCosmosdbAccountGeoLocationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCosmosdbAccountGeoLocationOutputReference;
}
export interface DataAzurermCosmosdbAccountVirtualNetworkRule {
}
export declare function dataAzurermCosmosdbAccountVirtualNetworkRuleToTerraform(struct?: DataAzurermCosmosdbAccountVirtualNetworkRule): any;
export declare class DataAzurermCosmosdbAccountVirtualNetworkRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCosmosdbAccountVirtualNetworkRule | undefined;
    set internalValue(value: DataAzurermCosmosdbAccountVirtualNetworkRule | undefined);
    get id(): string;
}
export declare class DataAzurermCosmosdbAccountVirtualNetworkRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCosmosdbAccountVirtualNetworkRuleOutputReference;
}
export interface DataAzurermCosmosdbAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#read DataAzurermCosmosdbAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCosmosdbAccountTimeoutsToTerraform(struct?: DataAzurermCosmosdbAccountTimeoutsOutputReference | DataAzurermCosmosdbAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCosmosdbAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermCosmosdbAccountTimeouts | undefined;
    set internalValue(value: DataAzurermCosmosdbAccountTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account azurerm_cosmosdb_account}
*/
export declare class DataAzurermCosmosdbAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_cosmosdb_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account azurerm_cosmosdb_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCosmosdbAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCosmosdbAccountConfig);
    private _capabilities;
    get capabilities(): DataAzurermCosmosdbAccountCapabilitiesList;
    private _consistencyPolicy;
    get consistencyPolicy(): DataAzurermCosmosdbAccountConsistencyPolicyList;
    get enableAutomaticFailover(): cdktf.IResolvable;
    get enableFreeTier(): cdktf.IResolvable;
    get enableMultipleWriteLocations(): cdktf.IResolvable;
    get endpoint(): string;
    private _geoLocation;
    get geoLocation(): DataAzurermCosmosdbAccountGeoLocationList;
    get id(): string;
    get ipRangeFilter(): string;
    get isVirtualNetworkFilterEnabled(): cdktf.IResolvable;
    get keyVaultKeyId(): string;
    get kind(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get offerType(): string;
    get primaryKey(): string;
    get primaryMasterKey(): string;
    get primaryReadonlyKey(): string;
    get primaryReadonlyMasterKey(): string;
    get readEndpoints(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryKey(): string;
    get secondaryMasterKey(): string;
    get secondaryReadonlyKey(): string;
    get secondaryReadonlyMasterKey(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _virtualNetworkRule;
    get virtualNetworkRule(): DataAzurermCosmosdbAccountVirtualNetworkRuleList;
    get writeEndpoints(): string[];
    private _timeouts;
    get timeouts(): DataAzurermCosmosdbAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCosmosdbAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermCosmosdbAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
