import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataProtectionBackupVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault#name DataAzurermDataProtectionBackupVault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault#resource_group_name DataAzurermDataProtectionBackupVault#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault#timeouts DataAzurermDataProtectionBackupVault#timeouts}
    */
    readonly timeouts?: DataAzurermDataProtectionBackupVaultTimeouts;
}
export interface DataAzurermDataProtectionBackupVaultIdentity {
}
export declare function dataAzurermDataProtectionBackupVaultIdentityToTerraform(struct?: DataAzurermDataProtectionBackupVaultIdentity): any;
export declare class DataAzurermDataProtectionBackupVaultIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDataProtectionBackupVaultIdentity | undefined;
    set internalValue(value: DataAzurermDataProtectionBackupVaultIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermDataProtectionBackupVaultIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDataProtectionBackupVaultIdentityOutputReference;
}
export interface DataAzurermDataProtectionBackupVaultTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault#read DataAzurermDataProtectionBackupVault#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataProtectionBackupVaultTimeoutsToTerraform(struct?: DataAzurermDataProtectionBackupVaultTimeoutsOutputReference | DataAzurermDataProtectionBackupVaultTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataProtectionBackupVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDataProtectionBackupVaultTimeouts | undefined;
    set internalValue(value: DataAzurermDataProtectionBackupVaultTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault azurerm_data_protection_backup_vault}
*/
export declare class DataAzurermDataProtectionBackupVault extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_data_protection_backup_vault";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault azurerm_data_protection_backup_vault} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataProtectionBackupVaultConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataProtectionBackupVaultConfig);
    get datastoreType(): string;
    get id(): string;
    private _identity;
    get identity(): DataAzurermDataProtectionBackupVaultIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get redundancy(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermDataProtectionBackupVaultTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataProtectionBackupVaultTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDataProtectionBackupVaultTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
