import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataShareAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account#name DataAzurermDataShareAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account#resource_group_name DataAzurermDataShareAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account#timeouts DataAzurermDataShareAccount#timeouts}
    */
    readonly timeouts?: DataAzurermDataShareAccountTimeouts;
}
export interface DataAzurermDataShareAccountIdentity {
}
export declare function dataAzurermDataShareAccountIdentityToTerraform(struct?: DataAzurermDataShareAccountIdentity): any;
export declare class DataAzurermDataShareAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDataShareAccountIdentity | undefined;
    set internalValue(value: DataAzurermDataShareAccountIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermDataShareAccountIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDataShareAccountIdentityOutputReference;
}
export interface DataAzurermDataShareAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account#read DataAzurermDataShareAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataShareAccountTimeoutsToTerraform(struct?: DataAzurermDataShareAccountTimeoutsOutputReference | DataAzurermDataShareAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataShareAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDataShareAccountTimeouts | undefined;
    set internalValue(value: DataAzurermDataShareAccountTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account azurerm_data_share_account}
*/
export declare class DataAzurermDataShareAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_data_share_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account azurerm_data_share_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataShareAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareAccountConfig);
    get id(): string;
    private _identity;
    get identity(): DataAzurermDataShareAccountIdentityList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermDataShareAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataShareAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDataShareAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
