import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDiskAccessConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access#name DataAzurermDiskAccess#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access#resource_group_name DataAzurermDiskAccess#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access#tags DataAzurermDiskAccess#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access#timeouts DataAzurermDiskAccess#timeouts}
    */
    readonly timeouts?: DataAzurermDiskAccessTimeouts;
}
export interface DataAzurermDiskAccessTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access#read DataAzurermDiskAccess#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDiskAccessTimeoutsToTerraform(struct?: DataAzurermDiskAccessTimeoutsOutputReference | DataAzurermDiskAccessTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDiskAccessTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDiskAccessTimeouts | undefined;
    set internalValue(value: DataAzurermDiskAccessTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access azurerm_disk_access}
*/
export declare class DataAzurermDiskAccess extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_disk_access";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access azurerm_disk_access} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDiskAccessConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDiskAccessConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermDiskAccessTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDiskAccessTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDiskAccessTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
