import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermExtendedLocationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/extended_locations#location DataAzurermExtendedLocations#location}
    */
    readonly location: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/extended_locations#timeouts DataAzurermExtendedLocations#timeouts}
    */
    readonly timeouts?: DataAzurermExtendedLocationsTimeouts;
}
export interface DataAzurermExtendedLocationsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/extended_locations#read DataAzurermExtendedLocations#read}
    */
    readonly read?: string;
}
export declare function dataAzurermExtendedLocationsTimeoutsToTerraform(struct?: DataAzurermExtendedLocationsTimeoutsOutputReference | DataAzurermExtendedLocationsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermExtendedLocationsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermExtendedLocationsTimeouts | undefined;
    set internalValue(value: DataAzurermExtendedLocationsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/extended_locations azurerm_extended_locations}
*/
export declare class DataAzurermExtendedLocations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_extended_locations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/extended_locations azurerm_extended_locations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermExtendedLocationsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermExtendedLocationsConfig);
    get extendedLocations(): string[];
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermExtendedLocationsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermExtendedLocationsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermExtendedLocationsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
