import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultCertificateDataConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_data#key_vault_id DataAzurermKeyVaultCertificateData#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_data#name DataAzurermKeyVaultCertificateData#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_data#version DataAzurermKeyVaultCertificateData#version}
    */
    readonly version?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_data#timeouts DataAzurermKeyVaultCertificateData#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultCertificateDataTimeouts;
}
export interface DataAzurermKeyVaultCertificateDataTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_data#read DataAzurermKeyVaultCertificateData#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultCertificateDataTimeoutsToTerraform(struct?: DataAzurermKeyVaultCertificateDataTimeoutsOutputReference | DataAzurermKeyVaultCertificateDataTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultCertificateDataTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKeyVaultCertificateDataTimeouts | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateDataTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_data azurerm_key_vault_certificate_data}
*/
export declare class DataAzurermKeyVaultCertificateData extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_key_vault_certificate_data";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_data azurerm_key_vault_certificate_data} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultCertificateDataConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultCertificateDataConfig);
    get certificatesCount(): number;
    get expires(): string;
    get hex(): string;
    get id(): string;
    get key(): string;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get notBefore(): string;
    get pem(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultCertificateDataTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultCertificateDataTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKeyVaultCertificateDataTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
