import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster#name DataAzurermKubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster#resource_group_name DataAzurermKubernetesCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster#timeouts DataAzurermKubernetesCluster#timeouts}
    */
    readonly timeouts?: DataAzurermKubernetesClusterTimeouts;
}
export interface DataAzurermKubernetesClusterAciConnectorLinux {
}
export declare function dataAzurermKubernetesClusterAciConnectorLinuxToTerraform(struct?: DataAzurermKubernetesClusterAciConnectorLinux): any;
export declare class DataAzurermKubernetesClusterAciConnectorLinuxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAciConnectorLinux | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAciConnectorLinux | undefined);
    get subnetName(): string;
}
export declare class DataAzurermKubernetesClusterAciConnectorLinuxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAciConnectorLinuxOutputReference;
}
export interface DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderSecretIdentity {
}
export declare function dataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderSecretIdentityToTerraform(struct?: DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderSecretIdentity): any;
export declare class DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderSecretIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderSecretIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderSecretIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderSecretIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderSecretIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProvider {
}
export declare function dataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderToTerraform(struct?: DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProvider): any;
export declare class DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProvider | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProvider | undefined);
    get enabled(): cdktf.IResolvable;
    private _secretIdentity;
    get secretIdentity(): DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderSecretIdentityList;
    get secretRotationEnabled(): string;
    get secretRotationInterval(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderOutputReference;
}
export interface DataAzurermKubernetesClusterAddonProfileAzurePolicy {
}
export declare function dataAzurermKubernetesClusterAddonProfileAzurePolicyToTerraform(struct?: DataAzurermKubernetesClusterAddonProfileAzurePolicy): any;
export declare class DataAzurermKubernetesClusterAddonProfileAzurePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAddonProfileAzurePolicy | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAddonProfileAzurePolicy | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterAddonProfileAzurePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAddonProfileAzurePolicyOutputReference;
}
export interface DataAzurermKubernetesClusterAddonProfileHttpApplicationRouting {
}
export declare function dataAzurermKubernetesClusterAddonProfileHttpApplicationRoutingToTerraform(struct?: DataAzurermKubernetesClusterAddonProfileHttpApplicationRouting): any;
export declare class DataAzurermKubernetesClusterAddonProfileHttpApplicationRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAddonProfileHttpApplicationRouting | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAddonProfileHttpApplicationRouting | undefined);
    get enabled(): cdktf.IResolvable;
    get httpApplicationRoutingZoneName(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileHttpApplicationRoutingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAddonProfileHttpApplicationRoutingOutputReference;
}
export interface DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayIngressApplicationGatewayIdentity {
}
export declare function dataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayIngressApplicationGatewayIdentityToTerraform(struct?: DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayIngressApplicationGatewayIdentity): any;
export declare class DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayIngressApplicationGatewayIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayIngressApplicationGatewayIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayIngressApplicationGatewayIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayIngressApplicationGatewayIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayIngressApplicationGatewayIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterAddonProfileIngressApplicationGateway {
}
export declare function dataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayToTerraform(struct?: DataAzurermKubernetesClusterAddonProfileIngressApplicationGateway): any;
export declare class DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAddonProfileIngressApplicationGateway | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAddonProfileIngressApplicationGateway | undefined);
    get effectiveGatewayId(): string;
    get enabled(): cdktf.IResolvable;
    get gatewayId(): string;
    private _ingressApplicationGatewayIdentity;
    get ingressApplicationGatewayIdentity(): DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayIngressApplicationGatewayIdentityList;
    get subnetCidr(): string;
    get subnetId(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayOutputReference;
}
export interface DataAzurermKubernetesClusterAddonProfileKubeDashboard {
}
export declare function dataAzurermKubernetesClusterAddonProfileKubeDashboardToTerraform(struct?: DataAzurermKubernetesClusterAddonProfileKubeDashboard): any;
export declare class DataAzurermKubernetesClusterAddonProfileKubeDashboardOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAddonProfileKubeDashboard | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAddonProfileKubeDashboard | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterAddonProfileKubeDashboardList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAddonProfileKubeDashboardOutputReference;
}
export interface DataAzurermKubernetesClusterAddonProfileOmsAgentOmsAgentIdentity {
}
export declare function dataAzurermKubernetesClusterAddonProfileOmsAgentOmsAgentIdentityToTerraform(struct?: DataAzurermKubernetesClusterAddonProfileOmsAgentOmsAgentIdentity): any;
export declare class DataAzurermKubernetesClusterAddonProfileOmsAgentOmsAgentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAddonProfileOmsAgentOmsAgentIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAddonProfileOmsAgentOmsAgentIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileOmsAgentOmsAgentIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAddonProfileOmsAgentOmsAgentIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterAddonProfileOmsAgent {
}
export declare function dataAzurermKubernetesClusterAddonProfileOmsAgentToTerraform(struct?: DataAzurermKubernetesClusterAddonProfileOmsAgent): any;
export declare class DataAzurermKubernetesClusterAddonProfileOmsAgentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAddonProfileOmsAgent | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAddonProfileOmsAgent | undefined);
    get enabled(): cdktf.IResolvable;
    get logAnalyticsWorkspaceId(): string;
    private _omsAgentIdentity;
    get omsAgentIdentity(): DataAzurermKubernetesClusterAddonProfileOmsAgentOmsAgentIdentityList;
}
export declare class DataAzurermKubernetesClusterAddonProfileOmsAgentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAddonProfileOmsAgentOutputReference;
}
export interface DataAzurermKubernetesClusterAddonProfileOpenServiceMesh {
}
export declare function dataAzurermKubernetesClusterAddonProfileOpenServiceMeshToTerraform(struct?: DataAzurermKubernetesClusterAddonProfileOpenServiceMesh): any;
export declare class DataAzurermKubernetesClusterAddonProfileOpenServiceMeshOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAddonProfileOpenServiceMesh | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAddonProfileOpenServiceMesh | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterAddonProfileOpenServiceMeshList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAddonProfileOpenServiceMeshOutputReference;
}
export interface DataAzurermKubernetesClusterAddonProfile {
}
export declare function dataAzurermKubernetesClusterAddonProfileToTerraform(struct?: DataAzurermKubernetesClusterAddonProfile): any;
export declare class DataAzurermKubernetesClusterAddonProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAddonProfile | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAddonProfile | undefined);
    private _azureKeyvaultSecretsProvider;
    get azureKeyvaultSecretsProvider(): DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderList;
    private _azurePolicy;
    get azurePolicy(): DataAzurermKubernetesClusterAddonProfileAzurePolicyList;
    private _httpApplicationRouting;
    get httpApplicationRouting(): DataAzurermKubernetesClusterAddonProfileHttpApplicationRoutingList;
    private _ingressApplicationGateway;
    get ingressApplicationGateway(): DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayList;
    private _kubeDashboard;
    get kubeDashboard(): DataAzurermKubernetesClusterAddonProfileKubeDashboardList;
    private _omsAgent;
    get omsAgent(): DataAzurermKubernetesClusterAddonProfileOmsAgentList;
    private _openServiceMesh;
    get openServiceMesh(): DataAzurermKubernetesClusterAddonProfileOpenServiceMeshList;
}
export declare class DataAzurermKubernetesClusterAddonProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAddonProfileOutputReference;
}
export interface DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettings {
}
export declare function dataAzurermKubernetesClusterAgentPoolProfileUpgradeSettingsToTerraform(struct?: DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettings): any;
export declare class DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettings | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettings | undefined);
    get maxSurge(): string;
}
export declare class DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettingsOutputReference;
}
export interface DataAzurermKubernetesClusterAgentPoolProfile {
}
export declare function dataAzurermKubernetesClusterAgentPoolProfileToTerraform(struct?: DataAzurermKubernetesClusterAgentPoolProfile): any;
export declare class DataAzurermKubernetesClusterAgentPoolProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAgentPoolProfile | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAgentPoolProfile | undefined);
    get availabilityZones(): string[];
    get count(): number;
    get enableAutoScaling(): cdktf.IResolvable;
    get enableNodePublicIp(): cdktf.IResolvable;
    get maxCount(): number;
    get maxPods(): number;
    get minCount(): number;
    get name(): string;
    nodeLabels(key: string): string | cdktf.IResolvable;
    get nodePublicIpPrefixId(): string;
    get nodeTaints(): string[];
    get orchestratorVersion(): string;
    get osDiskSizeGb(): number;
    get osType(): string;
    tags(key: string): string | cdktf.IResolvable;
    get type(): string;
    private _upgradeSettings;
    get upgradeSettings(): DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettingsList;
    get vmSize(): string;
    get vnetSubnetId(): string;
    get zones(): string[];
}
export declare class DataAzurermKubernetesClusterAgentPoolProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAgentPoolProfileOutputReference;
}
export interface DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControl {
}
export declare function dataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlToTerraform(struct?: DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControl): any;
export declare class DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControl | undefined;
    set internalValue(value: DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControl | undefined);
    get adminGroupObjectIds(): string[];
    get azureRbacEnabled(): cdktf.IResolvable;
    get clientAppId(): string;
    get managed(): cdktf.IResolvable;
    get serverAppId(): string;
    get tenantId(): string;
}
export declare class DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlOutputReference;
}
export interface DataAzurermKubernetesClusterIdentity {
}
export declare function dataAzurermKubernetesClusterIdentityToTerraform(struct?: DataAzurermKubernetesClusterIdentity): any;
export declare class DataAzurermKubernetesClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity {
}
export declare function dataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityToTerraform(struct?: DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity): any;
export declare class DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterIngressApplicationGateway {
}
export declare function dataAzurermKubernetesClusterIngressApplicationGatewayToTerraform(struct?: DataAzurermKubernetesClusterIngressApplicationGateway): any;
export declare class DataAzurermKubernetesClusterIngressApplicationGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterIngressApplicationGateway | undefined;
    set internalValue(value: DataAzurermKubernetesClusterIngressApplicationGateway | undefined);
    get effectiveGatewayId(): string;
    get gatewayId(): string;
    get gatewayName(): string;
    private _ingressApplicationGatewayIdentity;
    get ingressApplicationGatewayIdentity(): DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityList;
    get subnetCidr(): string;
    get subnetId(): string;
}
export declare class DataAzurermKubernetesClusterIngressApplicationGatewayList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterIngressApplicationGatewayOutputReference;
}
export interface DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentity {
}
export declare function dataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentityToTerraform(struct?: DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentity): any;
export declare class DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterKeyVaultSecretsProvider {
}
export declare function dataAzurermKubernetesClusterKeyVaultSecretsProviderToTerraform(struct?: DataAzurermKubernetesClusterKeyVaultSecretsProvider): any;
export declare class DataAzurermKubernetesClusterKeyVaultSecretsProviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterKeyVaultSecretsProvider | undefined;
    set internalValue(value: DataAzurermKubernetesClusterKeyVaultSecretsProvider | undefined);
    private _secretIdentity;
    get secretIdentity(): DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentityList;
    get secretRotationEnabled(): cdktf.IResolvable;
    get secretRotationInterval(): string;
}
export declare class DataAzurermKubernetesClusterKeyVaultSecretsProviderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterKeyVaultSecretsProviderOutputReference;
}
export interface DataAzurermKubernetesClusterKubeAdminConfig {
}
export declare function dataAzurermKubernetesClusterKubeAdminConfigToTerraform(struct?: DataAzurermKubernetesClusterKubeAdminConfig): any;
export declare class DataAzurermKubernetesClusterKubeAdminConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterKubeAdminConfig | undefined;
    set internalValue(value: DataAzurermKubernetesClusterKubeAdminConfig | undefined);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get host(): string;
    get password(): string;
    get username(): string;
}
export declare class DataAzurermKubernetesClusterKubeAdminConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterKubeAdminConfigOutputReference;
}
export interface DataAzurermKubernetesClusterKubeConfig {
}
export declare function dataAzurermKubernetesClusterKubeConfigToTerraform(struct?: DataAzurermKubernetesClusterKubeConfig): any;
export declare class DataAzurermKubernetesClusterKubeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterKubeConfig | undefined;
    set internalValue(value: DataAzurermKubernetesClusterKubeConfig | undefined);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get host(): string;
    get password(): string;
    get username(): string;
}
export declare class DataAzurermKubernetesClusterKubeConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterKubeConfigOutputReference;
}
export interface DataAzurermKubernetesClusterKubeletIdentity {
}
export declare function dataAzurermKubernetesClusterKubeletIdentityToTerraform(struct?: DataAzurermKubernetesClusterKubeletIdentity): any;
export declare class DataAzurermKubernetesClusterKubeletIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterKubeletIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterKubeletIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterKubeletIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterKubeletIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterLinuxProfileSshKey {
}
export declare function dataAzurermKubernetesClusterLinuxProfileSshKeyToTerraform(struct?: DataAzurermKubernetesClusterLinuxProfileSshKey): any;
export declare class DataAzurermKubernetesClusterLinuxProfileSshKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterLinuxProfileSshKey | undefined;
    set internalValue(value: DataAzurermKubernetesClusterLinuxProfileSshKey | undefined);
    get keyData(): string;
}
export declare class DataAzurermKubernetesClusterLinuxProfileSshKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterLinuxProfileSshKeyOutputReference;
}
export interface DataAzurermKubernetesClusterLinuxProfile {
}
export declare function dataAzurermKubernetesClusterLinuxProfileToTerraform(struct?: DataAzurermKubernetesClusterLinuxProfile): any;
export declare class DataAzurermKubernetesClusterLinuxProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterLinuxProfile | undefined;
    set internalValue(value: DataAzurermKubernetesClusterLinuxProfile | undefined);
    get adminUsername(): string;
    private _sshKey;
    get sshKey(): DataAzurermKubernetesClusterLinuxProfileSshKeyList;
}
export declare class DataAzurermKubernetesClusterLinuxProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterLinuxProfileOutputReference;
}
export interface DataAzurermKubernetesClusterNetworkProfile {
}
export declare function dataAzurermKubernetesClusterNetworkProfileToTerraform(struct?: DataAzurermKubernetesClusterNetworkProfile): any;
export declare class DataAzurermKubernetesClusterNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterNetworkProfile | undefined;
    set internalValue(value: DataAzurermKubernetesClusterNetworkProfile | undefined);
    get dnsServiceIp(): string;
    get dockerBridgeCidr(): string;
    get loadBalancerSku(): string;
    get networkPlugin(): string;
    get networkPolicy(): string;
    get podCidr(): string;
    get serviceCidr(): string;
}
export declare class DataAzurermKubernetesClusterNetworkProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterNetworkProfileOutputReference;
}
export interface DataAzurermKubernetesClusterOmsAgentOmsAgentIdentity {
}
export declare function dataAzurermKubernetesClusterOmsAgentOmsAgentIdentityToTerraform(struct?: DataAzurermKubernetesClusterOmsAgentOmsAgentIdentity): any;
export declare class DataAzurermKubernetesClusterOmsAgentOmsAgentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterOmsAgentOmsAgentIdentity | undefined;
    set internalValue(value: DataAzurermKubernetesClusterOmsAgentOmsAgentIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterOmsAgentOmsAgentIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterOmsAgentOmsAgentIdentityOutputReference;
}
export interface DataAzurermKubernetesClusterOmsAgent {
}
export declare function dataAzurermKubernetesClusterOmsAgentToTerraform(struct?: DataAzurermKubernetesClusterOmsAgent): any;
export declare class DataAzurermKubernetesClusterOmsAgentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterOmsAgent | undefined;
    set internalValue(value: DataAzurermKubernetesClusterOmsAgent | undefined);
    get logAnalyticsWorkspaceId(): string;
    private _omsAgentIdentity;
    get omsAgentIdentity(): DataAzurermKubernetesClusterOmsAgentOmsAgentIdentityList;
}
export declare class DataAzurermKubernetesClusterOmsAgentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterOmsAgentOutputReference;
}
export interface DataAzurermKubernetesClusterRoleBasedAccessControlAzureActiveDirectory {
}
export declare function dataAzurermKubernetesClusterRoleBasedAccessControlAzureActiveDirectoryToTerraform(struct?: DataAzurermKubernetesClusterRoleBasedAccessControlAzureActiveDirectory): any;
export declare class DataAzurermKubernetesClusterRoleBasedAccessControlAzureActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterRoleBasedAccessControlAzureActiveDirectory | undefined;
    set internalValue(value: DataAzurermKubernetesClusterRoleBasedAccessControlAzureActiveDirectory | undefined);
    get adminGroupObjectIds(): string[];
    get clientAppId(): string;
    get managed(): cdktf.IResolvable;
    get serverAppId(): string;
    get tenantId(): string;
}
export declare class DataAzurermKubernetesClusterRoleBasedAccessControlAzureActiveDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterRoleBasedAccessControlAzureActiveDirectoryOutputReference;
}
export interface DataAzurermKubernetesClusterRoleBasedAccessControl {
}
export declare function dataAzurermKubernetesClusterRoleBasedAccessControlToTerraform(struct?: DataAzurermKubernetesClusterRoleBasedAccessControl): any;
export declare class DataAzurermKubernetesClusterRoleBasedAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterRoleBasedAccessControl | undefined;
    set internalValue(value: DataAzurermKubernetesClusterRoleBasedAccessControl | undefined);
    private _azureActiveDirectory;
    get azureActiveDirectory(): DataAzurermKubernetesClusterRoleBasedAccessControlAzureActiveDirectoryList;
    get enabled(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterRoleBasedAccessControlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterRoleBasedAccessControlOutputReference;
}
export interface DataAzurermKubernetesClusterServicePrincipal {
}
export declare function dataAzurermKubernetesClusterServicePrincipalToTerraform(struct?: DataAzurermKubernetesClusterServicePrincipal): any;
export declare class DataAzurermKubernetesClusterServicePrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterServicePrincipal | undefined;
    set internalValue(value: DataAzurermKubernetesClusterServicePrincipal | undefined);
    get clientId(): string;
}
export declare class DataAzurermKubernetesClusterServicePrincipalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterServicePrincipalOutputReference;
}
export interface DataAzurermKubernetesClusterWindowsProfile {
}
export declare function dataAzurermKubernetesClusterWindowsProfileToTerraform(struct?: DataAzurermKubernetesClusterWindowsProfile): any;
export declare class DataAzurermKubernetesClusterWindowsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterWindowsProfile | undefined;
    set internalValue(value: DataAzurermKubernetesClusterWindowsProfile | undefined);
    get adminUsername(): string;
}
export declare class DataAzurermKubernetesClusterWindowsProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterWindowsProfileOutputReference;
}
export interface DataAzurermKubernetesClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster#read DataAzurermKubernetesCluster#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKubernetesClusterTimeoutsToTerraform(struct?: DataAzurermKubernetesClusterTimeoutsOutputReference | DataAzurermKubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKubernetesClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKubernetesClusterTimeouts | undefined;
    set internalValue(value: DataAzurermKubernetesClusterTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster azurerm_kubernetes_cluster}
*/
export declare class DataAzurermKubernetesCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_kubernetes_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster azurerm_kubernetes_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKubernetesClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKubernetesClusterConfig);
    private _aciConnectorLinux;
    get aciConnectorLinux(): DataAzurermKubernetesClusterAciConnectorLinuxList;
    private _addonProfile;
    get addonProfile(): DataAzurermKubernetesClusterAddonProfileList;
    private _agentPoolProfile;
    get agentPoolProfile(): DataAzurermKubernetesClusterAgentPoolProfileList;
    get apiServerAuthorizedIpRanges(): string[];
    private _azureActiveDirectoryRoleBasedAccessControl;
    get azureActiveDirectoryRoleBasedAccessControl(): DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlList;
    get azurePolicyEnabled(): cdktf.IResolvable;
    get diskEncryptionSetId(): string;
    get dnsPrefix(): string;
    get fqdn(): string;
    get httpApplicationRoutingEnabled(): cdktf.IResolvable;
    get httpApplicationRoutingZoneName(): string;
    get id(): string;
    private _identity;
    get identity(): DataAzurermKubernetesClusterIdentityList;
    private _ingressApplicationGateway;
    get ingressApplicationGateway(): DataAzurermKubernetesClusterIngressApplicationGatewayList;
    private _keyVaultSecretsProvider;
    get keyVaultSecretsProvider(): DataAzurermKubernetesClusterKeyVaultSecretsProviderList;
    private _kubeAdminConfig;
    get kubeAdminConfig(): DataAzurermKubernetesClusterKubeAdminConfigList;
    get kubeAdminConfigRaw(): string;
    private _kubeConfig;
    get kubeConfig(): DataAzurermKubernetesClusterKubeConfigList;
    get kubeConfigRaw(): string;
    private _kubeletIdentity;
    get kubeletIdentity(): DataAzurermKubernetesClusterKubeletIdentityList;
    get kubernetesVersion(): string;
    private _linuxProfile;
    get linuxProfile(): DataAzurermKubernetesClusterLinuxProfileList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkProfile;
    get networkProfile(): DataAzurermKubernetesClusterNetworkProfileList;
    get nodeResourceGroup(): string;
    private _omsAgent;
    get omsAgent(): DataAzurermKubernetesClusterOmsAgentList;
    get openServiceMeshEnabled(): cdktf.IResolvable;
    get privateClusterEnabled(): cdktf.IResolvable;
    get privateFqdn(): string;
    get privateLinkEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _roleBasedAccessControl;
    get roleBasedAccessControl(): DataAzurermKubernetesClusterRoleBasedAccessControlList;
    get roleBasedAccessControlEnabled(): cdktf.IResolvable;
    private _servicePrincipal;
    get servicePrincipal(): DataAzurermKubernetesClusterServicePrincipalList;
    tags(key: string): string | cdktf.IResolvable;
    private _windowsProfile;
    get windowsProfile(): DataAzurermKubernetesClusterWindowsProfileList;
    private _timeouts;
    get timeouts(): DataAzurermKubernetesClusterTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKubernetesClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKubernetesClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
