import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMonitorDiagnosticCategoriesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_diagnostic_categories#resource_id DataAzurermMonitorDiagnosticCategories#resource_id}
    */
    readonly resourceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_diagnostic_categories#timeouts DataAzurermMonitorDiagnosticCategories#timeouts}
    */
    readonly timeouts?: DataAzurermMonitorDiagnosticCategoriesTimeouts;
}
export interface DataAzurermMonitorDiagnosticCategoriesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_diagnostic_categories#read DataAzurermMonitorDiagnosticCategories#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMonitorDiagnosticCategoriesTimeoutsToTerraform(struct?: DataAzurermMonitorDiagnosticCategoriesTimeoutsOutputReference | DataAzurermMonitorDiagnosticCategoriesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMonitorDiagnosticCategoriesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMonitorDiagnosticCategoriesTimeouts | undefined;
    set internalValue(value: DataAzurermMonitorDiagnosticCategoriesTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_diagnostic_categories azurerm_monitor_diagnostic_categories}
*/
export declare class DataAzurermMonitorDiagnosticCategories extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_monitor_diagnostic_categories";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_diagnostic_categories azurerm_monitor_diagnostic_categories} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMonitorDiagnosticCategoriesConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorDiagnosticCategoriesConfig);
    get id(): string;
    get logs(): string[];
    get metrics(): string[];
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermMonitorDiagnosticCategoriesTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMonitorDiagnosticCategoriesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMonitorDiagnosticCategoriesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
