import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNotificationHubNamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub_namespace#name DataAzurermNotificationHubNamespace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub_namespace#resource_group_name DataAzurermNotificationHubNamespace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub_namespace#timeouts DataAzurermNotificationHubNamespace#timeouts}
    */
    readonly timeouts?: DataAzurermNotificationHubNamespaceTimeouts;
}
export interface DataAzurermNotificationHubNamespaceSku {
}
export declare function dataAzurermNotificationHubNamespaceSkuToTerraform(struct?: DataAzurermNotificationHubNamespaceSku): any;
export declare class DataAzurermNotificationHubNamespaceSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNotificationHubNamespaceSku | undefined;
    set internalValue(value: DataAzurermNotificationHubNamespaceSku | undefined);
    get name(): string;
}
export declare class DataAzurermNotificationHubNamespaceSkuList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNotificationHubNamespaceSkuOutputReference;
}
export interface DataAzurermNotificationHubNamespaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub_namespace#read DataAzurermNotificationHubNamespace#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNotificationHubNamespaceTimeoutsToTerraform(struct?: DataAzurermNotificationHubNamespaceTimeoutsOutputReference | DataAzurermNotificationHubNamespaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNotificationHubNamespaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNotificationHubNamespaceTimeouts | undefined;
    set internalValue(value: DataAzurermNotificationHubNamespaceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub_namespace azurerm_notification_hub_namespace}
*/
export declare class DataAzurermNotificationHubNamespace extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_notification_hub_namespace";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub_namespace azurerm_notification_hub_namespace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNotificationHubNamespaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNotificationHubNamespaceConfig);
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get namespaceType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get servicebusEndpoint(): string;
    private _sku;
    get sku(): DataAzurermNotificationHubNamespaceSkuList;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermNotificationHubNamespaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNotificationHubNamespaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermNotificationHubNamespaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
