import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateLinkServiceEndpointConnectionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#resource_group_name DataAzurermPrivateLinkServiceEndpointConnections#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#service_id DataAzurermPrivateLinkServiceEndpointConnections#service_id}
    */
    readonly serviceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#timeouts DataAzurermPrivateLinkServiceEndpointConnections#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts;
}
export interface DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnections {
}
export declare function dataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnectionsToTerraform(struct?: DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnections): any;
export declare class DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnections | undefined;
    set internalValue(value: DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnections | undefined);
    get actionRequired(): string;
    get connectionId(): string;
    get connectionName(): string;
    get description(): string;
    get privateEndpointId(): string;
    get privateEndpointName(): string;
    get status(): string;
}
export declare class DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnectionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnectionsOutputReference;
}
export interface DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#read DataAzurermPrivateLinkServiceEndpointConnections#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsToTerraform(struct?: DataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsOutputReference | DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts | undefined;
    set internalValue(value: DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections azurerm_private_link_service_endpoint_connections}
*/
export declare class DataAzurermPrivateLinkServiceEndpointConnections extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_private_link_service_endpoint_connections";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections azurerm_private_link_service_endpoint_connections} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateLinkServiceEndpointConnectionsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateLinkServiceEndpointConnectionsConfig);
    get id(): string;
    get location(): string;
    private _privateEndpointConnections;
    get privateEndpointConnections(): DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnectionsList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    get serviceName(): string;
    private _timeouts;
    get timeouts(): DataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
