import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermServicebusNamespaceAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace_authorization_rule#name DataAzurermServicebusNamespaceAuthorizationRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace_authorization_rule#namespace_id DataAzurermServicebusNamespaceAuthorizationRule#namespace_id}
    */
    readonly namespaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace_authorization_rule#namespace_name DataAzurermServicebusNamespaceAuthorizationRule#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace_authorization_rule#resource_group_name DataAzurermServicebusNamespaceAuthorizationRule#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace_authorization_rule#timeouts DataAzurermServicebusNamespaceAuthorizationRule#timeouts}
    */
    readonly timeouts?: DataAzurermServicebusNamespaceAuthorizationRuleTimeouts;
}
export interface DataAzurermServicebusNamespaceAuthorizationRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace_authorization_rule#read DataAzurermServicebusNamespaceAuthorizationRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermServicebusNamespaceAuthorizationRuleTimeoutsToTerraform(struct?: DataAzurermServicebusNamespaceAuthorizationRuleTimeoutsOutputReference | DataAzurermServicebusNamespaceAuthorizationRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermServicebusNamespaceAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermServicebusNamespaceAuthorizationRuleTimeouts | undefined;
    set internalValue(value: DataAzurermServicebusNamespaceAuthorizationRuleTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace_authorization_rule azurerm_servicebus_namespace_authorization_rule}
*/
export declare class DataAzurermServicebusNamespaceAuthorizationRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_servicebus_namespace_authorization_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace_authorization_rule azurerm_servicebus_namespace_authorization_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermServicebusNamespaceAuthorizationRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusNamespaceAuthorizationRuleConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    resetNamespaceId(): void;
    get namespaceIdInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryConnectionStringAlias(): string;
    get primaryKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    get secondaryConnectionString(): string;
    get secondaryConnectionStringAlias(): string;
    get secondaryKey(): string;
    private _timeouts;
    get timeouts(): DataAzurermServicebusNamespaceAuthorizationRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermServicebusNamespaceAuthorizationRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermServicebusNamespaceAuthorizationRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
