import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSpatialAnchorsAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spatial_anchors_account#name DataAzurermSpatialAnchorsAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spatial_anchors_account#resource_group_name DataAzurermSpatialAnchorsAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spatial_anchors_account#timeouts DataAzurermSpatialAnchorsAccount#timeouts}
    */
    readonly timeouts?: DataAzurermSpatialAnchorsAccountTimeouts;
}
export interface DataAzurermSpatialAnchorsAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spatial_anchors_account#read DataAzurermSpatialAnchorsAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSpatialAnchorsAccountTimeoutsToTerraform(struct?: DataAzurermSpatialAnchorsAccountTimeoutsOutputReference | DataAzurermSpatialAnchorsAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSpatialAnchorsAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSpatialAnchorsAccountTimeouts | undefined;
    set internalValue(value: DataAzurermSpatialAnchorsAccountTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/spatial_anchors_account azurerm_spatial_anchors_account}
*/
export declare class DataAzurermSpatialAnchorsAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_spatial_anchors_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/spatial_anchors_account azurerm_spatial_anchors_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSpatialAnchorsAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSpatialAnchorsAccountConfig);
    get accountDomain(): string;
    get accountId(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermSpatialAnchorsAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSpatialAnchorsAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSpatialAnchorsAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
