import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLakeAnalyticsFirewallRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule#account_name DataLakeAnalyticsFirewallRule#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule#end_ip_address DataLakeAnalyticsFirewallRule#end_ip_address}
    */
    readonly endIpAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule#name DataLakeAnalyticsFirewallRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule#resource_group_name DataLakeAnalyticsFirewallRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule#start_ip_address DataLakeAnalyticsFirewallRule#start_ip_address}
    */
    readonly startIpAddress: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule#timeouts DataLakeAnalyticsFirewallRule#timeouts}
    */
    readonly timeouts?: DataLakeAnalyticsFirewallRuleTimeouts;
}
export interface DataLakeAnalyticsFirewallRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule#create DataLakeAnalyticsFirewallRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule#delete DataLakeAnalyticsFirewallRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule#read DataLakeAnalyticsFirewallRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule#update DataLakeAnalyticsFirewallRule#update}
    */
    readonly update?: string;
}
export declare function dataLakeAnalyticsFirewallRuleTimeoutsToTerraform(struct?: DataLakeAnalyticsFirewallRuleTimeoutsOutputReference | DataLakeAnalyticsFirewallRuleTimeouts | cdktf.IResolvable): any;
export declare class DataLakeAnalyticsFirewallRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLakeAnalyticsFirewallRuleTimeouts | undefined;
    set internalValue(value: DataLakeAnalyticsFirewallRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule azurerm_data_lake_analytics_firewall_rule}
*/
export declare class DataLakeAnalyticsFirewallRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_lake_analytics_firewall_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_firewall_rule azurerm_data_lake_analytics_firewall_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLakeAnalyticsFirewallRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataLakeAnalyticsFirewallRuleConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _endIpAddress?;
    get endIpAddress(): string;
    set endIpAddress(value: string);
    get endIpAddressInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _startIpAddress?;
    get startIpAddress(): string;
    set startIpAddress(value: string);
    get startIpAddressInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataLakeAnalyticsFirewallRuleTimeoutsOutputReference;
    putTimeouts(value: DataLakeAnalyticsFirewallRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataLakeAnalyticsFirewallRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
