import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsCaaRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#name DnsCaaRecord#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#resource_group_name DnsCaaRecord#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#tags DnsCaaRecord#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#ttl DnsCaaRecord#ttl}
    */
    readonly ttl: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#zone_name DnsCaaRecord#zone_name}
    */
    readonly zoneName: string;
    /**
    * record block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#record DnsCaaRecord#record}
    */
    readonly record: DnsCaaRecordRecord[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#timeouts DnsCaaRecord#timeouts}
    */
    readonly timeouts?: DnsCaaRecordTimeouts;
}
export interface DnsCaaRecordRecord {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#flags DnsCaaRecord#flags}
    */
    readonly flags: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#tag DnsCaaRecord#tag}
    */
    readonly tag: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#value DnsCaaRecord#value}
    */
    readonly value: string;
}
export declare function dnsCaaRecordRecordToTerraform(struct?: DnsCaaRecordRecord | cdktf.IResolvable): any;
export interface DnsCaaRecordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#create DnsCaaRecord#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#delete DnsCaaRecord#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#read DnsCaaRecord#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record#update DnsCaaRecord#update}
    */
    readonly update?: string;
}
export declare function dnsCaaRecordTimeoutsToTerraform(struct?: DnsCaaRecordTimeoutsOutputReference | DnsCaaRecordTimeouts | cdktf.IResolvable): any;
export declare class DnsCaaRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsCaaRecordTimeouts | undefined;
    set internalValue(value: DnsCaaRecordTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record azurerm_dns_caa_record}
*/
export declare class DnsCaaRecord extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dns_caa_record";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dns_caa_record azurerm_dns_caa_record} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsCaaRecordConfig
    */
    constructor(scope: Construct, id: string, config: DnsCaaRecordConfig);
    get fqdn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    get ttlInput(): number | undefined;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    get zoneNameInput(): string | undefined;
    private _record?;
    get record(): DnsCaaRecordRecord[] | cdktf.IResolvable;
    set record(value: DnsCaaRecordRecord[] | cdktf.IResolvable);
    get recordInput(): cdktf.IResolvable | DnsCaaRecordRecord[] | undefined;
    private _timeouts;
    get timeouts(): DnsCaaRecordTimeoutsOutputReference;
    putTimeouts(value: DnsCaaRecordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DnsCaaRecordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
