import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FrontdoorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend_pools_send_receive_timeout_seconds Frontdoor#backend_pools_send_receive_timeout_seconds}
    */
    readonly backendPoolsSendReceiveTimeoutSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#enforce_backend_pools_certificate_name_check Frontdoor#enforce_backend_pools_certificate_name_check}
    */
    readonly enforceBackendPoolsCertificateNameCheck: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#friendly_name Frontdoor#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#load_balancer_enabled Frontdoor#load_balancer_enabled}
    */
    readonly loadBalancerEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#location Frontdoor#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#resource_group_name Frontdoor#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#tags Frontdoor#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * backend_pool block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend_pool Frontdoor#backend_pool}
    */
    readonly backendPool: FrontdoorBackendPool[] | cdktf.IResolvable;
    /**
    * backend_pool_health_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend_pool_health_probe Frontdoor#backend_pool_health_probe}
    */
    readonly backendPoolHealthProbe: FrontdoorBackendPoolHealthProbe[] | cdktf.IResolvable;
    /**
    * backend_pool_load_balancing block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend_pool_load_balancing Frontdoor#backend_pool_load_balancing}
    */
    readonly backendPoolLoadBalancing: FrontdoorBackendPoolLoadBalancing[] | cdktf.IResolvable;
    /**
    * frontend_endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#frontend_endpoint Frontdoor#frontend_endpoint}
    */
    readonly frontendEndpoint: FrontdoorFrontendEndpoint[] | cdktf.IResolvable;
    /**
    * routing_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#routing_rule Frontdoor#routing_rule}
    */
    readonly routingRule: FrontdoorRoutingRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#timeouts Frontdoor#timeouts}
    */
    readonly timeouts?: FrontdoorTimeouts;
}
export interface FrontdoorExplicitResourceOrder {
}
export declare function frontdoorExplicitResourceOrderToTerraform(struct?: FrontdoorExplicitResourceOrder): any;
export declare class FrontdoorExplicitResourceOrderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorExplicitResourceOrder | undefined;
    set internalValue(value: FrontdoorExplicitResourceOrder | undefined);
    get backendPoolHealthProbeIds(): string[];
    get backendPoolIds(): string[];
    get backendPoolLoadBalancingIds(): string[];
    get frontendEndpointIds(): string[];
    get routingRuleIds(): string[];
}
export declare class FrontdoorExplicitResourceOrderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorExplicitResourceOrderOutputReference;
}
export interface FrontdoorBackendPoolBackend {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#address Frontdoor#address}
    */
    readonly address: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#enabled Frontdoor#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#host_header Frontdoor#host_header}
    */
    readonly hostHeader: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#http_port Frontdoor#http_port}
    */
    readonly httpPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#https_port Frontdoor#https_port}
    */
    readonly httpsPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#priority Frontdoor#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#weight Frontdoor#weight}
    */
    readonly weight?: number;
}
export declare function frontdoorBackendPoolBackendToTerraform(struct?: FrontdoorBackendPoolBackend | cdktf.IResolvable): any;
export interface FrontdoorBackendPool {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#health_probe_name Frontdoor#health_probe_name}
    */
    readonly healthProbeName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#load_balancing_name Frontdoor#load_balancing_name}
    */
    readonly loadBalancingName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * backend block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend Frontdoor#backend}
    */
    readonly backend: FrontdoorBackendPoolBackend[] | cdktf.IResolvable;
}
export declare function frontdoorBackendPoolToTerraform(struct?: FrontdoorBackendPool | cdktf.IResolvable): any;
export interface FrontdoorBackendPoolHealthProbe {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#enabled Frontdoor#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#interval_in_seconds Frontdoor#interval_in_seconds}
    */
    readonly intervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#path Frontdoor#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#probe_method Frontdoor#probe_method}
    */
    readonly probeMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#protocol Frontdoor#protocol}
    */
    readonly protocol?: string;
}
export declare function frontdoorBackendPoolHealthProbeToTerraform(struct?: FrontdoorBackendPoolHealthProbe | cdktf.IResolvable): any;
export interface FrontdoorBackendPoolLoadBalancing {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#additional_latency_milliseconds Frontdoor#additional_latency_milliseconds}
    */
    readonly additionalLatencyMilliseconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#sample_size Frontdoor#sample_size}
    */
    readonly sampleSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#successful_samples_required Frontdoor#successful_samples_required}
    */
    readonly successfulSamplesRequired?: number;
}
export declare function frontdoorBackendPoolLoadBalancingToTerraform(struct?: FrontdoorBackendPoolLoadBalancing | cdktf.IResolvable): any;
export interface FrontdoorFrontendEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#host_name Frontdoor#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#session_affinity_enabled Frontdoor#session_affinity_enabled}
    */
    readonly sessionAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#session_affinity_ttl_seconds Frontdoor#session_affinity_ttl_seconds}
    */
    readonly sessionAffinityTtlSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#web_application_firewall_policy_link_id Frontdoor#web_application_firewall_policy_link_id}
    */
    readonly webApplicationFirewallPolicyLinkId?: string;
}
export declare function frontdoorFrontendEndpointToTerraform(struct?: FrontdoorFrontendEndpoint | cdktf.IResolvable): any;
export interface FrontdoorRoutingRuleForwardingConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#backend_pool_name Frontdoor#backend_pool_name}
    */
    readonly backendPoolName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#cache_duration Frontdoor#cache_duration}
    */
    readonly cacheDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#cache_enabled Frontdoor#cache_enabled}
    */
    readonly cacheEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#cache_query_parameter_strip_directive Frontdoor#cache_query_parameter_strip_directive}
    */
    readonly cacheQueryParameterStripDirective?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#cache_query_parameters Frontdoor#cache_query_parameters}
    */
    readonly cacheQueryParameters?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#cache_use_dynamic_compression Frontdoor#cache_use_dynamic_compression}
    */
    readonly cacheUseDynamicCompression?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#custom_forwarding_path Frontdoor#custom_forwarding_path}
    */
    readonly customForwardingPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#forwarding_protocol Frontdoor#forwarding_protocol}
    */
    readonly forwardingProtocol?: string;
}
export declare function frontdoorRoutingRuleForwardingConfigurationToTerraform(struct?: FrontdoorRoutingRuleForwardingConfigurationOutputReference | FrontdoorRoutingRuleForwardingConfiguration): any;
export declare class FrontdoorRoutingRuleForwardingConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorRoutingRuleForwardingConfiguration | undefined;
    set internalValue(value: FrontdoorRoutingRuleForwardingConfiguration | undefined);
    private _backendPoolName?;
    get backendPoolName(): string;
    set backendPoolName(value: string);
    get backendPoolNameInput(): string | undefined;
    private _cacheDuration?;
    get cacheDuration(): string;
    set cacheDuration(value: string);
    resetCacheDuration(): void;
    get cacheDurationInput(): string | undefined;
    private _cacheEnabled?;
    get cacheEnabled(): boolean | cdktf.IResolvable;
    set cacheEnabled(value: boolean | cdktf.IResolvable);
    resetCacheEnabled(): void;
    get cacheEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cacheQueryParameterStripDirective?;
    get cacheQueryParameterStripDirective(): string;
    set cacheQueryParameterStripDirective(value: string);
    resetCacheQueryParameterStripDirective(): void;
    get cacheQueryParameterStripDirectiveInput(): string | undefined;
    private _cacheQueryParameters?;
    get cacheQueryParameters(): string[];
    set cacheQueryParameters(value: string[]);
    resetCacheQueryParameters(): void;
    get cacheQueryParametersInput(): string[] | undefined;
    private _cacheUseDynamicCompression?;
    get cacheUseDynamicCompression(): boolean | cdktf.IResolvable;
    set cacheUseDynamicCompression(value: boolean | cdktf.IResolvable);
    resetCacheUseDynamicCompression(): void;
    get cacheUseDynamicCompressionInput(): boolean | cdktf.IResolvable | undefined;
    private _customForwardingPath?;
    get customForwardingPath(): string;
    set customForwardingPath(value: string);
    resetCustomForwardingPath(): void;
    get customForwardingPathInput(): string | undefined;
    private _forwardingProtocol?;
    get forwardingProtocol(): string;
    set forwardingProtocol(value: string);
    resetForwardingProtocol(): void;
    get forwardingProtocolInput(): string | undefined;
}
export interface FrontdoorRoutingRuleRedirectConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#custom_fragment Frontdoor#custom_fragment}
    */
    readonly customFragment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#custom_host Frontdoor#custom_host}
    */
    readonly customHost?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#custom_path Frontdoor#custom_path}
    */
    readonly customPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#custom_query_string Frontdoor#custom_query_string}
    */
    readonly customQueryString?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#redirect_protocol Frontdoor#redirect_protocol}
    */
    readonly redirectProtocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#redirect_type Frontdoor#redirect_type}
    */
    readonly redirectType: string;
}
export declare function frontdoorRoutingRuleRedirectConfigurationToTerraform(struct?: FrontdoorRoutingRuleRedirectConfigurationOutputReference | FrontdoorRoutingRuleRedirectConfiguration): any;
export declare class FrontdoorRoutingRuleRedirectConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorRoutingRuleRedirectConfiguration | undefined;
    set internalValue(value: FrontdoorRoutingRuleRedirectConfiguration | undefined);
    private _customFragment?;
    get customFragment(): string;
    set customFragment(value: string);
    resetCustomFragment(): void;
    get customFragmentInput(): string | undefined;
    private _customHost?;
    get customHost(): string;
    set customHost(value: string);
    resetCustomHost(): void;
    get customHostInput(): string | undefined;
    private _customPath?;
    get customPath(): string;
    set customPath(value: string);
    resetCustomPath(): void;
    get customPathInput(): string | undefined;
    private _customQueryString?;
    get customQueryString(): string;
    set customQueryString(value: string);
    resetCustomQueryString(): void;
    get customQueryStringInput(): string | undefined;
    private _redirectProtocol?;
    get redirectProtocol(): string;
    set redirectProtocol(value: string);
    get redirectProtocolInput(): string | undefined;
    private _redirectType?;
    get redirectType(): string;
    set redirectType(value: string);
    get redirectTypeInput(): string | undefined;
}
export interface FrontdoorRoutingRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#accepted_protocols Frontdoor#accepted_protocols}
    */
    readonly acceptedProtocols: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#enabled Frontdoor#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#frontend_endpoints Frontdoor#frontend_endpoints}
    */
    readonly frontendEndpoints: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#patterns_to_match Frontdoor#patterns_to_match}
    */
    readonly patternsToMatch: string[];
    /**
    * forwarding_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#forwarding_configuration Frontdoor#forwarding_configuration}
    */
    readonly forwardingConfiguration?: FrontdoorRoutingRuleForwardingConfiguration;
    /**
    * redirect_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#redirect_configuration Frontdoor#redirect_configuration}
    */
    readonly redirectConfiguration?: FrontdoorRoutingRuleRedirectConfiguration;
}
export declare function frontdoorRoutingRuleToTerraform(struct?: FrontdoorRoutingRule | cdktf.IResolvable): any;
export interface FrontdoorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#create Frontdoor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#delete Frontdoor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#read Frontdoor#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor#update Frontdoor#update}
    */
    readonly update?: string;
}
export declare function frontdoorTimeoutsToTerraform(struct?: FrontdoorTimeoutsOutputReference | FrontdoorTimeouts | cdktf.IResolvable): any;
export declare class FrontdoorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorTimeouts | undefined;
    set internalValue(value: FrontdoorTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor azurerm_frontdoor}
*/
export declare class Frontdoor extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_frontdoor";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor azurerm_frontdoor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FrontdoorConfig
    */
    constructor(scope: Construct, id: string, config: FrontdoorConfig);
    backendPoolHealthProbes(key: string): string | cdktf.IResolvable;
    backendPoolLoadBalancingSettings(key: string): string | cdktf.IResolvable;
    backendPools(key: string): string | cdktf.IResolvable;
    private _backendPoolsSendReceiveTimeoutSeconds?;
    get backendPoolsSendReceiveTimeoutSeconds(): number;
    set backendPoolsSendReceiveTimeoutSeconds(value: number);
    resetBackendPoolsSendReceiveTimeoutSeconds(): void;
    get backendPoolsSendReceiveTimeoutSecondsInput(): number | undefined;
    get cname(): string;
    private _enforceBackendPoolsCertificateNameCheck?;
    get enforceBackendPoolsCertificateNameCheck(): boolean | cdktf.IResolvable;
    set enforceBackendPoolsCertificateNameCheck(value: boolean | cdktf.IResolvable);
    get enforceBackendPoolsCertificateNameCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _explicitResourceOrder;
    get explicitResourceOrder(): FrontdoorExplicitResourceOrderList;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    frontendEndpoints(key: string): string | cdktf.IResolvable;
    get headerFrontdoorId(): string;
    get id(): string;
    private _loadBalancerEnabled?;
    get loadBalancerEnabled(): boolean | cdktf.IResolvable;
    set loadBalancerEnabled(value: boolean | cdktf.IResolvable);
    resetLoadBalancerEnabled(): void;
    get loadBalancerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    routingRules(key: string): string | cdktf.IResolvable;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _backendPool?;
    get backendPool(): FrontdoorBackendPool[] | cdktf.IResolvable;
    set backendPool(value: FrontdoorBackendPool[] | cdktf.IResolvable);
    get backendPoolInput(): cdktf.IResolvable | FrontdoorBackendPool[] | undefined;
    private _backendPoolHealthProbe?;
    get backendPoolHealthProbe(): FrontdoorBackendPoolHealthProbe[] | cdktf.IResolvable;
    set backendPoolHealthProbe(value: FrontdoorBackendPoolHealthProbe[] | cdktf.IResolvable);
    get backendPoolHealthProbeInput(): cdktf.IResolvable | FrontdoorBackendPoolHealthProbe[] | undefined;
    private _backendPoolLoadBalancing?;
    get backendPoolLoadBalancing(): FrontdoorBackendPoolLoadBalancing[] | cdktf.IResolvable;
    set backendPoolLoadBalancing(value: FrontdoorBackendPoolLoadBalancing[] | cdktf.IResolvable);
    get backendPoolLoadBalancingInput(): cdktf.IResolvable | FrontdoorBackendPoolLoadBalancing[] | undefined;
    private _frontendEndpoint?;
    get frontendEndpoint(): FrontdoorFrontendEndpoint[] | cdktf.IResolvable;
    set frontendEndpoint(value: FrontdoorFrontendEndpoint[] | cdktf.IResolvable);
    get frontendEndpointInput(): cdktf.IResolvable | FrontdoorFrontendEndpoint[] | undefined;
    private _routingRule?;
    get routingRule(): FrontdoorRoutingRule[] | cdktf.IResolvable;
    set routingRule(value: FrontdoorRoutingRule[] | cdktf.IResolvable);
    get routingRuleInput(): cdktf.IResolvable | FrontdoorRoutingRule[] | undefined;
    private _timeouts;
    get timeouts(): FrontdoorTimeoutsOutputReference;
    putTimeouts(value: FrontdoorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FrontdoorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
