import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KeyVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#access_policy KeyVault#access_policy}
    */
    readonly accessPolicy?: KeyVaultAccessPolicy[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#enable_rbac_authorization KeyVault#enable_rbac_authorization}
    */
    readonly enableRbacAuthorization?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#enabled_for_deployment KeyVault#enabled_for_deployment}
    */
    readonly enabledForDeployment?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#enabled_for_disk_encryption KeyVault#enabled_for_disk_encryption}
    */
    readonly enabledForDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#enabled_for_template_deployment KeyVault#enabled_for_template_deployment}
    */
    readonly enabledForTemplateDeployment?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#location KeyVault#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#name KeyVault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#purge_protection_enabled KeyVault#purge_protection_enabled}
    */
    readonly purgeProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#resource_group_name KeyVault#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#sku_name KeyVault#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#soft_delete_enabled KeyVault#soft_delete_enabled}
    */
    readonly softDeleteEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#soft_delete_retention_days KeyVault#soft_delete_retention_days}
    */
    readonly softDeleteRetentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#tags KeyVault#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#tenant_id KeyVault#tenant_id}
    */
    readonly tenantId: string;
    /**
    * contact block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#contact KeyVault#contact}
    */
    readonly contact?: KeyVaultContact[] | cdktf.IResolvable;
    /**
    * network_acls block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#network_acls KeyVault#network_acls}
    */
    readonly networkAcls?: KeyVaultNetworkAcls;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#timeouts KeyVault#timeouts}
    */
    readonly timeouts?: KeyVaultTimeouts;
}
export interface KeyVaultAccessPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#application_id KeyVault#application_id}
    */
    readonly applicationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#certificate_permissions KeyVault#certificate_permissions}
    */
    readonly certificatePermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#key_permissions KeyVault#key_permissions}
    */
    readonly keyPermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#object_id KeyVault#object_id}
    */
    readonly objectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#secret_permissions KeyVault#secret_permissions}
    */
    readonly secretPermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#storage_permissions KeyVault#storage_permissions}
    */
    readonly storagePermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#tenant_id KeyVault#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function keyVaultAccessPolicyToTerraform(struct?: KeyVaultAccessPolicy | cdktf.IResolvable): any;
export interface KeyVaultContact {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#email KeyVault#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#name KeyVault#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#phone KeyVault#phone}
    */
    readonly phone?: string;
}
export declare function keyVaultContactToTerraform(struct?: KeyVaultContact | cdktf.IResolvable): any;
export interface KeyVaultNetworkAcls {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#bypass KeyVault#bypass}
    */
    readonly bypass: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#default_action KeyVault#default_action}
    */
    readonly defaultAction: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#ip_rules KeyVault#ip_rules}
    */
    readonly ipRules?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#virtual_network_subnet_ids KeyVault#virtual_network_subnet_ids}
    */
    readonly virtualNetworkSubnetIds?: string[];
}
export declare function keyVaultNetworkAclsToTerraform(struct?: KeyVaultNetworkAclsOutputReference | KeyVaultNetworkAcls): any;
export declare class KeyVaultNetworkAclsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultNetworkAcls | undefined;
    set internalValue(value: KeyVaultNetworkAcls | undefined);
    private _bypass?;
    get bypass(): string;
    set bypass(value: string);
    get bypassInput(): string | undefined;
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    get defaultActionInput(): string | undefined;
    private _ipRules?;
    get ipRules(): string[];
    set ipRules(value: string[]);
    resetIpRules(): void;
    get ipRulesInput(): string[] | undefined;
    private _virtualNetworkSubnetIds?;
    get virtualNetworkSubnetIds(): string[];
    set virtualNetworkSubnetIds(value: string[]);
    resetVirtualNetworkSubnetIds(): void;
    get virtualNetworkSubnetIdsInput(): string[] | undefined;
}
export interface KeyVaultTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#create KeyVault#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#delete KeyVault#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#read KeyVault#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#update KeyVault#update}
    */
    readonly update?: string;
}
export declare function keyVaultTimeoutsToTerraform(struct?: KeyVaultTimeoutsOutputReference | KeyVaultTimeouts | cdktf.IResolvable): any;
export declare class KeyVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultTimeouts | undefined;
    set internalValue(value: KeyVaultTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault azurerm_key_vault}
*/
export declare class KeyVault extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_key_vault";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault azurerm_key_vault} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KeyVaultConfig
    */
    constructor(scope: Construct, id: string, config: KeyVaultConfig);
    private _accessPolicy?;
    get accessPolicy(): KeyVaultAccessPolicy[] | cdktf.IResolvable;
    set accessPolicy(value: KeyVaultAccessPolicy[] | cdktf.IResolvable);
    resetAccessPolicy(): void;
    get accessPolicyInput(): cdktf.IResolvable | KeyVaultAccessPolicy[] | undefined;
    private _enableRbacAuthorization?;
    get enableRbacAuthorization(): boolean | cdktf.IResolvable;
    set enableRbacAuthorization(value: boolean | cdktf.IResolvable);
    resetEnableRbacAuthorization(): void;
    get enableRbacAuthorizationInput(): boolean | cdktf.IResolvable | undefined;
    private _enabledForDeployment?;
    get enabledForDeployment(): boolean | cdktf.IResolvable;
    set enabledForDeployment(value: boolean | cdktf.IResolvable);
    resetEnabledForDeployment(): void;
    get enabledForDeploymentInput(): boolean | cdktf.IResolvable | undefined;
    private _enabledForDiskEncryption?;
    get enabledForDiskEncryption(): boolean | cdktf.IResolvable;
    set enabledForDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnabledForDiskEncryption(): void;
    get enabledForDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _enabledForTemplateDeployment?;
    get enabledForTemplateDeployment(): boolean | cdktf.IResolvable;
    set enabledForTemplateDeployment(value: boolean | cdktf.IResolvable);
    resetEnabledForTemplateDeployment(): void;
    get enabledForTemplateDeploymentInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _purgeProtectionEnabled?;
    get purgeProtectionEnabled(): boolean | cdktf.IResolvable;
    set purgeProtectionEnabled(value: boolean | cdktf.IResolvable);
    resetPurgeProtectionEnabled(): void;
    get purgeProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _softDeleteEnabled?;
    get softDeleteEnabled(): boolean | cdktf.IResolvable;
    set softDeleteEnabled(value: boolean | cdktf.IResolvable);
    resetSoftDeleteEnabled(): void;
    get softDeleteEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _softDeleteRetentionDays?;
    get softDeleteRetentionDays(): number;
    set softDeleteRetentionDays(value: number);
    resetSoftDeleteRetentionDays(): void;
    get softDeleteRetentionDaysInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
    get vaultUri(): string;
    private _contact?;
    get contact(): KeyVaultContact[] | cdktf.IResolvable;
    set contact(value: KeyVaultContact[] | cdktf.IResolvable);
    resetContact(): void;
    get contactInput(): cdktf.IResolvable | KeyVaultContact[] | undefined;
    private _networkAcls;
    get networkAcls(): KeyVaultNetworkAclsOutputReference;
    putNetworkAcls(value: KeyVaultNetworkAcls): void;
    resetNetworkAcls(): void;
    get networkAclsInput(): KeyVaultNetworkAcls | undefined;
    private _timeouts;
    get timeouts(): KeyVaultTimeoutsOutputReference;
    putTimeouts(value: KeyVaultTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): KeyVaultTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
