import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KustoEventgridDataConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#blob_storage_event_type KustoEventgridDataConnection#blob_storage_event_type}
    */
    readonly blobStorageEventType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#cluster_name KustoEventgridDataConnection#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#data_format KustoEventgridDataConnection#data_format}
    */
    readonly dataFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#database_name KustoEventgridDataConnection#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#eventhub_consumer_group_name KustoEventgridDataConnection#eventhub_consumer_group_name}
    */
    readonly eventhubConsumerGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#eventhub_id KustoEventgridDataConnection#eventhub_id}
    */
    readonly eventhubId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#location KustoEventgridDataConnection#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#mapping_rule_name KustoEventgridDataConnection#mapping_rule_name}
    */
    readonly mappingRuleName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#name KustoEventgridDataConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#resource_group_name KustoEventgridDataConnection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#skip_first_record KustoEventgridDataConnection#skip_first_record}
    */
    readonly skipFirstRecord?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#storage_account_id KustoEventgridDataConnection#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#table_name KustoEventgridDataConnection#table_name}
    */
    readonly tableName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#timeouts KustoEventgridDataConnection#timeouts}
    */
    readonly timeouts?: KustoEventgridDataConnectionTimeouts;
}
export interface KustoEventgridDataConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#create KustoEventgridDataConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#delete KustoEventgridDataConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#read KustoEventgridDataConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#update KustoEventgridDataConnection#update}
    */
    readonly update?: string;
}
export declare function kustoEventgridDataConnectionTimeoutsToTerraform(struct?: KustoEventgridDataConnectionTimeoutsOutputReference | KustoEventgridDataConnectionTimeouts | cdktf.IResolvable): any;
export declare class KustoEventgridDataConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KustoEventgridDataConnectionTimeouts | undefined;
    set internalValue(value: KustoEventgridDataConnectionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection azurerm_kusto_eventgrid_data_connection}
*/
export declare class KustoEventgridDataConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kusto_eventgrid_data_connection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection azurerm_kusto_eventgrid_data_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KustoEventgridDataConnectionConfig
    */
    constructor(scope: Construct, id: string, config: KustoEventgridDataConnectionConfig);
    private _blobStorageEventType?;
    get blobStorageEventType(): string;
    set blobStorageEventType(value: string);
    resetBlobStorageEventType(): void;
    get blobStorageEventTypeInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _dataFormat?;
    get dataFormat(): string;
    set dataFormat(value: string);
    resetDataFormat(): void;
    get dataFormatInput(): string | undefined;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _eventhubConsumerGroupName?;
    get eventhubConsumerGroupName(): string;
    set eventhubConsumerGroupName(value: string);
    get eventhubConsumerGroupNameInput(): string | undefined;
    private _eventhubId?;
    get eventhubId(): string;
    set eventhubId(value: string);
    get eventhubIdInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mappingRuleName?;
    get mappingRuleName(): string;
    set mappingRuleName(value: string);
    resetMappingRuleName(): void;
    get mappingRuleNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skipFirstRecord?;
    get skipFirstRecord(): boolean | cdktf.IResolvable;
    set skipFirstRecord(value: boolean | cdktf.IResolvable);
    resetSkipFirstRecord(): void;
    get skipFirstRecordInput(): boolean | cdktf.IResolvable | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _tableName?;
    get tableName(): string;
    set tableName(value: string);
    resetTableName(): void;
    get tableNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): KustoEventgridDataConnectionTimeoutsOutputReference;
    putTimeouts(value: KustoEventgridDataConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): KustoEventgridDataConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
