import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MariadbVirtualNetworkRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_virtual_network_rule#name MariadbVirtualNetworkRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_virtual_network_rule#resource_group_name MariadbVirtualNetworkRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_virtual_network_rule#server_name MariadbVirtualNetworkRule#server_name}
    */
    readonly serverName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_virtual_network_rule#subnet_id MariadbVirtualNetworkRule#subnet_id}
    */
    readonly subnetId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_virtual_network_rule#timeouts MariadbVirtualNetworkRule#timeouts}
    */
    readonly timeouts?: MariadbVirtualNetworkRuleTimeouts;
}
export interface MariadbVirtualNetworkRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_virtual_network_rule#create MariadbVirtualNetworkRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_virtual_network_rule#delete MariadbVirtualNetworkRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_virtual_network_rule#read MariadbVirtualNetworkRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_virtual_network_rule#update MariadbVirtualNetworkRule#update}
    */
    readonly update?: string;
}
export declare function mariadbVirtualNetworkRuleTimeoutsToTerraform(struct?: MariadbVirtualNetworkRuleTimeoutsOutputReference | MariadbVirtualNetworkRuleTimeouts | cdktf.IResolvable): any;
export declare class MariadbVirtualNetworkRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MariadbVirtualNetworkRuleTimeouts | undefined;
    set internalValue(value: MariadbVirtualNetworkRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_virtual_network_rule azurerm_mariadb_virtual_network_rule}
*/
export declare class MariadbVirtualNetworkRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mariadb_virtual_network_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_virtual_network_rule azurerm_mariadb_virtual_network_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MariadbVirtualNetworkRuleConfig
    */
    constructor(scope: Construct, id: string, config: MariadbVirtualNetworkRuleConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): MariadbVirtualNetworkRuleTimeoutsOutputReference;
    putTimeouts(value: MariadbVirtualNetworkRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MariadbVirtualNetworkRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
