import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorActionGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#enabled MonitorActionGroup#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#resource_group_name MonitorActionGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#short_name MonitorActionGroup#short_name}
    */
    readonly shortName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#tags MonitorActionGroup#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * arm_role_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#arm_role_receiver MonitorActionGroup#arm_role_receiver}
    */
    readonly armRoleReceiver?: MonitorActionGroupArmRoleReceiver[] | cdktf.IResolvable;
    /**
    * automation_runbook_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#automation_runbook_receiver MonitorActionGroup#automation_runbook_receiver}
    */
    readonly automationRunbookReceiver?: MonitorActionGroupAutomationRunbookReceiver[] | cdktf.IResolvable;
    /**
    * azure_app_push_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#azure_app_push_receiver MonitorActionGroup#azure_app_push_receiver}
    */
    readonly azureAppPushReceiver?: MonitorActionGroupAzureAppPushReceiver[] | cdktf.IResolvable;
    /**
    * azure_function_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#azure_function_receiver MonitorActionGroup#azure_function_receiver}
    */
    readonly azureFunctionReceiver?: MonitorActionGroupAzureFunctionReceiver[] | cdktf.IResolvable;
    /**
    * email_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#email_receiver MonitorActionGroup#email_receiver}
    */
    readonly emailReceiver?: MonitorActionGroupEmailReceiver[] | cdktf.IResolvable;
    /**
    * event_hub_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#event_hub_receiver MonitorActionGroup#event_hub_receiver}
    */
    readonly eventHubReceiver?: MonitorActionGroupEventHubReceiver[] | cdktf.IResolvable;
    /**
    * itsm_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#itsm_receiver MonitorActionGroup#itsm_receiver}
    */
    readonly itsmReceiver?: MonitorActionGroupItsmReceiver[] | cdktf.IResolvable;
    /**
    * logic_app_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#logic_app_receiver MonitorActionGroup#logic_app_receiver}
    */
    readonly logicAppReceiver?: MonitorActionGroupLogicAppReceiver[] | cdktf.IResolvable;
    /**
    * sms_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#sms_receiver MonitorActionGroup#sms_receiver}
    */
    readonly smsReceiver?: MonitorActionGroupSmsReceiver[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#timeouts MonitorActionGroup#timeouts}
    */
    readonly timeouts?: MonitorActionGroupTimeouts;
    /**
    * voice_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#voice_receiver MonitorActionGroup#voice_receiver}
    */
    readonly voiceReceiver?: MonitorActionGroupVoiceReceiver[] | cdktf.IResolvable;
    /**
    * webhook_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#webhook_receiver MonitorActionGroup#webhook_receiver}
    */
    readonly webhookReceiver?: MonitorActionGroupWebhookReceiver[] | cdktf.IResolvable;
}
export interface MonitorActionGroupArmRoleReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#role_id MonitorActionGroup#role_id}
    */
    readonly roleId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupArmRoleReceiverToTerraform(struct?: MonitorActionGroupArmRoleReceiver | cdktf.IResolvable): any;
export interface MonitorActionGroupAutomationRunbookReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#automation_account_id MonitorActionGroup#automation_account_id}
    */
    readonly automationAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#is_global_runbook MonitorActionGroup#is_global_runbook}
    */
    readonly isGlobalRunbook: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#runbook_name MonitorActionGroup#runbook_name}
    */
    readonly runbookName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#service_uri MonitorActionGroup#service_uri}
    */
    readonly serviceUri: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#webhook_resource_id MonitorActionGroup#webhook_resource_id}
    */
    readonly webhookResourceId: string;
}
export declare function monitorActionGroupAutomationRunbookReceiverToTerraform(struct?: MonitorActionGroupAutomationRunbookReceiver | cdktf.IResolvable): any;
export interface MonitorActionGroupAzureAppPushReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#email_address MonitorActionGroup#email_address}
    */
    readonly emailAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
}
export declare function monitorActionGroupAzureAppPushReceiverToTerraform(struct?: MonitorActionGroupAzureAppPushReceiver | cdktf.IResolvable): any;
export interface MonitorActionGroupAzureFunctionReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#function_app_resource_id MonitorActionGroup#function_app_resource_id}
    */
    readonly functionAppResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#function_name MonitorActionGroup#function_name}
    */
    readonly functionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#http_trigger_url MonitorActionGroup#http_trigger_url}
    */
    readonly httpTriggerUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupAzureFunctionReceiverToTerraform(struct?: MonitorActionGroupAzureFunctionReceiver | cdktf.IResolvable): any;
export interface MonitorActionGroupEmailReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#email_address MonitorActionGroup#email_address}
    */
    readonly emailAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupEmailReceiverToTerraform(struct?: MonitorActionGroupEmailReceiver | cdktf.IResolvable): any;
export interface MonitorActionGroupEventHubReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#event_hub_id MonitorActionGroup#event_hub_id}
    */
    readonly eventHubId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#tenant_id MonitorActionGroup#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupEventHubReceiverToTerraform(struct?: MonitorActionGroupEventHubReceiver | cdktf.IResolvable): any;
export interface MonitorActionGroupItsmReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#connection_id MonitorActionGroup#connection_id}
    */
    readonly connectionId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#region MonitorActionGroup#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#ticket_configuration MonitorActionGroup#ticket_configuration}
    */
    readonly ticketConfiguration: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#workspace_id MonitorActionGroup#workspace_id}
    */
    readonly workspaceId: string;
}
export declare function monitorActionGroupItsmReceiverToTerraform(struct?: MonitorActionGroupItsmReceiver | cdktf.IResolvable): any;
export interface MonitorActionGroupLogicAppReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#callback_url MonitorActionGroup#callback_url}
    */
    readonly callbackUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#resource_id MonitorActionGroup#resource_id}
    */
    readonly resourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function monitorActionGroupLogicAppReceiverToTerraform(struct?: MonitorActionGroupLogicAppReceiver | cdktf.IResolvable): any;
export interface MonitorActionGroupSmsReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#country_code MonitorActionGroup#country_code}
    */
    readonly countryCode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#phone_number MonitorActionGroup#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function monitorActionGroupSmsReceiverToTerraform(struct?: MonitorActionGroupSmsReceiver | cdktf.IResolvable): any;
export interface MonitorActionGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#create MonitorActionGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#delete MonitorActionGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#read MonitorActionGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#update MonitorActionGroup#update}
    */
    readonly update?: string;
}
export declare function monitorActionGroupTimeoutsToTerraform(struct?: MonitorActionGroupTimeoutsOutputReference | MonitorActionGroupTimeouts | cdktf.IResolvable): any;
export declare class MonitorActionGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionGroupTimeouts | undefined;
    set internalValue(value: MonitorActionGroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface MonitorActionGroupVoiceReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#country_code MonitorActionGroup#country_code}
    */
    readonly countryCode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#phone_number MonitorActionGroup#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function monitorActionGroupVoiceReceiverToTerraform(struct?: MonitorActionGroupVoiceReceiver | cdktf.IResolvable): any;
export interface MonitorActionGroupWebhookReceiverAadAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#identifier_uri MonitorActionGroup#identifier_uri}
    */
    readonly identifierUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#object_id MonitorActionGroup#object_id}
    */
    readonly objectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#tenant_id MonitorActionGroup#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function monitorActionGroupWebhookReceiverAadAuthToTerraform(struct?: MonitorActionGroupWebhookReceiverAadAuthOutputReference | MonitorActionGroupWebhookReceiverAadAuth): any;
export declare class MonitorActionGroupWebhookReceiverAadAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionGroupWebhookReceiverAadAuth | undefined;
    set internalValue(value: MonitorActionGroupWebhookReceiverAadAuth | undefined);
    private _identifierUri?;
    get identifierUri(): string;
    set identifierUri(value: string);
    resetIdentifierUri(): void;
    get identifierUriInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    get objectIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export interface MonitorActionGroupWebhookReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#name MonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#service_uri MonitorActionGroup#service_uri}
    */
    readonly serviceUri: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#use_common_alert_schema MonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
    /**
    * aad_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group#aad_auth MonitorActionGroup#aad_auth}
    */
    readonly aadAuth?: MonitorActionGroupWebhookReceiverAadAuth;
}
export declare function monitorActionGroupWebhookReceiverToTerraform(struct?: MonitorActionGroupWebhookReceiver | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group azurerm_monitor_action_group}
*/
export declare class MonitorActionGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_action_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_group azurerm_monitor_action_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorActionGroupConfig
    */
    constructor(scope: Construct, id: string, config: MonitorActionGroupConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    get shortNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _armRoleReceiver?;
    get armRoleReceiver(): MonitorActionGroupArmRoleReceiver[] | cdktf.IResolvable;
    set armRoleReceiver(value: MonitorActionGroupArmRoleReceiver[] | cdktf.IResolvable);
    resetArmRoleReceiver(): void;
    get armRoleReceiverInput(): cdktf.IResolvable | MonitorActionGroupArmRoleReceiver[] | undefined;
    private _automationRunbookReceiver?;
    get automationRunbookReceiver(): MonitorActionGroupAutomationRunbookReceiver[] | cdktf.IResolvable;
    set automationRunbookReceiver(value: MonitorActionGroupAutomationRunbookReceiver[] | cdktf.IResolvable);
    resetAutomationRunbookReceiver(): void;
    get automationRunbookReceiverInput(): cdktf.IResolvable | MonitorActionGroupAutomationRunbookReceiver[] | undefined;
    private _azureAppPushReceiver?;
    get azureAppPushReceiver(): MonitorActionGroupAzureAppPushReceiver[] | cdktf.IResolvable;
    set azureAppPushReceiver(value: MonitorActionGroupAzureAppPushReceiver[] | cdktf.IResolvable);
    resetAzureAppPushReceiver(): void;
    get azureAppPushReceiverInput(): cdktf.IResolvable | MonitorActionGroupAzureAppPushReceiver[] | undefined;
    private _azureFunctionReceiver?;
    get azureFunctionReceiver(): MonitorActionGroupAzureFunctionReceiver[] | cdktf.IResolvable;
    set azureFunctionReceiver(value: MonitorActionGroupAzureFunctionReceiver[] | cdktf.IResolvable);
    resetAzureFunctionReceiver(): void;
    get azureFunctionReceiverInput(): cdktf.IResolvable | MonitorActionGroupAzureFunctionReceiver[] | undefined;
    private _emailReceiver?;
    get emailReceiver(): MonitorActionGroupEmailReceiver[] | cdktf.IResolvable;
    set emailReceiver(value: MonitorActionGroupEmailReceiver[] | cdktf.IResolvable);
    resetEmailReceiver(): void;
    get emailReceiverInput(): cdktf.IResolvable | MonitorActionGroupEmailReceiver[] | undefined;
    private _eventHubReceiver?;
    get eventHubReceiver(): MonitorActionGroupEventHubReceiver[] | cdktf.IResolvable;
    set eventHubReceiver(value: MonitorActionGroupEventHubReceiver[] | cdktf.IResolvable);
    resetEventHubReceiver(): void;
    get eventHubReceiverInput(): cdktf.IResolvable | MonitorActionGroupEventHubReceiver[] | undefined;
    private _itsmReceiver?;
    get itsmReceiver(): MonitorActionGroupItsmReceiver[] | cdktf.IResolvable;
    set itsmReceiver(value: MonitorActionGroupItsmReceiver[] | cdktf.IResolvable);
    resetItsmReceiver(): void;
    get itsmReceiverInput(): cdktf.IResolvable | MonitorActionGroupItsmReceiver[] | undefined;
    private _logicAppReceiver?;
    get logicAppReceiver(): MonitorActionGroupLogicAppReceiver[] | cdktf.IResolvable;
    set logicAppReceiver(value: MonitorActionGroupLogicAppReceiver[] | cdktf.IResolvable);
    resetLogicAppReceiver(): void;
    get logicAppReceiverInput(): cdktf.IResolvable | MonitorActionGroupLogicAppReceiver[] | undefined;
    private _smsReceiver?;
    get smsReceiver(): MonitorActionGroupSmsReceiver[] | cdktf.IResolvable;
    set smsReceiver(value: MonitorActionGroupSmsReceiver[] | cdktf.IResolvable);
    resetSmsReceiver(): void;
    get smsReceiverInput(): cdktf.IResolvable | MonitorActionGroupSmsReceiver[] | undefined;
    private _timeouts;
    get timeouts(): MonitorActionGroupTimeoutsOutputReference;
    putTimeouts(value: MonitorActionGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MonitorActionGroupTimeouts | undefined;
    private _voiceReceiver?;
    get voiceReceiver(): MonitorActionGroupVoiceReceiver[] | cdktf.IResolvable;
    set voiceReceiver(value: MonitorActionGroupVoiceReceiver[] | cdktf.IResolvable);
    resetVoiceReceiver(): void;
    get voiceReceiverInput(): cdktf.IResolvable | MonitorActionGroupVoiceReceiver[] | undefined;
    private _webhookReceiver?;
    get webhookReceiver(): MonitorActionGroupWebhookReceiver[] | cdktf.IResolvable;
    set webhookReceiver(value: MonitorActionGroupWebhookReceiver[] | cdktf.IResolvable);
    resetWebhookReceiver(): void;
    get webhookReceiverInput(): cdktf.IResolvable | MonitorActionGroupWebhookReceiver[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
