import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorPrivateLinkScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scope#name MonitorPrivateLinkScope#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scope#resource_group_name MonitorPrivateLinkScope#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scope#tags MonitorPrivateLinkScope#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scope#timeouts MonitorPrivateLinkScope#timeouts}
    */
    readonly timeouts?: MonitorPrivateLinkScopeTimeouts;
}
export interface MonitorPrivateLinkScopeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scope#create MonitorPrivateLinkScope#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scope#delete MonitorPrivateLinkScope#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scope#read MonitorPrivateLinkScope#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scope#update MonitorPrivateLinkScope#update}
    */
    readonly update?: string;
}
export declare function monitorPrivateLinkScopeTimeoutsToTerraform(struct?: MonitorPrivateLinkScopeTimeoutsOutputReference | MonitorPrivateLinkScopeTimeouts | cdktf.IResolvable): any;
export declare class MonitorPrivateLinkScopeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorPrivateLinkScopeTimeouts | undefined;
    set internalValue(value: MonitorPrivateLinkScopeTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scope azurerm_monitor_private_link_scope}
*/
export declare class MonitorPrivateLinkScope extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_private_link_scope";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scope azurerm_monitor_private_link_scope} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorPrivateLinkScopeConfig
    */
    constructor(scope: Construct, id: string, config: MonitorPrivateLinkScopeConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): MonitorPrivateLinkScopeTimeoutsOutputReference;
    putTimeouts(value: MonitorPrivateLinkScopeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MonitorPrivateLinkScopeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
