import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlVirtualNetworkRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#ignore_missing_vnet_service_endpoint MssqlVirtualNetworkRule#ignore_missing_vnet_service_endpoint}
    */
    readonly ignoreMissingVnetServiceEndpoint?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#name MssqlVirtualNetworkRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#server_id MssqlVirtualNetworkRule#server_id}
    */
    readonly serverId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#subnet_id MssqlVirtualNetworkRule#subnet_id}
    */
    readonly subnetId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#timeouts MssqlVirtualNetworkRule#timeouts}
    */
    readonly timeouts?: MssqlVirtualNetworkRuleTimeouts;
}
export interface MssqlVirtualNetworkRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#create MssqlVirtualNetworkRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#delete MssqlVirtualNetworkRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#read MssqlVirtualNetworkRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule#update MssqlVirtualNetworkRule#update}
    */
    readonly update?: string;
}
export declare function mssqlVirtualNetworkRuleTimeoutsToTerraform(struct?: MssqlVirtualNetworkRuleTimeoutsOutputReference | MssqlVirtualNetworkRuleTimeouts | cdktf.IResolvable): any;
export declare class MssqlVirtualNetworkRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualNetworkRuleTimeouts | undefined;
    set internalValue(value: MssqlVirtualNetworkRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule azurerm_mssql_virtual_network_rule}
*/
export declare class MssqlVirtualNetworkRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_virtual_network_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_network_rule azurerm_mssql_virtual_network_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlVirtualNetworkRuleConfig
    */
    constructor(scope: Construct, id: string, config: MssqlVirtualNetworkRuleConfig);
    get id(): string;
    private _ignoreMissingVnetServiceEndpoint?;
    get ignoreMissingVnetServiceEndpoint(): boolean | cdktf.IResolvable;
    set ignoreMissingVnetServiceEndpoint(value: boolean | cdktf.IResolvable);
    resetIgnoreMissingVnetServiceEndpoint(): void;
    get ignoreMissingVnetServiceEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): MssqlVirtualNetworkRuleTimeoutsOutputReference;
    putTimeouts(value: MssqlVirtualNetworkRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MssqlVirtualNetworkRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
