import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicySetDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#description PolicySetDefinition#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#display_name PolicySetDefinition#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#management_group_id PolicySetDefinition#management_group_id}
    */
    readonly managementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#management_group_name PolicySetDefinition#management_group_name}
    */
    readonly managementGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#metadata PolicySetDefinition#metadata}
    */
    readonly metadata?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#name PolicySetDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#parameters PolicySetDefinition#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_definitions PolicySetDefinition#policy_definitions}
    */
    readonly policyDefinitions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_type PolicySetDefinition#policy_type}
    */
    readonly policyType: string;
    /**
    * policy_definition_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_definition_group PolicySetDefinition#policy_definition_group}
    */
    readonly policyDefinitionGroup?: PolicySetDefinitionPolicyDefinitionGroup[] | cdktf.IResolvable;
    /**
    * policy_definition_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_definition_reference PolicySetDefinition#policy_definition_reference}
    */
    readonly policyDefinitionReference?: PolicySetDefinitionPolicyDefinitionReference[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#timeouts PolicySetDefinition#timeouts}
    */
    readonly timeouts?: PolicySetDefinitionTimeouts;
}
export interface PolicySetDefinitionPolicyDefinitionGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#additional_metadata_resource_id PolicySetDefinition#additional_metadata_resource_id}
    */
    readonly additionalMetadataResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#category PolicySetDefinition#category}
    */
    readonly category?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#description PolicySetDefinition#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#display_name PolicySetDefinition#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#name PolicySetDefinition#name}
    */
    readonly name: string;
}
export declare function policySetDefinitionPolicyDefinitionGroupToTerraform(struct?: PolicySetDefinitionPolicyDefinitionGroup | cdktf.IResolvable): any;
export interface PolicySetDefinitionPolicyDefinitionReference {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#parameter_values PolicySetDefinition#parameter_values}
    */
    readonly parameterValues?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#parameters PolicySetDefinition#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_definition_id PolicySetDefinition#policy_definition_id}
    */
    readonly policyDefinitionId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#policy_group_names PolicySetDefinition#policy_group_names}
    */
    readonly policyGroupNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#reference_id PolicySetDefinition#reference_id}
    */
    readonly referenceId?: string;
}
export declare function policySetDefinitionPolicyDefinitionReferenceToTerraform(struct?: PolicySetDefinitionPolicyDefinitionReference | cdktf.IResolvable): any;
export interface PolicySetDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#create PolicySetDefinition#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#delete PolicySetDefinition#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#read PolicySetDefinition#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition#update PolicySetDefinition#update}
    */
    readonly update?: string;
}
export declare function policySetDefinitionTimeoutsToTerraform(struct?: PolicySetDefinitionTimeoutsOutputReference | PolicySetDefinitionTimeouts | cdktf.IResolvable): any;
export declare class PolicySetDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PolicySetDefinitionTimeouts | undefined;
    set internalValue(value: PolicySetDefinitionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition azurerm_policy_set_definition}
*/
export declare class PolicySetDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_policy_set_definition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/policy_set_definition azurerm_policy_set_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicySetDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: PolicySetDefinitionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _managementGroupId?;
    get managementGroupId(): string;
    set managementGroupId(value: string);
    resetManagementGroupId(): void;
    get managementGroupIdInput(): string | undefined;
    private _managementGroupName?;
    get managementGroupName(): string;
    set managementGroupName(value: string);
    resetManagementGroupName(): void;
    get managementGroupNameInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _policyDefinitions?;
    get policyDefinitions(): string;
    set policyDefinitions(value: string);
    resetPolicyDefinitions(): void;
    get policyDefinitionsInput(): string | undefined;
    private _policyType?;
    get policyType(): string;
    set policyType(value: string);
    get policyTypeInput(): string | undefined;
    private _policyDefinitionGroup?;
    get policyDefinitionGroup(): PolicySetDefinitionPolicyDefinitionGroup[] | cdktf.IResolvable;
    set policyDefinitionGroup(value: PolicySetDefinitionPolicyDefinitionGroup[] | cdktf.IResolvable);
    resetPolicyDefinitionGroup(): void;
    get policyDefinitionGroupInput(): cdktf.IResolvable | PolicySetDefinitionPolicyDefinitionGroup[] | undefined;
    private _policyDefinitionReference?;
    get policyDefinitionReference(): PolicySetDefinitionPolicyDefinitionReference[] | cdktf.IResolvable;
    set policyDefinitionReference(value: PolicySetDefinitionPolicyDefinitionReference[] | cdktf.IResolvable);
    resetPolicyDefinitionReference(): void;
    get policyDefinitionReferenceInput(): cdktf.IResolvable | PolicySetDefinitionPolicyDefinitionReference[] | undefined;
    private _timeouts;
    get timeouts(): PolicySetDefinitionTimeoutsOutputReference;
    putTimeouts(value: PolicySetDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PolicySetDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
