import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityCenterAssessmentMetadataConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#categories SecurityCenterAssessmentMetadata#categories}
    */
    readonly categories?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#description SecurityCenterAssessmentMetadata#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#display_name SecurityCenterAssessmentMetadata#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#implementation_effort SecurityCenterAssessmentMetadata#implementation_effort}
    */
    readonly implementationEffort?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#remediation_description SecurityCenterAssessmentMetadata#remediation_description}
    */
    readonly remediationDescription?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#severity SecurityCenterAssessmentMetadata#severity}
    */
    readonly severity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#threats SecurityCenterAssessmentMetadata#threats}
    */
    readonly threats?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#user_impact SecurityCenterAssessmentMetadata#user_impact}
    */
    readonly userImpact?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#timeouts SecurityCenterAssessmentMetadata#timeouts}
    */
    readonly timeouts?: SecurityCenterAssessmentMetadataTimeouts;
}
export interface SecurityCenterAssessmentMetadataTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#create SecurityCenterAssessmentMetadata#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#delete SecurityCenterAssessmentMetadata#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#read SecurityCenterAssessmentMetadata#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata#update SecurityCenterAssessmentMetadata#update}
    */
    readonly update?: string;
}
export declare function securityCenterAssessmentMetadataTimeoutsToTerraform(struct?: SecurityCenterAssessmentMetadataTimeoutsOutputReference | SecurityCenterAssessmentMetadataTimeouts | cdktf.IResolvable): any;
export declare class SecurityCenterAssessmentMetadataTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityCenterAssessmentMetadataTimeouts | undefined;
    set internalValue(value: SecurityCenterAssessmentMetadataTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata azurerm_security_center_assessment_metadata}
*/
export declare class SecurityCenterAssessmentMetadata extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_security_center_assessment_metadata";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_metadata azurerm_security_center_assessment_metadata} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityCenterAssessmentMetadataConfig
    */
    constructor(scope: Construct, id: string, config: SecurityCenterAssessmentMetadataConfig);
    private _categories?;
    get categories(): string[];
    set categories(value: string[]);
    resetCategories(): void;
    get categoriesInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _implementationEffort?;
    get implementationEffort(): string;
    set implementationEffort(value: string);
    resetImplementationEffort(): void;
    get implementationEffortInput(): string | undefined;
    get name(): string;
    private _remediationDescription?;
    get remediationDescription(): string;
    set remediationDescription(value: string);
    resetRemediationDescription(): void;
    get remediationDescriptionInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    resetSeverity(): void;
    get severityInput(): string | undefined;
    private _threats?;
    get threats(): string[];
    set threats(value: string[]);
    resetThreats(): void;
    get threatsInput(): string[] | undefined;
    private _userImpact?;
    get userImpact(): string;
    set userImpact(value: string);
    resetUserImpact(): void;
    get userImpactInput(): string | undefined;
    private _timeouts;
    get timeouts(): SecurityCenterAssessmentMetadataTimeoutsOutputReference;
    putTimeouts(value: SecurityCenterAssessmentMetadataTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SecurityCenterAssessmentMetadataTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
