import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityCenterAutoProvisioningConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#auto_provision SecurityCenterAutoProvisioning#auto_provision}
    */
    readonly autoProvision: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#timeouts SecurityCenterAutoProvisioning#timeouts}
    */
    readonly timeouts?: SecurityCenterAutoProvisioningTimeouts;
}
export interface SecurityCenterAutoProvisioningTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#create SecurityCenterAutoProvisioning#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#delete SecurityCenterAutoProvisioning#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#read SecurityCenterAutoProvisioning#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning#update SecurityCenterAutoProvisioning#update}
    */
    readonly update?: string;
}
export declare function securityCenterAutoProvisioningTimeoutsToTerraform(struct?: SecurityCenterAutoProvisioningTimeoutsOutputReference | SecurityCenterAutoProvisioningTimeouts | cdktf.IResolvable): any;
export declare class SecurityCenterAutoProvisioningTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityCenterAutoProvisioningTimeouts | undefined;
    set internalValue(value: SecurityCenterAutoProvisioningTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning azurerm_security_center_auto_provisioning}
*/
export declare class SecurityCenterAutoProvisioning extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_security_center_auto_provisioning";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_auto_provisioning azurerm_security_center_auto_provisioning} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityCenterAutoProvisioningConfig
    */
    constructor(scope: Construct, id: string, config: SecurityCenterAutoProvisioningConfig);
    private _autoProvision?;
    get autoProvision(): string;
    set autoProvision(value: string);
    get autoProvisionInput(): string | undefined;
    get id(): string;
    private _timeouts;
    get timeouts(): SecurityCenterAutoProvisioningTimeoutsOutputReference;
    putTimeouts(value: SecurityCenterAutoProvisioningTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SecurityCenterAutoProvisioningTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
