import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SiteRecoveryFabricConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_fabric#location SiteRecoveryFabric#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_fabric#name SiteRecoveryFabric#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_fabric#recovery_vault_name SiteRecoveryFabric#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_fabric#resource_group_name SiteRecoveryFabric#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_fabric#timeouts SiteRecoveryFabric#timeouts}
    */
    readonly timeouts?: SiteRecoveryFabricTimeouts;
}
export interface SiteRecoveryFabricTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_fabric#create SiteRecoveryFabric#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_fabric#delete SiteRecoveryFabric#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_fabric#read SiteRecoveryFabric#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_fabric#update SiteRecoveryFabric#update}
    */
    readonly update?: string;
}
export declare function siteRecoveryFabricTimeoutsToTerraform(struct?: SiteRecoveryFabricTimeoutsOutputReference | SiteRecoveryFabricTimeouts | cdktf.IResolvable): any;
export declare class SiteRecoveryFabricTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SiteRecoveryFabricTimeouts | undefined;
    set internalValue(value: SiteRecoveryFabricTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_fabric azurerm_site_recovery_fabric}
*/
export declare class SiteRecoveryFabric extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_site_recovery_fabric";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_fabric azurerm_site_recovery_fabric} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SiteRecoveryFabricConfig
    */
    constructor(scope: Construct, id: string, config: SiteRecoveryFabricConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): SiteRecoveryFabricTimeoutsOutputReference;
    putTimeouts(value: SiteRecoveryFabricTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SiteRecoveryFabricTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
